<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString7 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString7 extends AbstractStructArrayBase
{
    /**
     * The RoomFacility
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $RoomFacility;
    /**
     * Constructor method for ArrayOfString7
     * @uses ArrayOfString7::setRoomFacility()
     * @param string[] $roomFacility
     */
    public function __construct(array $roomFacility = array())
    {
        $this
            ->setRoomFacility($roomFacility);
    }
    /**
     * Get RoomFacility value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getRoomFacility()
    {
        return isset($this->RoomFacility) ? $this->RoomFacility : null;
    }
    /**
     * Set RoomFacility value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $roomFacility
     * @return \ArrayType\ArrayOfString7
     */
    public function setRoomFacility(array $roomFacility = array())
    {
        foreach ($roomFacility as $arrayOfString7RoomFacilityItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString7RoomFacilityItem)) {
                throw new \InvalidArgumentException(sprintf('The RoomFacility property can only contain items of string, "%s" given', is_object($arrayOfString7RoomFacilityItem) ? get_class($arrayOfString7RoomFacilityItem) : gettype($arrayOfString7RoomFacilityItem)), __LINE__);
            }
        }
        if (is_null($roomFacility) || (is_array($roomFacility) && empty($roomFacility))) {
            unset($this->RoomFacility);
        } else {
            $this->RoomFacility = $roomFacility;
        }
        return $this;
    }
    /**
     * Add item to RoomFacility value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString7
     */
    public function addToRoomFacility($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The RoomFacility property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomFacility[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RoomFacility
     */
    public function getAttributeName()
    {
        return 'RoomFacility';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfString7
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
