<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString1 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString1 extends AbstractStructArrayBase
{
    /**
     * The Amenity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Amenity;
    /**
     * Constructor method for ArrayOfString1
     * @uses ArrayOfString1::setAmenity()
     * @param string[] $amenity
     */
    public function __construct(array $amenity = array())
    {
        $this
            ->setAmenity($amenity);
    }
    /**
     * Get Amenity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAmenity()
    {
        return isset($this->Amenity) ? $this->Amenity : null;
    }
    /**
     * Set Amenity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $amenity
     * @return \ArrayType\ArrayOfString1
     */
    public function setAmenity(array $amenity = array())
    {
        foreach ($amenity as $arrayOfString1AmenityItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString1AmenityItem)) {
                throw new \InvalidArgumentException(sprintf('The Amenity property can only contain items of string, "%s" given', is_object($arrayOfString1AmenityItem) ? get_class($arrayOfString1AmenityItem) : gettype($arrayOfString1AmenityItem)), __LINE__);
            }
        }
        if (is_null($amenity) || (is_array($amenity) && empty($amenity))) {
            unset($this->Amenity);
        } else {
            $this->Amenity = $amenity;
        }
        return $this;
    }
    /**
     * Add item to Amenity value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString1
     */
    public function addToAmenity($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Amenity property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Amenity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Amenity
     */
    public function getAttributeName()
    {
        return 'Amenity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfString1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
