<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRooms ArrayType
 * @subpackage Arrays
 */
class ArrayOfRooms extends AbstractStructArrayBase
{
    /**
     * The Room
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Rooms[]
     */
    public $Room;
    /**
     * Constructor method for ArrayOfRooms
     * @uses ArrayOfRooms::setRoom()
     * @param \StructType\Rooms[] $room
     */
    public function __construct(array $room = array())
    {
        $this
            ->setRoom($room);
    }
    /**
     * Get Room value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Rooms[]|null
     */
    public function getRoom()
    {
        return isset($this->Room) ? $this->Room : null;
    }
    /**
     * Set Room value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Rooms[] $room
     * @return \ArrayType\ArrayOfRooms
     */
    public function setRoom(array $room = array())
    {
        foreach ($room as $arrayOfRoomsRoomItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoomsRoomItem instanceof \StructType\Rooms) {
                throw new \InvalidArgumentException(sprintf('The Room property can only contain items of \StructType\Rooms, "%s" given', is_object($arrayOfRoomsRoomItem) ? get_class($arrayOfRoomsRoomItem) : gettype($arrayOfRoomsRoomItem)), __LINE__);
            }
        }
        if (is_null($room) || (is_array($room) && empty($room))) {
            unset($this->Room);
        } else {
            $this->Room = $room;
        }
        return $this;
    }
    /**
     * Add item to Room value
     * @throws \InvalidArgumentException
     * @param \StructType\Rooms $item
     * @return \ArrayType\ArrayOfRooms
     */
    public function addToRoom(\StructType\Rooms $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Rooms) {
            throw new \InvalidArgumentException(sprintf('The Room property can only contain items of \StructType\Rooms, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Room[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Rooms|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Rooms|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Rooms|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Rooms|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Rooms|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Room
     */
    public function getAttributeName()
    {
        return 'Room';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRooms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
