<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGiataHotels ArrayType
 * @subpackage Arrays
 */
class ArrayOfGiataHotels extends AbstractStructArrayBase
{
    /**
     * The Hotel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GiataHotels[]
     */
    public $Hotel;
    /**
     * Constructor method for ArrayOfGiataHotels
     * @uses ArrayOfGiataHotels::setHotel()
     * @param \StructType\GiataHotels[] $hotel
     */
    public function __construct(array $hotel = array())
    {
        $this
            ->setHotel($hotel);
    }
    /**
     * Get Hotel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GiataHotels[]|null
     */
    public function getHotel()
    {
        return isset($this->Hotel) ? $this->Hotel : null;
    }
    /**
     * Set Hotel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GiataHotels[] $hotel
     * @return \ArrayType\ArrayOfGiataHotels
     */
    public function setHotel(array $hotel = array())
    {
        foreach ($hotel as $arrayOfGiataHotelsHotelItem) {
            // validation for constraint: itemType
            if (!$arrayOfGiataHotelsHotelItem instanceof \StructType\GiataHotels) {
                throw new \InvalidArgumentException(sprintf('The Hotel property can only contain items of \StructType\GiataHotels, "%s" given', is_object($arrayOfGiataHotelsHotelItem) ? get_class($arrayOfGiataHotelsHotelItem) : gettype($arrayOfGiataHotelsHotelItem)), __LINE__);
            }
        }
        if (is_null($hotel) || (is_array($hotel) && empty($hotel))) {
            unset($this->Hotel);
        } else {
            $this->Hotel = $hotel;
        }
        return $this;
    }
    /**
     * Add item to Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\GiataHotels $item
     * @return \ArrayType\ArrayOfGiataHotels
     */
    public function addToHotel(\StructType\GiataHotels $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GiataHotels) {
            throw new \InvalidArgumentException(sprintf('The Hotel property can only contain items of \StructType\GiataHotels, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Hotel[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GiataHotels|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GiataHotels|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GiataHotels|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GiataHotels|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GiataHotels|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Hotel
     */
    public function getAttributeName()
    {
        return 'Hotel';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfGiataHotels
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
