<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDayRate ArrayType
 * @subpackage Arrays
 */
class ArrayOfDayRate extends AbstractStructArrayBase
{
    /**
     * The DayRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DayRate[]
     */
    public $DayRate;
    /**
     * Constructor method for ArrayOfDayRate
     * @uses ArrayOfDayRate::setDayRate()
     * @param \StructType\DayRate[] $dayRate
     */
    public function __construct(array $dayRate = array())
    {
        $this
            ->setDayRate($dayRate);
    }
    /**
     * Get DayRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DayRate[]|null
     */
    public function getDayRate()
    {
        return isset($this->DayRate) ? $this->DayRate : null;
    }
    /**
     * Set DayRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DayRate[] $dayRate
     * @return \ArrayType\ArrayOfDayRate
     */
    public function setDayRate(array $dayRate = array())
    {
        foreach ($dayRate as $arrayOfDayRateDayRateItem) {
            // validation for constraint: itemType
            if (!$arrayOfDayRateDayRateItem instanceof \StructType\DayRate) {
                throw new \InvalidArgumentException(sprintf('The DayRate property can only contain items of \StructType\DayRate, "%s" given', is_object($arrayOfDayRateDayRateItem) ? get_class($arrayOfDayRateDayRateItem) : gettype($arrayOfDayRateDayRateItem)), __LINE__);
            }
        }
        if (is_null($dayRate) || (is_array($dayRate) && empty($dayRate))) {
            unset($this->DayRate);
        } else {
            $this->DayRate = $dayRate;
        }
        return $this;
    }
    /**
     * Add item to DayRate value
     * @throws \InvalidArgumentException
     * @param \StructType\DayRate $item
     * @return \ArrayType\ArrayOfDayRate
     */
    public function addToDayRate(\StructType\DayRate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DayRate) {
            throw new \InvalidArgumentException(sprintf('The DayRate property can only contain items of \StructType\DayRate, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DayRate[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DayRate|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DayRate|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DayRate|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DayRate|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DayRate|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DayRate
     */
    public function getAttributeName()
    {
        return 'DayRate';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDayRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
