<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCountryList ArrayType
 * @subpackage Arrays
 */
class ArrayOfCountryList extends AbstractStructArrayBase
{
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CountryList[]
     */
    public $Country;
    /**
     * Constructor method for ArrayOfCountryList
     * @uses ArrayOfCountryList::setCountry()
     * @param \StructType\CountryList[] $country
     */
    public function __construct(array $country = array())
    {
        $this
            ->setCountry($country);
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CountryList[]|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CountryList[] $country
     * @return \ArrayType\ArrayOfCountryList
     */
    public function setCountry(array $country = array())
    {
        foreach ($country as $arrayOfCountryListCountryItem) {
            // validation for constraint: itemType
            if (!$arrayOfCountryListCountryItem instanceof \StructType\CountryList) {
                throw new \InvalidArgumentException(sprintf('The Country property can only contain items of \StructType\CountryList, "%s" given', is_object($arrayOfCountryListCountryItem) ? get_class($arrayOfCountryListCountryItem) : gettype($arrayOfCountryListCountryItem)), __LINE__);
            }
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Add item to Country value
     * @throws \InvalidArgumentException
     * @param \StructType\CountryList $item
     * @return \ArrayType\ArrayOfCountryList
     */
    public function addToCountry(\StructType\CountryList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CountryList) {
            throw new \InvalidArgumentException(sprintf('The Country property can only contain items of \StructType\CountryList, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Country[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CountryList|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CountryList|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CountryList|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CountryList|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CountryList|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Country
     */
    public function getAttributeName()
    {
        return 'Country';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCountryList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
