<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBookingsBasedOnDate ArrayType
 * @subpackage Arrays
 */
class ArrayOfBookingsBasedOnDate extends AbstractStructArrayBase
{
    /**
     * The Booking
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BookingsBasedOnDate[]
     */
    public $Booking;
    /**
     * Constructor method for ArrayOfBookingsBasedOnDate
     * @uses ArrayOfBookingsBasedOnDate::setBooking()
     * @param \StructType\BookingsBasedOnDate[] $booking
     */
    public function __construct(array $booking = array())
    {
        $this
            ->setBooking($booking);
    }
    /**
     * Get Booking value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BookingsBasedOnDate[]|null
     */
    public function getBooking()
    {
        return isset($this->Booking) ? $this->Booking : null;
    }
    /**
     * Set Booking value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BookingsBasedOnDate[] $booking
     * @return \ArrayType\ArrayOfBookingsBasedOnDate
     */
    public function setBooking(array $booking = array())
    {
        foreach ($booking as $arrayOfBookingsBasedOnDateBookingItem) {
            // validation for constraint: itemType
            if (!$arrayOfBookingsBasedOnDateBookingItem instanceof \StructType\BookingsBasedOnDate) {
                throw new \InvalidArgumentException(sprintf('The Booking property can only contain items of \StructType\BookingsBasedOnDate, "%s" given', is_object($arrayOfBookingsBasedOnDateBookingItem) ? get_class($arrayOfBookingsBasedOnDateBookingItem) : gettype($arrayOfBookingsBasedOnDateBookingItem)), __LINE__);
            }
        }
        if (is_null($booking) || (is_array($booking) && empty($booking))) {
            unset($this->Booking);
        } else {
            $this->Booking = $booking;
        }
        return $this;
    }
    /**
     * Add item to Booking value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingsBasedOnDate $item
     * @return \ArrayType\ArrayOfBookingsBasedOnDate
     */
    public function addToBooking(\StructType\BookingsBasedOnDate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingsBasedOnDate) {
            throw new \InvalidArgumentException(sprintf('The Booking property can only contain items of \StructType\BookingsBasedOnDate, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Booking[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BookingsBasedOnDate|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BookingsBasedOnDate|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BookingsBasedOnDate|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BookingsBasedOnDate|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BookingsBasedOnDate|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Booking
     */
    public function getAttributeName()
    {
        return 'Booking';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBookingsBasedOnDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
