<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteConsignment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $consignmentCode
     * @return boolean|bool
     */
    public function deleteConsignment($consignmentCode)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteConsignment($consignmentCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteParcelFromConsignment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $consignmentCode
     * @param string $parcelNo
     * @param string $recalculateTaxAndDuty
     * @return boolean|bool
     */
    public function deleteParcelFromConsignment($consignmentCode, $parcelNo, $recalculateTaxAndDuty)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteParcelFromConsignment($consignmentCode, $parcelNo, $recalculateTaxAndDuty));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * deleteParcelFromConsignmentWithCartonId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $consignmentCode
     * @param string $cartonId
     * @param string $recalculateTaxAndDuty
     * @return boolean|bool
     */
    public function deleteParcelFromConsignmentWithCartonId($consignmentCode, $cartonId, $recalculateTaxAndDuty)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteParcelFromConsignmentWithCartonId($consignmentCode, $cartonId, $recalculateTaxAndDuty));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
