<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://dev.metapack.com/devcentre/wp-content/uploads/wsdls/5.x/ConsignmentService.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://dev.metapack.com/devcentre/wp-content/uploads/wsdls/5.x/ConsignmentService.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for update operation/method
 */
if ($update->update($consignmentCode, $updateFields) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateConsignments operation/method
 */
if ($update->updateConsignments($consignments) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Calculate ServiceType
 */
$calculate = new \ServiceType\Calculate($options);
/**
 * Sample call for calculateTaxAndDuty operation/method
 */
if ($calculate->calculateTaxAndDuty($consignmentCode) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for deleteConsignment operation/method
 */
if ($delete->deleteConsignment($consignmentCode) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteParcelFromConsignment operation/method
 */
if ($delete->deleteParcelFromConsignment($consignmentCode, $parcelNo, $recalculateTaxAndDuty) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteParcelFromConsignmentWithCartonId operation/method
 */
if ($delete->deleteParcelFromConsignmentWithCartonId($consignmentCode, $cartonId, $recalculateTaxAndDuty) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
/**
 * Sample call for validateConsignments operation/method
 */
if ($validate->validateConsignments($consignments) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for createConsignments operation/method
 */
if ($create->createConsignments($consignments) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createPaperworkForParcel operation/method
 */
if ($create->createPaperworkForParcel($consignmentCode, $parcelNumber, $parameters) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createPaperworkForConsignments operation/method
 */
if ($create->createPaperworkForConsignments($consignmentCodes, $parameters) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createNextPaperworkForConsignment operation/method
 */
if ($create->createNextPaperworkForConsignment($consignmentCode, $parcelCount, $parameters) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createPaperworkForCarton operation/method
 */
if ($create->createPaperworkForCarton($consignmentCode, $cartonId, $parameters) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Mark ServiceType
 */
$mark = new \ServiceType\Mark($options);
/**
 * Sample call for markConsignmentsAsReadyToManifest operation/method
 */
if ($mark->markConsignmentsAsReadyToManifest($consignmentCodes) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for markConsignmentsAsPrinted operation/method
 */
if ($mark->markConsignmentsAsPrinted($consignmentCodes) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for markCartonReadyToManifest operation/method
 */
if ($mark->markCartonReadyToManifest($cartonId) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for markCartonPrinted operation/method
 */
if ($mark->markCartonPrinted($cartonId) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Samples for Append ServiceType
 */
$append = new \ServiceType\Append($options);
/**
 * Sample call for appendParcelsToConsignment operation/method
 */
if ($append->appendParcelsToConsignment($consignmentCode, $parcels, $recalculateTaxAndDuty) !== false) {
    print_r($append->getResult());
} else {
    print_r($append->getLastError());
}
/**
 * Samples for Pack ServiceType
 */
$pack = new \ServiceType\Pack($options);
/**
 * Sample call for packProductsToParcel operation/method
 */
if ($pack->packProductsToParcel($consignmentCode, $parcelNumber, $products, $recalculateTaxAndDuty) !== false) {
    print_r($pack->getResult());
} else {
    print_r($pack->getLastError());
}
/**
 * Samples for Unpack ServiceType
 */
$unpack = new \ServiceType\Unpack($options);
/**
 * Sample call for unpackProductsFromParcel operation/method
 */
if ($unpack->unpackProductsFromParcel($consignmentCode, $parcelNumber, $products, $recalculateTaxAndDuty) !== false) {
    print_r($unpack->getResult());
} else {
    print_r($unpack->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for addInnerToOuter operation/method
 */
if ($add->addInnerToOuter($innerConsignmentCode, $innerParcelNumber, $outerConsignmentCode, $outerParcelNumber) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addConsignmentsToGroup operation/method
 */
if ($add->addConsignmentsToGroup($consignmentCodes, $manifestGroupCode) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
/**
 * Sample call for removeInnerFromOuter operation/method
 */
if ($remove->removeInnerFromOuter($innerConsignmentCode, $innerParcelNumber) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeConsignmentsFromGroup operation/method
 */
if ($remove->removeConsignmentsFromGroup($consignmentCodes) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Void ServiceType
 */
$void = new \ServiceType\Void($options);
/**
 * Sample call for voidConsignments operation/method
 */
if ($void->voidConsignments($consignmentCodes, $reasonCode, $reason) !== false) {
    print_r($void->getResult());
} else {
    print_r($void->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \ServiceType\Find($options);
/**
 * Sample call for findConsignmentAuditRecords operation/method
 */
if ($find->findConsignmentAuditRecords($consignmentCode) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Samples for Scan ServiceType
 */
$scan = new \ServiceType\Scan($options);
/**
 * Sample call for scanOrderToManifestGroup operation/method
 */
if ($scan->scanOrderToManifestGroup($orderNumber, $manifestGroupCode) !== false) {
    print_r($scan->getResult());
} else {
    print_r($scan->getLastError());
}
/**
 * Sample call for scanCartonToManifestGroup operation/method
 */
if ($scan->scanCartonToManifestGroup($cartonId, $manifestGroupCode) !== false) {
    print_r($scan->getResult());
} else {
    print_r($scan->getLastError());
}
