<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Void ServiceType
 * @subpackage Services
 */
class Void extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named voidConsignments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $consignmentCodes
     * @param string $reasonCode
     * @param string $reason
     * @return \Model\ConsignmentActionResult[]|bool
     */
    public function voidConsignments($consignmentCodes, $reasonCode, $reason)
    {
        try {
            $this->setResult(self::getSoapClient()->voidConsignments($consignmentCodes, $reasonCode, $reason));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Model\ConsignmentActionResult[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
