<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unpack ServiceType
 * @subpackage Services
 */
class Unpack extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named unpackProductsFromParcel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $consignmentCode
     * @param string $parcelNumber
     * @param string $products
     * @param string $recalculateTaxAndDuty
     * @return boolean|bool
     */
    public function unpackProductsFromParcel($consignmentCode, $parcelNumber, $products, $recalculateTaxAndDuty)
    {
        try {
            $this->setResult(self::getSoapClient()->unpackProductsFromParcel($consignmentCode, $parcelNumber, $products, $recalculateTaxAndDuty));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
