<?php

namespace Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Property Model
 * @subpackage Structs
 */
class Property extends AbstractStructBase
{
    /**
     * The propertyName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $propertyName;
    /**
     * The propertyValue
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $propertyValue;
    /**
     * Constructor method for Property
     * @uses Property::setPropertyName()
     * @uses Property::setPropertyValue()
     * @param string $propertyName
     * @param string $propertyValue
     */
    public function __construct($propertyName = null, $propertyValue = null)
    {
        $this
            ->setPropertyName($propertyName)
            ->setPropertyValue($propertyValue);
    }
    /**
     * Get propertyName value
     * @return string|null
     */
    public function getPropertyName()
    {
        return $this->propertyName;
    }
    /**
     * Set propertyName value
     * @param string $propertyName
     * @return \Model\Property
     */
    public function setPropertyName($propertyName = null)
    {
        // validation for constraint: string
        if (!is_null($propertyName) && !is_string($propertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyName)), __LINE__);
        }
        $this->propertyName = $propertyName;
        return $this;
    }
    /**
     * Get propertyValue value
     * @return string|null
     */
    public function getPropertyValue()
    {
        return $this->propertyValue;
    }
    /**
     * Set propertyValue value
     * @param string $propertyValue
     * @return \Model\Property
     */
    public function setPropertyValue($propertyValue = null)
    {
        // validation for constraint: string
        if (!is_null($propertyValue) && !is_string($propertyValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyValue)), __LINE__);
        }
        $this->propertyValue = $propertyValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Model\Property
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
