<?php

namespace Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Product Model
 * @subpackage Structs
 */
class Product extends AbstractStructBase
{
    /**
     * The countryOfOrigin
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $countryOfOrigin;
    /**
     * The fabricContent
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $fabricContent;
    /**
     * The harmonisedProductCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $harmonisedProductCode;
    /**
     * The miscellaneousInfo
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - arrayType: soapenc:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $miscellaneousInfo;
    /**
     * The productCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $productCode;
    /**
     * The productDescription
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $productDescription;
    /**
     * The productQuantity
     * @var int
     */
    public $productQuantity;
    /**
     * The productTypeDescription
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $productTypeDescription;
    /**
     * The totalProductValue
     * @var float
     */
    public $totalProductValue;
    /**
     * The unitProductWeight
     * @var float
     */
    public $unitProductWeight;
    /**
     * Constructor method for Product
     * @uses Product::setCountryOfOrigin()
     * @uses Product::setFabricContent()
     * @uses Product::setHarmonisedProductCode()
     * @uses Product::setMiscellaneousInfo()
     * @uses Product::setProductCode()
     * @uses Product::setProductDescription()
     * @uses Product::setProductQuantity()
     * @uses Product::setProductTypeDescription()
     * @uses Product::setTotalProductValue()
     * @uses Product::setUnitProductWeight()
     * @param string $countryOfOrigin
     * @param string $fabricContent
     * @param string $harmonisedProductCode
     * @param string[] $miscellaneousInfo
     * @param string $productCode
     * @param string $productDescription
     * @param int $productQuantity
     * @param string $productTypeDescription
     * @param float $totalProductValue
     * @param float $unitProductWeight
     */
    public function __construct($countryOfOrigin = null, $fabricContent = null, $harmonisedProductCode = null, array $miscellaneousInfo = array(), $productCode = null, $productDescription = null, $productQuantity = null, $productTypeDescription = null, $totalProductValue = null, $unitProductWeight = null)
    {
        $this
            ->setCountryOfOrigin($countryOfOrigin)
            ->setFabricContent($fabricContent)
            ->setHarmonisedProductCode($harmonisedProductCode)
            ->setMiscellaneousInfo($miscellaneousInfo)
            ->setProductCode($productCode)
            ->setProductDescription($productDescription)
            ->setProductQuantity($productQuantity)
            ->setProductTypeDescription($productTypeDescription)
            ->setTotalProductValue($totalProductValue)
            ->setUnitProductWeight($unitProductWeight);
    }
    /**
     * Get countryOfOrigin value
     * @return string|null
     */
    public function getCountryOfOrigin()
    {
        return $this->countryOfOrigin;
    }
    /**
     * Set countryOfOrigin value
     * @param string $countryOfOrigin
     * @return \Model\Product
     */
    public function setCountryOfOrigin($countryOfOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfOrigin) && !is_string($countryOfOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryOfOrigin)), __LINE__);
        }
        $this->countryOfOrigin = $countryOfOrigin;
        return $this;
    }
    /**
     * Get fabricContent value
     * @return string|null
     */
    public function getFabricContent()
    {
        return $this->fabricContent;
    }
    /**
     * Set fabricContent value
     * @param string $fabricContent
     * @return \Model\Product
     */
    public function setFabricContent($fabricContent = null)
    {
        // validation for constraint: string
        if (!is_null($fabricContent) && !is_string($fabricContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fabricContent)), __LINE__);
        }
        $this->fabricContent = $fabricContent;
        return $this;
    }
    /**
     * Get harmonisedProductCode value
     * @return string|null
     */
    public function getHarmonisedProductCode()
    {
        return $this->harmonisedProductCode;
    }
    /**
     * Set harmonisedProductCode value
     * @param string $harmonisedProductCode
     * @return \Model\Product
     */
    public function setHarmonisedProductCode($harmonisedProductCode = null)
    {
        // validation for constraint: string
        if (!is_null($harmonisedProductCode) && !is_string($harmonisedProductCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($harmonisedProductCode)), __LINE__);
        }
        $this->harmonisedProductCode = $harmonisedProductCode;
        return $this;
    }
    /**
     * Get miscellaneousInfo value
     * @return string[]|null
     */
    public function getMiscellaneousInfo()
    {
        return $this->miscellaneousInfo;
    }
    /**
     * Set miscellaneousInfo value
     * @throws \InvalidArgumentException
     * @param string[] $miscellaneousInfo
     * @return \Model\Product
     */
    public function setMiscellaneousInfo(array $miscellaneousInfo = array())
    {
        foreach ($miscellaneousInfo as $productMiscellaneousInfoItem) {
            // validation for constraint: itemType
            if (!is_string($productMiscellaneousInfoItem)) {
                throw new \InvalidArgumentException(sprintf('The miscellaneousInfo property can only contain items of string, "%s" given', is_object($productMiscellaneousInfoItem) ? get_class($productMiscellaneousInfoItem) : gettype($productMiscellaneousInfoItem)), __LINE__);
            }
        }
        $this->miscellaneousInfo = $miscellaneousInfo;
        return $this;
    }
    /**
     * Add item to miscellaneousInfo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Model\Product
     */
    public function addToMiscellaneousInfo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The miscellaneousInfo property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->miscellaneousInfo[] = $item;
        return $this;
    }
    /**
     * Get productCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->productCode;
    }
    /**
     * Set productCode value
     * @param string $productCode
     * @return \Model\Product
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productCode)), __LINE__);
        }
        $this->productCode = $productCode;
        return $this;
    }
    /**
     * Get productDescription value
     * @return string|null
     */
    public function getProductDescription()
    {
        return $this->productDescription;
    }
    /**
     * Set productDescription value
     * @param string $productDescription
     * @return \Model\Product
     */
    public function setProductDescription($productDescription = null)
    {
        // validation for constraint: string
        if (!is_null($productDescription) && !is_string($productDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDescription)), __LINE__);
        }
        $this->productDescription = $productDescription;
        return $this;
    }
    /**
     * Get productQuantity value
     * @return int|null
     */
    public function getProductQuantity()
    {
        return $this->productQuantity;
    }
    /**
     * Set productQuantity value
     * @param int $productQuantity
     * @return \Model\Product
     */
    public function setProductQuantity($productQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($productQuantity) && !is_numeric($productQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productQuantity)), __LINE__);
        }
        $this->productQuantity = $productQuantity;
        return $this;
    }
    /**
     * Get productTypeDescription value
     * @return string|null
     */
    public function getProductTypeDescription()
    {
        return $this->productTypeDescription;
    }
    /**
     * Set productTypeDescription value
     * @param string $productTypeDescription
     * @return \Model\Product
     */
    public function setProductTypeDescription($productTypeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($productTypeDescription) && !is_string($productTypeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productTypeDescription)), __LINE__);
        }
        $this->productTypeDescription = $productTypeDescription;
        return $this;
    }
    /**
     * Get totalProductValue value
     * @return float|null
     */
    public function getTotalProductValue()
    {
        return $this->totalProductValue;
    }
    /**
     * Set totalProductValue value
     * @param float $totalProductValue
     * @return \Model\Product
     */
    public function setTotalProductValue($totalProductValue = null)
    {
        $this->totalProductValue = $totalProductValue;
        return $this;
    }
    /**
     * Get unitProductWeight value
     * @return float|null
     */
    public function getUnitProductWeight()
    {
        return $this->unitProductWeight;
    }
    /**
     * Set unitProductWeight value
     * @param float $unitProductWeight
     * @return \Model\Product
     */
    public function setUnitProductWeight($unitProductWeight = null)
    {
        $this->unitProductWeight = $unitProductWeight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Model\Product
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
