<?php

namespace Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Consignment Model
 * @subpackage Structs
 */
class Consignment extends AbstractStructBase
{
    /**
     * The CODAmount
     * @var float
     */
    public $CODAmount;
    /**
     * The CODFlag
     * @var bool
     */
    public $CODFlag;
    /**
     * The CODPaymentTypeCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CODPaymentTypeCode;
    /**
     * The CODSpecialInstruction
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CODSpecialInstruction;
    /**
     * The CODSurcharge
     * @var float
     */
    public $CODSurcharge;
    /**
     * The alreadyPalletisedGoodsFlag
     * @var bool
     */
    public $alreadyPalletisedGoodsFlag;
    /**
     * The cardNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cardNumber;
    /**
     * The carrierCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $carrierCode;
    /**
     * The carrierConsignmentCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $carrierConsignmentCode;
    /**
     * The carrierName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $carrierName;
    /**
     * The carrierServiceCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $carrierServiceCode;
    /**
     * The carrierServiceName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $carrierServiceName;
    /**
     * The carrierServiceVATRate
     * @var float
     */
    public $carrierServiceVATRate;
    /**
     * The cartonNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cartonNumber;
    /**
     * The cashOnDeliveryCurrency
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cashOnDeliveryCurrency;
    /**
     * The committedCollectionWindow
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Model\DateRange
     */
    public $committedCollectionWindow;
    /**
     * The committedDeliveryWindow
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Model\DateRange
     */
    public $committedDeliveryWindow;
    /**
     * The consDestinationReference
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $consDestinationReference;
    /**
     * The consOriginReference
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $consOriginReference;
    /**
     * The consRecipientReference
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $consRecipientReference;
    /**
     * The consReference
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $consReference;
    /**
     * The consSenderReference
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $consSenderReference;
    /**
     * The consignmentCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $consignmentCode;
    /**
     * The consignmentLevelDetailsFlag
     * @var bool
     */
    public $consignmentLevelDetailsFlag;
    /**
     * The consignmentValue
     * @var float
     */
    public $consignmentValue;
    /**
     * The consignmentValueCurrencyCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $consignmentValueCurrencyCode;
    /**
     * The consignmentValueCurrencyRate
     * @var float
     */
    public $consignmentValueCurrencyRate;
    /**
     * The consignmentWeight
     * @var float
     */
    public $consignmentWeight;
    /**
     * The custom1
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $custom1;
    /**
     * The custom10
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $custom10;
    /**
     * The custom2
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $custom2;
    /**
     * The custom3
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $custom3;
    /**
     * The custom4
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $custom4;
    /**
     * The custom5
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $custom5;
    /**
     * The custom6
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $custom6;
    /**
     * The custom7
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $custom7;
    /**
     * The custom8
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $custom8;
    /**
     * The custom9
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $custom9;
    /**
     * The customsDocumentationRequired
     * @var bool
     */
    public $customsDocumentationRequired;
    /**
     * The cutOffDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cutOffDate;
    /**
     * The despatchDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $despatchDate;
    /**
     * The earliestDeliveryDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $earliestDeliveryDate;
    /**
     * The endVatNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $endVatNumber;
    /**
     * The fragileGoodsFlag
     * @var bool
     */
    public $fragileGoodsFlag;
    /**
     * The guaranteedDeliveryDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $guaranteedDeliveryDate;
    /**
     * The hazardCodes
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - arrayType: soapenc:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $hazardCodes;
    /**
     * The hazardousGoodsFlag
     * @var bool
     */
    public $hazardousGoodsFlag;
    /**
     * The insuranceValue
     * @var float
     */
    public $insuranceValue;
    /**
     * The insuranceValueCurrencyCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $insuranceValueCurrencyCode;
    /**
     * The insuranceValueCurrencyRate
     * @var float
     */
    public $insuranceValueCurrencyRate;
    /**
     * The languageCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $languageCode;
    /**
     * The liquidGoodsFlag
     * @var bool
     */
    public $liquidGoodsFlag;
    /**
     * The manifestGroupCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $manifestGroupCode;
    /**
     * The maxDimension
     * @var float
     */
    public $maxDimension;
    /**
     * The metaCampaignKey
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $metaCampaignKey;
    /**
     * The metaCustomerKey
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $metaCustomerKey;
    /**
     * The moreThanOneMetreGoodsFlag
     * @var bool
     */
    public $moreThanOneMetreGoodsFlag;
    /**
     * The moreThanTwentyFiveKgGoodsFlag
     * @var bool
     */
    public $moreThanTwentyFiveKgGoodsFlag;
    /**
     * The orderDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $orderDate;
    /**
     * The orderNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $orderNumber;
    /**
     * The orderValue
     * @var float
     */
    public $orderValue;
    /**
     * The parcelCount
     * @var int
     */
    public $parcelCount;
    /**
     * The parcels
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - arrayType: tns1:Parcel[]
     * - ref: soapenc:arrayType
     * @var \Model\Parcel[]
     */
    public $parcels;
    /**
     * The pickTicketNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $pickTicketNumber;
    /**
     * The pickupPoint
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $pickupPoint;
    /**
     * The podRequired
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $podRequired;
    /**
     * The properties
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - arrayType: tns1:Property[]
     * - ref: soapenc:arrayType
     * @var \Model\Property[]
     */
    public $properties;
    /**
     * The recipientAddress
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Model\Address
     */
    public $recipientAddress;
    /**
     * The recipientCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $recipientCode;
    /**
     * The recipientContactPhone
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $recipientContactPhone;
    /**
     * The recipientEmail
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $recipientEmail;
    /**
     * The recipientFirstName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $recipientFirstName;
    /**
     * The recipientLastName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $recipientLastName;
    /**
     * The recipientMobilePhone
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $recipientMobilePhone;
    /**
     * The recipientName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $recipientName;
    /**
     * The recipientNotificationType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $recipientNotificationType;
    /**
     * The recipientPhone
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $recipientPhone;
    /**
     * The recipientTimeZone
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $recipientTimeZone;
    /**
     * The recipientTitle
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $recipientTitle;
    /**
     * The recipientVatNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $recipientVatNumber;
    /**
     * The returnAddress
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Model\Address
     */
    public $returnAddress;
    /**
     * The returnEmail
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $returnEmail;
    /**
     * The returnFirstName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $returnFirstName;
    /**
     * The returnLastName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $returnLastName;
    /**
     * The returnMobile
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $returnMobile;
    /**
     * The returnName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $returnName;
    /**
     * The returnPhone
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $returnPhone;
    /**
     * The returnTitle
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $returnTitle;
    /**
     * The senderAddress
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Model\Address
     */
    public $senderAddress;
    /**
     * The senderCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $senderCode;
    /**
     * The senderContactPhone
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $senderContactPhone;
    /**
     * The senderEmail
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $senderEmail;
    /**
     * The senderFirstName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $senderFirstName;
    /**
     * The senderLastName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $senderLastName;
    /**
     * The senderMobilePhone
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $senderMobilePhone;
    /**
     * The senderName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $senderName;
    /**
     * The senderNotificationType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $senderNotificationType;
    /**
     * The senderPhone
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $senderPhone;
    /**
     * The senderTimeZone
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $senderTimeZone;
    /**
     * The senderTitle
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $senderTitle;
    /**
     * The senderVatNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $senderVatNumber;
    /**
     * The shipmentTypeCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $shipmentTypeCode;
    /**
     * The shippingAccount
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $shippingAccount;
    /**
     * The shippingCharge
     * @var float
     */
    public $shippingCharge;
    /**
     * The shippingChargeCurrencyCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $shippingChargeCurrencyCode;
    /**
     * The shippingChargeCurrencyRate
     * @var float
     */
    public $shippingChargeCurrencyRate;
    /**
     * The shippingCost
     * @var float
     */
    public $shippingCost;
    /**
     * The shippingCostCurrencyCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $shippingCostCurrencyCode;
    /**
     * The shippingCostCurrencyRate
     * @var float
     */
    public $shippingCostCurrencyRate;
    /**
     * The signatoryOnCustoms
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $signatoryOnCustoms;
    /**
     * The specialInstructions1
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $specialInstructions1;
    /**
     * The specialInstructions2
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $specialInstructions2;
    /**
     * The startVatNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $startVatNumber;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $status;
    /**
     * The taxAndDuty
     * @var float
     */
    public $taxAndDuty;
    /**
     * The taxAndDutyCurrencyCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $taxAndDutyCurrencyCode;
    /**
     * The taxAndDutyCurrencyRate
     * @var float
     */
    public $taxAndDutyCurrencyRate;
    /**
     * The taxAndDutyStatusText
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $taxAndDutyStatusText;
    /**
     * The taxDutyDeclarationCurrencyCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $taxDutyDeclarationCurrencyCode;
    /**
     * The termsOfTradeCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $termsOfTradeCode;
    /**
     * The transactionType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $transactionType;
    /**
     * The twoManLiftFlag
     * @var bool
     */
    public $twoManLiftFlag;
    /**
     * Constructor method for Consignment
     * @uses Consignment::setCODAmount()
     * @uses Consignment::setCODFlag()
     * @uses Consignment::setCODPaymentTypeCode()
     * @uses Consignment::setCODSpecialInstruction()
     * @uses Consignment::setCODSurcharge()
     * @uses Consignment::setAlreadyPalletisedGoodsFlag()
     * @uses Consignment::setCardNumber()
     * @uses Consignment::setCarrierCode()
     * @uses Consignment::setCarrierConsignmentCode()
     * @uses Consignment::setCarrierName()
     * @uses Consignment::setCarrierServiceCode()
     * @uses Consignment::setCarrierServiceName()
     * @uses Consignment::setCarrierServiceVATRate()
     * @uses Consignment::setCartonNumber()
     * @uses Consignment::setCashOnDeliveryCurrency()
     * @uses Consignment::setCommittedCollectionWindow()
     * @uses Consignment::setCommittedDeliveryWindow()
     * @uses Consignment::setConsDestinationReference()
     * @uses Consignment::setConsOriginReference()
     * @uses Consignment::setConsRecipientReference()
     * @uses Consignment::setConsReference()
     * @uses Consignment::setConsSenderReference()
     * @uses Consignment::setConsignmentCode()
     * @uses Consignment::setConsignmentLevelDetailsFlag()
     * @uses Consignment::setConsignmentValue()
     * @uses Consignment::setConsignmentValueCurrencyCode()
     * @uses Consignment::setConsignmentValueCurrencyRate()
     * @uses Consignment::setConsignmentWeight()
     * @uses Consignment::setCustom1()
     * @uses Consignment::setCustom10()
     * @uses Consignment::setCustom2()
     * @uses Consignment::setCustom3()
     * @uses Consignment::setCustom4()
     * @uses Consignment::setCustom5()
     * @uses Consignment::setCustom6()
     * @uses Consignment::setCustom7()
     * @uses Consignment::setCustom8()
     * @uses Consignment::setCustom9()
     * @uses Consignment::setCustomsDocumentationRequired()
     * @uses Consignment::setCutOffDate()
     * @uses Consignment::setDespatchDate()
     * @uses Consignment::setEarliestDeliveryDate()
     * @uses Consignment::setEndVatNumber()
     * @uses Consignment::setFragileGoodsFlag()
     * @uses Consignment::setGuaranteedDeliveryDate()
     * @uses Consignment::setHazardCodes()
     * @uses Consignment::setHazardousGoodsFlag()
     * @uses Consignment::setInsuranceValue()
     * @uses Consignment::setInsuranceValueCurrencyCode()
     * @uses Consignment::setInsuranceValueCurrencyRate()
     * @uses Consignment::setLanguageCode()
     * @uses Consignment::setLiquidGoodsFlag()
     * @uses Consignment::setManifestGroupCode()
     * @uses Consignment::setMaxDimension()
     * @uses Consignment::setMetaCampaignKey()
     * @uses Consignment::setMetaCustomerKey()
     * @uses Consignment::setMoreThanOneMetreGoodsFlag()
     * @uses Consignment::setMoreThanTwentyFiveKgGoodsFlag()
     * @uses Consignment::setOrderDate()
     * @uses Consignment::setOrderNumber()
     * @uses Consignment::setOrderValue()
     * @uses Consignment::setParcelCount()
     * @uses Consignment::setParcels()
     * @uses Consignment::setPickTicketNumber()
     * @uses Consignment::setPickupPoint()
     * @uses Consignment::setPodRequired()
     * @uses Consignment::setProperties()
     * @uses Consignment::setRecipientAddress()
     * @uses Consignment::setRecipientCode()
     * @uses Consignment::setRecipientContactPhone()
     * @uses Consignment::setRecipientEmail()
     * @uses Consignment::setRecipientFirstName()
     * @uses Consignment::setRecipientLastName()
     * @uses Consignment::setRecipientMobilePhone()
     * @uses Consignment::setRecipientName()
     * @uses Consignment::setRecipientNotificationType()
     * @uses Consignment::setRecipientPhone()
     * @uses Consignment::setRecipientTimeZone()
     * @uses Consignment::setRecipientTitle()
     * @uses Consignment::setRecipientVatNumber()
     * @uses Consignment::setReturnAddress()
     * @uses Consignment::setReturnEmail()
     * @uses Consignment::setReturnFirstName()
     * @uses Consignment::setReturnLastName()
     * @uses Consignment::setReturnMobile()
     * @uses Consignment::setReturnName()
     * @uses Consignment::setReturnPhone()
     * @uses Consignment::setReturnTitle()
     * @uses Consignment::setSenderAddress()
     * @uses Consignment::setSenderCode()
     * @uses Consignment::setSenderContactPhone()
     * @uses Consignment::setSenderEmail()
     * @uses Consignment::setSenderFirstName()
     * @uses Consignment::setSenderLastName()
     * @uses Consignment::setSenderMobilePhone()
     * @uses Consignment::setSenderName()
     * @uses Consignment::setSenderNotificationType()
     * @uses Consignment::setSenderPhone()
     * @uses Consignment::setSenderTimeZone()
     * @uses Consignment::setSenderTitle()
     * @uses Consignment::setSenderVatNumber()
     * @uses Consignment::setShipmentTypeCode()
     * @uses Consignment::setShippingAccount()
     * @uses Consignment::setShippingCharge()
     * @uses Consignment::setShippingChargeCurrencyCode()
     * @uses Consignment::setShippingChargeCurrencyRate()
     * @uses Consignment::setShippingCost()
     * @uses Consignment::setShippingCostCurrencyCode()
     * @uses Consignment::setShippingCostCurrencyRate()
     * @uses Consignment::setSignatoryOnCustoms()
     * @uses Consignment::setSpecialInstructions1()
     * @uses Consignment::setSpecialInstructions2()
     * @uses Consignment::setStartVatNumber()
     * @uses Consignment::setStatus()
     * @uses Consignment::setTaxAndDuty()
     * @uses Consignment::setTaxAndDutyCurrencyCode()
     * @uses Consignment::setTaxAndDutyCurrencyRate()
     * @uses Consignment::setTaxAndDutyStatusText()
     * @uses Consignment::setTaxDutyDeclarationCurrencyCode()
     * @uses Consignment::setTermsOfTradeCode()
     * @uses Consignment::setTransactionType()
     * @uses Consignment::setTwoManLiftFlag()
     * @param float $cODAmount
     * @param bool $cODFlag
     * @param string $cODPaymentTypeCode
     * @param string $cODSpecialInstruction
     * @param float $cODSurcharge
     * @param bool $alreadyPalletisedGoodsFlag
     * @param string $cardNumber
     * @param string $carrierCode
     * @param string $carrierConsignmentCode
     * @param string $carrierName
     * @param string $carrierServiceCode
     * @param string $carrierServiceName
     * @param float $carrierServiceVATRate
     * @param string $cartonNumber
     * @param string $cashOnDeliveryCurrency
     * @param \Model\DateRange $committedCollectionWindow
     * @param \Model\DateRange $committedDeliveryWindow
     * @param string $consDestinationReference
     * @param string $consOriginReference
     * @param string $consRecipientReference
     * @param string $consReference
     * @param string $consSenderReference
     * @param string $consignmentCode
     * @param bool $consignmentLevelDetailsFlag
     * @param float $consignmentValue
     * @param string $consignmentValueCurrencyCode
     * @param float $consignmentValueCurrencyRate
     * @param float $consignmentWeight
     * @param string $custom1
     * @param string $custom10
     * @param string $custom2
     * @param string $custom3
     * @param string $custom4
     * @param string $custom5
     * @param string $custom6
     * @param string $custom7
     * @param string $custom8
     * @param string $custom9
     * @param bool $customsDocumentationRequired
     * @param string $cutOffDate
     * @param string $despatchDate
     * @param string $earliestDeliveryDate
     * @param string $endVatNumber
     * @param bool $fragileGoodsFlag
     * @param string $guaranteedDeliveryDate
     * @param string[] $hazardCodes
     * @param bool $hazardousGoodsFlag
     * @param float $insuranceValue
     * @param string $insuranceValueCurrencyCode
     * @param float $insuranceValueCurrencyRate
     * @param string $languageCode
     * @param bool $liquidGoodsFlag
     * @param string $manifestGroupCode
     * @param float $maxDimension
     * @param string $metaCampaignKey
     * @param string $metaCustomerKey
     * @param bool $moreThanOneMetreGoodsFlag
     * @param bool $moreThanTwentyFiveKgGoodsFlag
     * @param string $orderDate
     * @param string $orderNumber
     * @param float $orderValue
     * @param int $parcelCount
     * @param \Model\Parcel[] $parcels
     * @param string $pickTicketNumber
     * @param string $pickupPoint
     * @param string $podRequired
     * @param \Model\Property[] $properties
     * @param \Model\Address $recipientAddress
     * @param string $recipientCode
     * @param string $recipientContactPhone
     * @param string $recipientEmail
     * @param string $recipientFirstName
     * @param string $recipientLastName
     * @param string $recipientMobilePhone
     * @param string $recipientName
     * @param string $recipientNotificationType
     * @param string $recipientPhone
     * @param string $recipientTimeZone
     * @param string $recipientTitle
     * @param string $recipientVatNumber
     * @param \Model\Address $returnAddress
     * @param string $returnEmail
     * @param string $returnFirstName
     * @param string $returnLastName
     * @param string $returnMobile
     * @param string $returnName
     * @param string $returnPhone
     * @param string $returnTitle
     * @param \Model\Address $senderAddress
     * @param string $senderCode
     * @param string $senderContactPhone
     * @param string $senderEmail
     * @param string $senderFirstName
     * @param string $senderLastName
     * @param string $senderMobilePhone
     * @param string $senderName
     * @param string $senderNotificationType
     * @param string $senderPhone
     * @param string $senderTimeZone
     * @param string $senderTitle
     * @param string $senderVatNumber
     * @param string $shipmentTypeCode
     * @param string $shippingAccount
     * @param float $shippingCharge
     * @param string $shippingChargeCurrencyCode
     * @param float $shippingChargeCurrencyRate
     * @param float $shippingCost
     * @param string $shippingCostCurrencyCode
     * @param float $shippingCostCurrencyRate
     * @param string $signatoryOnCustoms
     * @param string $specialInstructions1
     * @param string $specialInstructions2
     * @param string $startVatNumber
     * @param string $status
     * @param float $taxAndDuty
     * @param string $taxAndDutyCurrencyCode
     * @param float $taxAndDutyCurrencyRate
     * @param string $taxAndDutyStatusText
     * @param string $taxDutyDeclarationCurrencyCode
     * @param string $termsOfTradeCode
     * @param string $transactionType
     * @param bool $twoManLiftFlag
     */
    public function __construct($cODAmount = null, $cODFlag = null, $cODPaymentTypeCode = null, $cODSpecialInstruction = null, $cODSurcharge = null, $alreadyPalletisedGoodsFlag = null, $cardNumber = null, $carrierCode = null, $carrierConsignmentCode = null, $carrierName = null, $carrierServiceCode = null, $carrierServiceName = null, $carrierServiceVATRate = null, $cartonNumber = null, $cashOnDeliveryCurrency = null, \Model\DateRange $committedCollectionWindow = null, \Model\DateRange $committedDeliveryWindow = null, $consDestinationReference = null, $consOriginReference = null, $consRecipientReference = null, $consReference = null, $consSenderReference = null, $consignmentCode = null, $consignmentLevelDetailsFlag = null, $consignmentValue = null, $consignmentValueCurrencyCode = null, $consignmentValueCurrencyRate = null, $consignmentWeight = null, $custom1 = null, $custom10 = null, $custom2 = null, $custom3 = null, $custom4 = null, $custom5 = null, $custom6 = null, $custom7 = null, $custom8 = null, $custom9 = null, $customsDocumentationRequired = null, $cutOffDate = null, $despatchDate = null, $earliestDeliveryDate = null, $endVatNumber = null, $fragileGoodsFlag = null, $guaranteedDeliveryDate = null, array $hazardCodes = array(), $hazardousGoodsFlag = null, $insuranceValue = null, $insuranceValueCurrencyCode = null, $insuranceValueCurrencyRate = null, $languageCode = null, $liquidGoodsFlag = null, $manifestGroupCode = null, $maxDimension = null, $metaCampaignKey = null, $metaCustomerKey = null, $moreThanOneMetreGoodsFlag = null, $moreThanTwentyFiveKgGoodsFlag = null, $orderDate = null, $orderNumber = null, $orderValue = null, $parcelCount = null, array $parcels = array(), $pickTicketNumber = null, $pickupPoint = null, $podRequired = null, array $properties = array(), \Model\Address $recipientAddress = null, $recipientCode = null, $recipientContactPhone = null, $recipientEmail = null, $recipientFirstName = null, $recipientLastName = null, $recipientMobilePhone = null, $recipientName = null, $recipientNotificationType = null, $recipientPhone = null, $recipientTimeZone = null, $recipientTitle = null, $recipientVatNumber = null, \Model\Address $returnAddress = null, $returnEmail = null, $returnFirstName = null, $returnLastName = null, $returnMobile = null, $returnName = null, $returnPhone = null, $returnTitle = null, \Model\Address $senderAddress = null, $senderCode = null, $senderContactPhone = null, $senderEmail = null, $senderFirstName = null, $senderLastName = null, $senderMobilePhone = null, $senderName = null, $senderNotificationType = null, $senderPhone = null, $senderTimeZone = null, $senderTitle = null, $senderVatNumber = null, $shipmentTypeCode = null, $shippingAccount = null, $shippingCharge = null, $shippingChargeCurrencyCode = null, $shippingChargeCurrencyRate = null, $shippingCost = null, $shippingCostCurrencyCode = null, $shippingCostCurrencyRate = null, $signatoryOnCustoms = null, $specialInstructions1 = null, $specialInstructions2 = null, $startVatNumber = null, $status = null, $taxAndDuty = null, $taxAndDutyCurrencyCode = null, $taxAndDutyCurrencyRate = null, $taxAndDutyStatusText = null, $taxDutyDeclarationCurrencyCode = null, $termsOfTradeCode = null, $transactionType = null, $twoManLiftFlag = null)
    {
        $this
            ->setCODAmount($cODAmount)
            ->setCODFlag($cODFlag)
            ->setCODPaymentTypeCode($cODPaymentTypeCode)
            ->setCODSpecialInstruction($cODSpecialInstruction)
            ->setCODSurcharge($cODSurcharge)
            ->setAlreadyPalletisedGoodsFlag($alreadyPalletisedGoodsFlag)
            ->setCardNumber($cardNumber)
            ->setCarrierCode($carrierCode)
            ->setCarrierConsignmentCode($carrierConsignmentCode)
            ->setCarrierName($carrierName)
            ->setCarrierServiceCode($carrierServiceCode)
            ->setCarrierServiceName($carrierServiceName)
            ->setCarrierServiceVATRate($carrierServiceVATRate)
            ->setCartonNumber($cartonNumber)
            ->setCashOnDeliveryCurrency($cashOnDeliveryCurrency)
            ->setCommittedCollectionWindow($committedCollectionWindow)
            ->setCommittedDeliveryWindow($committedDeliveryWindow)
            ->setConsDestinationReference($consDestinationReference)
            ->setConsOriginReference($consOriginReference)
            ->setConsRecipientReference($consRecipientReference)
            ->setConsReference($consReference)
            ->setConsSenderReference($consSenderReference)
            ->setConsignmentCode($consignmentCode)
            ->setConsignmentLevelDetailsFlag($consignmentLevelDetailsFlag)
            ->setConsignmentValue($consignmentValue)
            ->setConsignmentValueCurrencyCode($consignmentValueCurrencyCode)
            ->setConsignmentValueCurrencyRate($consignmentValueCurrencyRate)
            ->setConsignmentWeight($consignmentWeight)
            ->setCustom1($custom1)
            ->setCustom10($custom10)
            ->setCustom2($custom2)
            ->setCustom3($custom3)
            ->setCustom4($custom4)
            ->setCustom5($custom5)
            ->setCustom6($custom6)
            ->setCustom7($custom7)
            ->setCustom8($custom8)
            ->setCustom9($custom9)
            ->setCustomsDocumentationRequired($customsDocumentationRequired)
            ->setCutOffDate($cutOffDate)
            ->setDespatchDate($despatchDate)
            ->setEarliestDeliveryDate($earliestDeliveryDate)
            ->setEndVatNumber($endVatNumber)
            ->setFragileGoodsFlag($fragileGoodsFlag)
            ->setGuaranteedDeliveryDate($guaranteedDeliveryDate)
            ->setHazardCodes($hazardCodes)
            ->setHazardousGoodsFlag($hazardousGoodsFlag)
            ->setInsuranceValue($insuranceValue)
            ->setInsuranceValueCurrencyCode($insuranceValueCurrencyCode)
            ->setInsuranceValueCurrencyRate($insuranceValueCurrencyRate)
            ->setLanguageCode($languageCode)
            ->setLiquidGoodsFlag($liquidGoodsFlag)
            ->setManifestGroupCode($manifestGroupCode)
            ->setMaxDimension($maxDimension)
            ->setMetaCampaignKey($metaCampaignKey)
            ->setMetaCustomerKey($metaCustomerKey)
            ->setMoreThanOneMetreGoodsFlag($moreThanOneMetreGoodsFlag)
            ->setMoreThanTwentyFiveKgGoodsFlag($moreThanTwentyFiveKgGoodsFlag)
            ->setOrderDate($orderDate)
            ->setOrderNumber($orderNumber)
            ->setOrderValue($orderValue)
            ->setParcelCount($parcelCount)
            ->setParcels($parcels)
            ->setPickTicketNumber($pickTicketNumber)
            ->setPickupPoint($pickupPoint)
            ->setPodRequired($podRequired)
            ->setProperties($properties)
            ->setRecipientAddress($recipientAddress)
            ->setRecipientCode($recipientCode)
            ->setRecipientContactPhone($recipientContactPhone)
            ->setRecipientEmail($recipientEmail)
            ->setRecipientFirstName($recipientFirstName)
            ->setRecipientLastName($recipientLastName)
            ->setRecipientMobilePhone($recipientMobilePhone)
            ->setRecipientName($recipientName)
            ->setRecipientNotificationType($recipientNotificationType)
            ->setRecipientPhone($recipientPhone)
            ->setRecipientTimeZone($recipientTimeZone)
            ->setRecipientTitle($recipientTitle)
            ->setRecipientVatNumber($recipientVatNumber)
            ->setReturnAddress($returnAddress)
            ->setReturnEmail($returnEmail)
            ->setReturnFirstName($returnFirstName)
            ->setReturnLastName($returnLastName)
            ->setReturnMobile($returnMobile)
            ->setReturnName($returnName)
            ->setReturnPhone($returnPhone)
            ->setReturnTitle($returnTitle)
            ->setSenderAddress($senderAddress)
            ->setSenderCode($senderCode)
            ->setSenderContactPhone($senderContactPhone)
            ->setSenderEmail($senderEmail)
            ->setSenderFirstName($senderFirstName)
            ->setSenderLastName($senderLastName)
            ->setSenderMobilePhone($senderMobilePhone)
            ->setSenderName($senderName)
            ->setSenderNotificationType($senderNotificationType)
            ->setSenderPhone($senderPhone)
            ->setSenderTimeZone($senderTimeZone)
            ->setSenderTitle($senderTitle)
            ->setSenderVatNumber($senderVatNumber)
            ->setShipmentTypeCode($shipmentTypeCode)
            ->setShippingAccount($shippingAccount)
            ->setShippingCharge($shippingCharge)
            ->setShippingChargeCurrencyCode($shippingChargeCurrencyCode)
            ->setShippingChargeCurrencyRate($shippingChargeCurrencyRate)
            ->setShippingCost($shippingCost)
            ->setShippingCostCurrencyCode($shippingCostCurrencyCode)
            ->setShippingCostCurrencyRate($shippingCostCurrencyRate)
            ->setSignatoryOnCustoms($signatoryOnCustoms)
            ->setSpecialInstructions1($specialInstructions1)
            ->setSpecialInstructions2($specialInstructions2)
            ->setStartVatNumber($startVatNumber)
            ->setStatus($status)
            ->setTaxAndDuty($taxAndDuty)
            ->setTaxAndDutyCurrencyCode($taxAndDutyCurrencyCode)
            ->setTaxAndDutyCurrencyRate($taxAndDutyCurrencyRate)
            ->setTaxAndDutyStatusText($taxAndDutyStatusText)
            ->setTaxDutyDeclarationCurrencyCode($taxDutyDeclarationCurrencyCode)
            ->setTermsOfTradeCode($termsOfTradeCode)
            ->setTransactionType($transactionType)
            ->setTwoManLiftFlag($twoManLiftFlag);
    }
    /**
     * Get CODAmount value
     * @return float|null
     */
    public function getCODAmount()
    {
        return $this->CODAmount;
    }
    /**
     * Set CODAmount value
     * @param float $cODAmount
     * @return \Model\Consignment
     */
    public function setCODAmount($cODAmount = null)
    {
        $this->CODAmount = $cODAmount;
        return $this;
    }
    /**
     * Get CODFlag value
     * @return bool|null
     */
    public function getCODFlag()
    {
        return $this->CODFlag;
    }
    /**
     * Set CODFlag value
     * @param bool $cODFlag
     * @return \Model\Consignment
     */
    public function setCODFlag($cODFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($cODFlag) && !is_bool($cODFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cODFlag)), __LINE__);
        }
        $this->CODFlag = $cODFlag;
        return $this;
    }
    /**
     * Get CODPaymentTypeCode value
     * @return string|null
     */
    public function getCODPaymentTypeCode()
    {
        return $this->CODPaymentTypeCode;
    }
    /**
     * Set CODPaymentTypeCode value
     * @param string $cODPaymentTypeCode
     * @return \Model\Consignment
     */
    public function setCODPaymentTypeCode($cODPaymentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($cODPaymentTypeCode) && !is_string($cODPaymentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cODPaymentTypeCode)), __LINE__);
        }
        $this->CODPaymentTypeCode = $cODPaymentTypeCode;
        return $this;
    }
    /**
     * Get CODSpecialInstruction value
     * @return string|null
     */
    public function getCODSpecialInstruction()
    {
        return $this->CODSpecialInstruction;
    }
    /**
     * Set CODSpecialInstruction value
     * @param string $cODSpecialInstruction
     * @return \Model\Consignment
     */
    public function setCODSpecialInstruction($cODSpecialInstruction = null)
    {
        // validation for constraint: string
        if (!is_null($cODSpecialInstruction) && !is_string($cODSpecialInstruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cODSpecialInstruction)), __LINE__);
        }
        $this->CODSpecialInstruction = $cODSpecialInstruction;
        return $this;
    }
    /**
     * Get CODSurcharge value
     * @return float|null
     */
    public function getCODSurcharge()
    {
        return $this->CODSurcharge;
    }
    /**
     * Set CODSurcharge value
     * @param float $cODSurcharge
     * @return \Model\Consignment
     */
    public function setCODSurcharge($cODSurcharge = null)
    {
        $this->CODSurcharge = $cODSurcharge;
        return $this;
    }
    /**
     * Get alreadyPalletisedGoodsFlag value
     * @return bool|null
     */
    public function getAlreadyPalletisedGoodsFlag()
    {
        return $this->alreadyPalletisedGoodsFlag;
    }
    /**
     * Set alreadyPalletisedGoodsFlag value
     * @param bool $alreadyPalletisedGoodsFlag
     * @return \Model\Consignment
     */
    public function setAlreadyPalletisedGoodsFlag($alreadyPalletisedGoodsFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($alreadyPalletisedGoodsFlag) && !is_bool($alreadyPalletisedGoodsFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($alreadyPalletisedGoodsFlag)), __LINE__);
        }
        $this->alreadyPalletisedGoodsFlag = $alreadyPalletisedGoodsFlag;
        return $this;
    }
    /**
     * Get cardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->cardNumber;
    }
    /**
     * Set cardNumber value
     * @param string $cardNumber
     * @return \Model\Consignment
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardNumber)), __LINE__);
        }
        $this->cardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get carrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->carrierCode;
    }
    /**
     * Set carrierCode value
     * @param string $carrierCode
     * @return \Model\Consignment
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierCode)), __LINE__);
        }
        $this->carrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get carrierConsignmentCode value
     * @return string|null
     */
    public function getCarrierConsignmentCode()
    {
        return $this->carrierConsignmentCode;
    }
    /**
     * Set carrierConsignmentCode value
     * @param string $carrierConsignmentCode
     * @return \Model\Consignment
     */
    public function setCarrierConsignmentCode($carrierConsignmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierConsignmentCode) && !is_string($carrierConsignmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierConsignmentCode)), __LINE__);
        }
        $this->carrierConsignmentCode = $carrierConsignmentCode;
        return $this;
    }
    /**
     * Get carrierName value
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->carrierName;
    }
    /**
     * Set carrierName value
     * @param string $carrierName
     * @return \Model\Consignment
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierName)), __LINE__);
        }
        $this->carrierName = $carrierName;
        return $this;
    }
    /**
     * Get carrierServiceCode value
     * @return string|null
     */
    public function getCarrierServiceCode()
    {
        return $this->carrierServiceCode;
    }
    /**
     * Set carrierServiceCode value
     * @param string $carrierServiceCode
     * @return \Model\Consignment
     */
    public function setCarrierServiceCode($carrierServiceCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierServiceCode) && !is_string($carrierServiceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierServiceCode)), __LINE__);
        }
        $this->carrierServiceCode = $carrierServiceCode;
        return $this;
    }
    /**
     * Get carrierServiceName value
     * @return string|null
     */
    public function getCarrierServiceName()
    {
        return $this->carrierServiceName;
    }
    /**
     * Set carrierServiceName value
     * @param string $carrierServiceName
     * @return \Model\Consignment
     */
    public function setCarrierServiceName($carrierServiceName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierServiceName) && !is_string($carrierServiceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierServiceName)), __LINE__);
        }
        $this->carrierServiceName = $carrierServiceName;
        return $this;
    }
    /**
     * Get carrierServiceVATRate value
     * @return float|null
     */
    public function getCarrierServiceVATRate()
    {
        return $this->carrierServiceVATRate;
    }
    /**
     * Set carrierServiceVATRate value
     * @param float $carrierServiceVATRate
     * @return \Model\Consignment
     */
    public function setCarrierServiceVATRate($carrierServiceVATRate = null)
    {
        $this->carrierServiceVATRate = $carrierServiceVATRate;
        return $this;
    }
    /**
     * Get cartonNumber value
     * @return string|null
     */
    public function getCartonNumber()
    {
        return $this->cartonNumber;
    }
    /**
     * Set cartonNumber value
     * @param string $cartonNumber
     * @return \Model\Consignment
     */
    public function setCartonNumber($cartonNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cartonNumber) && !is_string($cartonNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cartonNumber)), __LINE__);
        }
        $this->cartonNumber = $cartonNumber;
        return $this;
    }
    /**
     * Get cashOnDeliveryCurrency value
     * @return string|null
     */
    public function getCashOnDeliveryCurrency()
    {
        return $this->cashOnDeliveryCurrency;
    }
    /**
     * Set cashOnDeliveryCurrency value
     * @param string $cashOnDeliveryCurrency
     * @return \Model\Consignment
     */
    public function setCashOnDeliveryCurrency($cashOnDeliveryCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($cashOnDeliveryCurrency) && !is_string($cashOnDeliveryCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cashOnDeliveryCurrency)), __LINE__);
        }
        $this->cashOnDeliveryCurrency = $cashOnDeliveryCurrency;
        return $this;
    }
    /**
     * Get committedCollectionWindow value
     * @return \Model\DateRange|null
     */
    public function getCommittedCollectionWindow()
    {
        return $this->committedCollectionWindow;
    }
    /**
     * Set committedCollectionWindow value
     * @param \Model\DateRange $committedCollectionWindow
     * @return \Model\Consignment
     */
    public function setCommittedCollectionWindow(\Model\DateRange $committedCollectionWindow = null)
    {
        $this->committedCollectionWindow = $committedCollectionWindow;
        return $this;
    }
    /**
     * Get committedDeliveryWindow value
     * @return \Model\DateRange|null
     */
    public function getCommittedDeliveryWindow()
    {
        return $this->committedDeliveryWindow;
    }
    /**
     * Set committedDeliveryWindow value
     * @param \Model\DateRange $committedDeliveryWindow
     * @return \Model\Consignment
     */
    public function setCommittedDeliveryWindow(\Model\DateRange $committedDeliveryWindow = null)
    {
        $this->committedDeliveryWindow = $committedDeliveryWindow;
        return $this;
    }
    /**
     * Get consDestinationReference value
     * @return string|null
     */
    public function getConsDestinationReference()
    {
        return $this->consDestinationReference;
    }
    /**
     * Set consDestinationReference value
     * @param string $consDestinationReference
     * @return \Model\Consignment
     */
    public function setConsDestinationReference($consDestinationReference = null)
    {
        // validation for constraint: string
        if (!is_null($consDestinationReference) && !is_string($consDestinationReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consDestinationReference)), __LINE__);
        }
        $this->consDestinationReference = $consDestinationReference;
        return $this;
    }
    /**
     * Get consOriginReference value
     * @return string|null
     */
    public function getConsOriginReference()
    {
        return $this->consOriginReference;
    }
    /**
     * Set consOriginReference value
     * @param string $consOriginReference
     * @return \Model\Consignment
     */
    public function setConsOriginReference($consOriginReference = null)
    {
        // validation for constraint: string
        if (!is_null($consOriginReference) && !is_string($consOriginReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consOriginReference)), __LINE__);
        }
        $this->consOriginReference = $consOriginReference;
        return $this;
    }
    /**
     * Get consRecipientReference value
     * @return string|null
     */
    public function getConsRecipientReference()
    {
        return $this->consRecipientReference;
    }
    /**
     * Set consRecipientReference value
     * @param string $consRecipientReference
     * @return \Model\Consignment
     */
    public function setConsRecipientReference($consRecipientReference = null)
    {
        // validation for constraint: string
        if (!is_null($consRecipientReference) && !is_string($consRecipientReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consRecipientReference)), __LINE__);
        }
        $this->consRecipientReference = $consRecipientReference;
        return $this;
    }
    /**
     * Get consReference value
     * @return string|null
     */
    public function getConsReference()
    {
        return $this->consReference;
    }
    /**
     * Set consReference value
     * @param string $consReference
     * @return \Model\Consignment
     */
    public function setConsReference($consReference = null)
    {
        // validation for constraint: string
        if (!is_null($consReference) && !is_string($consReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consReference)), __LINE__);
        }
        $this->consReference = $consReference;
        return $this;
    }
    /**
     * Get consSenderReference value
     * @return string|null
     */
    public function getConsSenderReference()
    {
        return $this->consSenderReference;
    }
    /**
     * Set consSenderReference value
     * @param string $consSenderReference
     * @return \Model\Consignment
     */
    public function setConsSenderReference($consSenderReference = null)
    {
        // validation for constraint: string
        if (!is_null($consSenderReference) && !is_string($consSenderReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consSenderReference)), __LINE__);
        }
        $this->consSenderReference = $consSenderReference;
        return $this;
    }
    /**
     * Get consignmentCode value
     * @return string|null
     */
    public function getConsignmentCode()
    {
        return $this->consignmentCode;
    }
    /**
     * Set consignmentCode value
     * @param string $consignmentCode
     * @return \Model\Consignment
     */
    public function setConsignmentCode($consignmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentCode) && !is_string($consignmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consignmentCode)), __LINE__);
        }
        $this->consignmentCode = $consignmentCode;
        return $this;
    }
    /**
     * Get consignmentLevelDetailsFlag value
     * @return bool|null
     */
    public function getConsignmentLevelDetailsFlag()
    {
        return $this->consignmentLevelDetailsFlag;
    }
    /**
     * Set consignmentLevelDetailsFlag value
     * @param bool $consignmentLevelDetailsFlag
     * @return \Model\Consignment
     */
    public function setConsignmentLevelDetailsFlag($consignmentLevelDetailsFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($consignmentLevelDetailsFlag) && !is_bool($consignmentLevelDetailsFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($consignmentLevelDetailsFlag)), __LINE__);
        }
        $this->consignmentLevelDetailsFlag = $consignmentLevelDetailsFlag;
        return $this;
    }
    /**
     * Get consignmentValue value
     * @return float|null
     */
    public function getConsignmentValue()
    {
        return $this->consignmentValue;
    }
    /**
     * Set consignmentValue value
     * @param float $consignmentValue
     * @return \Model\Consignment
     */
    public function setConsignmentValue($consignmentValue = null)
    {
        $this->consignmentValue = $consignmentValue;
        return $this;
    }
    /**
     * Get consignmentValueCurrencyCode value
     * @return string|null
     */
    public function getConsignmentValueCurrencyCode()
    {
        return $this->consignmentValueCurrencyCode;
    }
    /**
     * Set consignmentValueCurrencyCode value
     * @param string $consignmentValueCurrencyCode
     * @return \Model\Consignment
     */
    public function setConsignmentValueCurrencyCode($consignmentValueCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentValueCurrencyCode) && !is_string($consignmentValueCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consignmentValueCurrencyCode)), __LINE__);
        }
        $this->consignmentValueCurrencyCode = $consignmentValueCurrencyCode;
        return $this;
    }
    /**
     * Get consignmentValueCurrencyRate value
     * @return float|null
     */
    public function getConsignmentValueCurrencyRate()
    {
        return $this->consignmentValueCurrencyRate;
    }
    /**
     * Set consignmentValueCurrencyRate value
     * @param float $consignmentValueCurrencyRate
     * @return \Model\Consignment
     */
    public function setConsignmentValueCurrencyRate($consignmentValueCurrencyRate = null)
    {
        $this->consignmentValueCurrencyRate = $consignmentValueCurrencyRate;
        return $this;
    }
    /**
     * Get consignmentWeight value
     * @return float|null
     */
    public function getConsignmentWeight()
    {
        return $this->consignmentWeight;
    }
    /**
     * Set consignmentWeight value
     * @param float $consignmentWeight
     * @return \Model\Consignment
     */
    public function setConsignmentWeight($consignmentWeight = null)
    {
        $this->consignmentWeight = $consignmentWeight;
        return $this;
    }
    /**
     * Get custom1 value
     * @return string|null
     */
    public function getCustom1()
    {
        return $this->custom1;
    }
    /**
     * Set custom1 value
     * @param string $custom1
     * @return \Model\Consignment
     */
    public function setCustom1($custom1 = null)
    {
        // validation for constraint: string
        if (!is_null($custom1) && !is_string($custom1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom1)), __LINE__);
        }
        $this->custom1 = $custom1;
        return $this;
    }
    /**
     * Get custom10 value
     * @return string|null
     */
    public function getCustom10()
    {
        return $this->custom10;
    }
    /**
     * Set custom10 value
     * @param string $custom10
     * @return \Model\Consignment
     */
    public function setCustom10($custom10 = null)
    {
        // validation for constraint: string
        if (!is_null($custom10) && !is_string($custom10)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom10)), __LINE__);
        }
        $this->custom10 = $custom10;
        return $this;
    }
    /**
     * Get custom2 value
     * @return string|null
     */
    public function getCustom2()
    {
        return $this->custom2;
    }
    /**
     * Set custom2 value
     * @param string $custom2
     * @return \Model\Consignment
     */
    public function setCustom2($custom2 = null)
    {
        // validation for constraint: string
        if (!is_null($custom2) && !is_string($custom2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom2)), __LINE__);
        }
        $this->custom2 = $custom2;
        return $this;
    }
    /**
     * Get custom3 value
     * @return string|null
     */
    public function getCustom3()
    {
        return $this->custom3;
    }
    /**
     * Set custom3 value
     * @param string $custom3
     * @return \Model\Consignment
     */
    public function setCustom3($custom3 = null)
    {
        // validation for constraint: string
        if (!is_null($custom3) && !is_string($custom3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom3)), __LINE__);
        }
        $this->custom3 = $custom3;
        return $this;
    }
    /**
     * Get custom4 value
     * @return string|null
     */
    public function getCustom4()
    {
        return $this->custom4;
    }
    /**
     * Set custom4 value
     * @param string $custom4
     * @return \Model\Consignment
     */
    public function setCustom4($custom4 = null)
    {
        // validation for constraint: string
        if (!is_null($custom4) && !is_string($custom4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom4)), __LINE__);
        }
        $this->custom4 = $custom4;
        return $this;
    }
    /**
     * Get custom5 value
     * @return string|null
     */
    public function getCustom5()
    {
        return $this->custom5;
    }
    /**
     * Set custom5 value
     * @param string $custom5
     * @return \Model\Consignment
     */
    public function setCustom5($custom5 = null)
    {
        // validation for constraint: string
        if (!is_null($custom5) && !is_string($custom5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom5)), __LINE__);
        }
        $this->custom5 = $custom5;
        return $this;
    }
    /**
     * Get custom6 value
     * @return string|null
     */
    public function getCustom6()
    {
        return $this->custom6;
    }
    /**
     * Set custom6 value
     * @param string $custom6
     * @return \Model\Consignment
     */
    public function setCustom6($custom6 = null)
    {
        // validation for constraint: string
        if (!is_null($custom6) && !is_string($custom6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom6)), __LINE__);
        }
        $this->custom6 = $custom6;
        return $this;
    }
    /**
     * Get custom7 value
     * @return string|null
     */
    public function getCustom7()
    {
        return $this->custom7;
    }
    /**
     * Set custom7 value
     * @param string $custom7
     * @return \Model\Consignment
     */
    public function setCustom7($custom7 = null)
    {
        // validation for constraint: string
        if (!is_null($custom7) && !is_string($custom7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom7)), __LINE__);
        }
        $this->custom7 = $custom7;
        return $this;
    }
    /**
     * Get custom8 value
     * @return string|null
     */
    public function getCustom8()
    {
        return $this->custom8;
    }
    /**
     * Set custom8 value
     * @param string $custom8
     * @return \Model\Consignment
     */
    public function setCustom8($custom8 = null)
    {
        // validation for constraint: string
        if (!is_null($custom8) && !is_string($custom8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom8)), __LINE__);
        }
        $this->custom8 = $custom8;
        return $this;
    }
    /**
     * Get custom9 value
     * @return string|null
     */
    public function getCustom9()
    {
        return $this->custom9;
    }
    /**
     * Set custom9 value
     * @param string $custom9
     * @return \Model\Consignment
     */
    public function setCustom9($custom9 = null)
    {
        // validation for constraint: string
        if (!is_null($custom9) && !is_string($custom9)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom9)), __LINE__);
        }
        $this->custom9 = $custom9;
        return $this;
    }
    /**
     * Get customsDocumentationRequired value
     * @return bool|null
     */
    public function getCustomsDocumentationRequired()
    {
        return $this->customsDocumentationRequired;
    }
    /**
     * Set customsDocumentationRequired value
     * @param bool $customsDocumentationRequired
     * @return \Model\Consignment
     */
    public function setCustomsDocumentationRequired($customsDocumentationRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($customsDocumentationRequired) && !is_bool($customsDocumentationRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($customsDocumentationRequired)), __LINE__);
        }
        $this->customsDocumentationRequired = $customsDocumentationRequired;
        return $this;
    }
    /**
     * Get cutOffDate value
     * @return string|null
     */
    public function getCutOffDate()
    {
        return $this->cutOffDate;
    }
    /**
     * Set cutOffDate value
     * @param string $cutOffDate
     * @return \Model\Consignment
     */
    public function setCutOffDate($cutOffDate = null)
    {
        // validation for constraint: string
        if (!is_null($cutOffDate) && !is_string($cutOffDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cutOffDate)), __LINE__);
        }
        $this->cutOffDate = $cutOffDate;
        return $this;
    }
    /**
     * Get despatchDate value
     * @return string|null
     */
    public function getDespatchDate()
    {
        return $this->despatchDate;
    }
    /**
     * Set despatchDate value
     * @param string $despatchDate
     * @return \Model\Consignment
     */
    public function setDespatchDate($despatchDate = null)
    {
        // validation for constraint: string
        if (!is_null($despatchDate) && !is_string($despatchDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($despatchDate)), __LINE__);
        }
        $this->despatchDate = $despatchDate;
        return $this;
    }
    /**
     * Get earliestDeliveryDate value
     * @return string|null
     */
    public function getEarliestDeliveryDate()
    {
        return $this->earliestDeliveryDate;
    }
    /**
     * Set earliestDeliveryDate value
     * @param string $earliestDeliveryDate
     * @return \Model\Consignment
     */
    public function setEarliestDeliveryDate($earliestDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($earliestDeliveryDate) && !is_string($earliestDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($earliestDeliveryDate)), __LINE__);
        }
        $this->earliestDeliveryDate = $earliestDeliveryDate;
        return $this;
    }
    /**
     * Get endVatNumber value
     * @return string|null
     */
    public function getEndVatNumber()
    {
        return $this->endVatNumber;
    }
    /**
     * Set endVatNumber value
     * @param string $endVatNumber
     * @return \Model\Consignment
     */
    public function setEndVatNumber($endVatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($endVatNumber) && !is_string($endVatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endVatNumber)), __LINE__);
        }
        $this->endVatNumber = $endVatNumber;
        return $this;
    }
    /**
     * Get fragileGoodsFlag value
     * @return bool|null
     */
    public function getFragileGoodsFlag()
    {
        return $this->fragileGoodsFlag;
    }
    /**
     * Set fragileGoodsFlag value
     * @param bool $fragileGoodsFlag
     * @return \Model\Consignment
     */
    public function setFragileGoodsFlag($fragileGoodsFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($fragileGoodsFlag) && !is_bool($fragileGoodsFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fragileGoodsFlag)), __LINE__);
        }
        $this->fragileGoodsFlag = $fragileGoodsFlag;
        return $this;
    }
    /**
     * Get guaranteedDeliveryDate value
     * @return string|null
     */
    public function getGuaranteedDeliveryDate()
    {
        return $this->guaranteedDeliveryDate;
    }
    /**
     * Set guaranteedDeliveryDate value
     * @param string $guaranteedDeliveryDate
     * @return \Model\Consignment
     */
    public function setGuaranteedDeliveryDate($guaranteedDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteedDeliveryDate) && !is_string($guaranteedDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guaranteedDeliveryDate)), __LINE__);
        }
        $this->guaranteedDeliveryDate = $guaranteedDeliveryDate;
        return $this;
    }
    /**
     * Get hazardCodes value
     * @return string[]|null
     */
    public function getHazardCodes()
    {
        return $this->hazardCodes;
    }
    /**
     * Set hazardCodes value
     * @throws \InvalidArgumentException
     * @param string[] $hazardCodes
     * @return \Model\Consignment
     */
    public function setHazardCodes(array $hazardCodes = array())
    {
        foreach ($hazardCodes as $consignmentHazardCodesItem) {
            // validation for constraint: itemType
            if (!is_string($consignmentHazardCodesItem)) {
                throw new \InvalidArgumentException(sprintf('The hazardCodes property can only contain items of string, "%s" given', is_object($consignmentHazardCodesItem) ? get_class($consignmentHazardCodesItem) : gettype($consignmentHazardCodesItem)), __LINE__);
            }
        }
        $this->hazardCodes = $hazardCodes;
        return $this;
    }
    /**
     * Add item to hazardCodes value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Model\Consignment
     */
    public function addToHazardCodes($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The hazardCodes property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->hazardCodes[] = $item;
        return $this;
    }
    /**
     * Get hazardousGoodsFlag value
     * @return bool|null
     */
    public function getHazardousGoodsFlag()
    {
        return $this->hazardousGoodsFlag;
    }
    /**
     * Set hazardousGoodsFlag value
     * @param bool $hazardousGoodsFlag
     * @return \Model\Consignment
     */
    public function setHazardousGoodsFlag($hazardousGoodsFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($hazardousGoodsFlag) && !is_bool($hazardousGoodsFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hazardousGoodsFlag)), __LINE__);
        }
        $this->hazardousGoodsFlag = $hazardousGoodsFlag;
        return $this;
    }
    /**
     * Get insuranceValue value
     * @return float|null
     */
    public function getInsuranceValue()
    {
        return $this->insuranceValue;
    }
    /**
     * Set insuranceValue value
     * @param float $insuranceValue
     * @return \Model\Consignment
     */
    public function setInsuranceValue($insuranceValue = null)
    {
        $this->insuranceValue = $insuranceValue;
        return $this;
    }
    /**
     * Get insuranceValueCurrencyCode value
     * @return string|null
     */
    public function getInsuranceValueCurrencyCode()
    {
        return $this->insuranceValueCurrencyCode;
    }
    /**
     * Set insuranceValueCurrencyCode value
     * @param string $insuranceValueCurrencyCode
     * @return \Model\Consignment
     */
    public function setInsuranceValueCurrencyCode($insuranceValueCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceValueCurrencyCode) && !is_string($insuranceValueCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($insuranceValueCurrencyCode)), __LINE__);
        }
        $this->insuranceValueCurrencyCode = $insuranceValueCurrencyCode;
        return $this;
    }
    /**
     * Get insuranceValueCurrencyRate value
     * @return float|null
     */
    public function getInsuranceValueCurrencyRate()
    {
        return $this->insuranceValueCurrencyRate;
    }
    /**
     * Set insuranceValueCurrencyRate value
     * @param float $insuranceValueCurrencyRate
     * @return \Model\Consignment
     */
    public function setInsuranceValueCurrencyRate($insuranceValueCurrencyRate = null)
    {
        $this->insuranceValueCurrencyRate = $insuranceValueCurrencyRate;
        return $this;
    }
    /**
     * Get languageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }
    /**
     * Set languageCode value
     * @param string $languageCode
     * @return \Model\Consignment
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languageCode)), __LINE__);
        }
        $this->languageCode = $languageCode;
        return $this;
    }
    /**
     * Get liquidGoodsFlag value
     * @return bool|null
     */
    public function getLiquidGoodsFlag()
    {
        return $this->liquidGoodsFlag;
    }
    /**
     * Set liquidGoodsFlag value
     * @param bool $liquidGoodsFlag
     * @return \Model\Consignment
     */
    public function setLiquidGoodsFlag($liquidGoodsFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($liquidGoodsFlag) && !is_bool($liquidGoodsFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($liquidGoodsFlag)), __LINE__);
        }
        $this->liquidGoodsFlag = $liquidGoodsFlag;
        return $this;
    }
    /**
     * Get manifestGroupCode value
     * @return string|null
     */
    public function getManifestGroupCode()
    {
        return $this->manifestGroupCode;
    }
    /**
     * Set manifestGroupCode value
     * @param string $manifestGroupCode
     * @return \Model\Consignment
     */
    public function setManifestGroupCode($manifestGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($manifestGroupCode) && !is_string($manifestGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manifestGroupCode)), __LINE__);
        }
        $this->manifestGroupCode = $manifestGroupCode;
        return $this;
    }
    /**
     * Get maxDimension value
     * @return float|null
     */
    public function getMaxDimension()
    {
        return $this->maxDimension;
    }
    /**
     * Set maxDimension value
     * @param float $maxDimension
     * @return \Model\Consignment
     */
    public function setMaxDimension($maxDimension = null)
    {
        $this->maxDimension = $maxDimension;
        return $this;
    }
    /**
     * Get metaCampaignKey value
     * @return string|null
     */
    public function getMetaCampaignKey()
    {
        return $this->metaCampaignKey;
    }
    /**
     * Set metaCampaignKey value
     * @param string $metaCampaignKey
     * @return \Model\Consignment
     */
    public function setMetaCampaignKey($metaCampaignKey = null)
    {
        // validation for constraint: string
        if (!is_null($metaCampaignKey) && !is_string($metaCampaignKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($metaCampaignKey)), __LINE__);
        }
        $this->metaCampaignKey = $metaCampaignKey;
        return $this;
    }
    /**
     * Get metaCustomerKey value
     * @return string|null
     */
    public function getMetaCustomerKey()
    {
        return $this->metaCustomerKey;
    }
    /**
     * Set metaCustomerKey value
     * @param string $metaCustomerKey
     * @return \Model\Consignment
     */
    public function setMetaCustomerKey($metaCustomerKey = null)
    {
        // validation for constraint: string
        if (!is_null($metaCustomerKey) && !is_string($metaCustomerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($metaCustomerKey)), __LINE__);
        }
        $this->metaCustomerKey = $metaCustomerKey;
        return $this;
    }
    /**
     * Get moreThanOneMetreGoodsFlag value
     * @return bool|null
     */
    public function getMoreThanOneMetreGoodsFlag()
    {
        return $this->moreThanOneMetreGoodsFlag;
    }
    /**
     * Set moreThanOneMetreGoodsFlag value
     * @param bool $moreThanOneMetreGoodsFlag
     * @return \Model\Consignment
     */
    public function setMoreThanOneMetreGoodsFlag($moreThanOneMetreGoodsFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreThanOneMetreGoodsFlag) && !is_bool($moreThanOneMetreGoodsFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($moreThanOneMetreGoodsFlag)), __LINE__);
        }
        $this->moreThanOneMetreGoodsFlag = $moreThanOneMetreGoodsFlag;
        return $this;
    }
    /**
     * Get moreThanTwentyFiveKgGoodsFlag value
     * @return bool|null
     */
    public function getMoreThanTwentyFiveKgGoodsFlag()
    {
        return $this->moreThanTwentyFiveKgGoodsFlag;
    }
    /**
     * Set moreThanTwentyFiveKgGoodsFlag value
     * @param bool $moreThanTwentyFiveKgGoodsFlag
     * @return \Model\Consignment
     */
    public function setMoreThanTwentyFiveKgGoodsFlag($moreThanTwentyFiveKgGoodsFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreThanTwentyFiveKgGoodsFlag) && !is_bool($moreThanTwentyFiveKgGoodsFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($moreThanTwentyFiveKgGoodsFlag)), __LINE__);
        }
        $this->moreThanTwentyFiveKgGoodsFlag = $moreThanTwentyFiveKgGoodsFlag;
        return $this;
    }
    /**
     * Get orderDate value
     * @return string|null
     */
    public function getOrderDate()
    {
        return $this->orderDate;
    }
    /**
     * Set orderDate value
     * @param string $orderDate
     * @return \Model\Consignment
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderDate)), __LINE__);
        }
        $this->orderDate = $orderDate;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \Model\Consignment
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get orderValue value
     * @return float|null
     */
    public function getOrderValue()
    {
        return $this->orderValue;
    }
    /**
     * Set orderValue value
     * @param float $orderValue
     * @return \Model\Consignment
     */
    public function setOrderValue($orderValue = null)
    {
        $this->orderValue = $orderValue;
        return $this;
    }
    /**
     * Get parcelCount value
     * @return int|null
     */
    public function getParcelCount()
    {
        return $this->parcelCount;
    }
    /**
     * Set parcelCount value
     * @param int $parcelCount
     * @return \Model\Consignment
     */
    public function setParcelCount($parcelCount = null)
    {
        // validation for constraint: int
        if (!is_null($parcelCount) && !is_numeric($parcelCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parcelCount)), __LINE__);
        }
        $this->parcelCount = $parcelCount;
        return $this;
    }
    /**
     * Get parcels value
     * @return \Model\Parcel[]|null
     */
    public function getParcels()
    {
        return $this->parcels;
    }
    /**
     * Set parcels value
     * @throws \InvalidArgumentException
     * @param \Model\Parcel[] $parcels
     * @return \Model\Consignment
     */
    public function setParcels(array $parcels = array())
    {
        foreach ($parcels as $consignmentParcelsItem) {
            // validation for constraint: itemType
            if (!$consignmentParcelsItem instanceof \Model\Parcel) {
                throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of \Model\Parcel, "%s" given', is_object($consignmentParcelsItem) ? get_class($consignmentParcelsItem) : gettype($consignmentParcelsItem)), __LINE__);
            }
        }
        $this->parcels = $parcels;
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \Model\Parcel $item
     * @return \Model\Consignment
     */
    public function addToParcels(\Model\Parcel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Model\Parcel) {
            throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of \Model\Parcel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->parcels[] = $item;
        return $this;
    }
    /**
     * Get pickTicketNumber value
     * @return string|null
     */
    public function getPickTicketNumber()
    {
        return $this->pickTicketNumber;
    }
    /**
     * Set pickTicketNumber value
     * @param string $pickTicketNumber
     * @return \Model\Consignment
     */
    public function setPickTicketNumber($pickTicketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pickTicketNumber) && !is_string($pickTicketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pickTicketNumber)), __LINE__);
        }
        $this->pickTicketNumber = $pickTicketNumber;
        return $this;
    }
    /**
     * Get pickupPoint value
     * @return string|null
     */
    public function getPickupPoint()
    {
        return $this->pickupPoint;
    }
    /**
     * Set pickupPoint value
     * @param string $pickupPoint
     * @return \Model\Consignment
     */
    public function setPickupPoint($pickupPoint = null)
    {
        // validation for constraint: string
        if (!is_null($pickupPoint) && !is_string($pickupPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pickupPoint)), __LINE__);
        }
        $this->pickupPoint = $pickupPoint;
        return $this;
    }
    /**
     * Get podRequired value
     * @return string|null
     */
    public function getPodRequired()
    {
        return $this->podRequired;
    }
    /**
     * Set podRequired value
     * @param string $podRequired
     * @return \Model\Consignment
     */
    public function setPodRequired($podRequired = null)
    {
        // validation for constraint: string
        if (!is_null($podRequired) && !is_string($podRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($podRequired)), __LINE__);
        }
        $this->podRequired = $podRequired;
        return $this;
    }
    /**
     * Get properties value
     * @return \Model\Property[]|null
     */
    public function getProperties()
    {
        return $this->properties;
    }
    /**
     * Set properties value
     * @throws \InvalidArgumentException
     * @param \Model\Property[] $properties
     * @return \Model\Consignment
     */
    public function setProperties(array $properties = array())
    {
        foreach ($properties as $consignmentPropertiesItem) {
            // validation for constraint: itemType
            if (!$consignmentPropertiesItem instanceof \Model\Property) {
                throw new \InvalidArgumentException(sprintf('The properties property can only contain items of \Model\Property, "%s" given', is_object($consignmentPropertiesItem) ? get_class($consignmentPropertiesItem) : gettype($consignmentPropertiesItem)), __LINE__);
            }
        }
        $this->properties = $properties;
        return $this;
    }
    /**
     * Add item to properties value
     * @throws \InvalidArgumentException
     * @param \Model\Property $item
     * @return \Model\Consignment
     */
    public function addToProperties(\Model\Property $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Model\Property) {
            throw new \InvalidArgumentException(sprintf('The properties property can only contain items of \Model\Property, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->properties[] = $item;
        return $this;
    }
    /**
     * Get recipientAddress value
     * @return \Model\Address|null
     */
    public function getRecipientAddress()
    {
        return $this->recipientAddress;
    }
    /**
     * Set recipientAddress value
     * @param \Model\Address $recipientAddress
     * @return \Model\Consignment
     */
    public function setRecipientAddress(\Model\Address $recipientAddress = null)
    {
        $this->recipientAddress = $recipientAddress;
        return $this;
    }
    /**
     * Get recipientCode value
     * @return string|null
     */
    public function getRecipientCode()
    {
        return $this->recipientCode;
    }
    /**
     * Set recipientCode value
     * @param string $recipientCode
     * @return \Model\Consignment
     */
    public function setRecipientCode($recipientCode = null)
    {
        // validation for constraint: string
        if (!is_null($recipientCode) && !is_string($recipientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientCode)), __LINE__);
        }
        $this->recipientCode = $recipientCode;
        return $this;
    }
    /**
     * Get recipientContactPhone value
     * @return string|null
     */
    public function getRecipientContactPhone()
    {
        return $this->recipientContactPhone;
    }
    /**
     * Set recipientContactPhone value
     * @param string $recipientContactPhone
     * @return \Model\Consignment
     */
    public function setRecipientContactPhone($recipientContactPhone = null)
    {
        // validation for constraint: string
        if (!is_null($recipientContactPhone) && !is_string($recipientContactPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientContactPhone)), __LINE__);
        }
        $this->recipientContactPhone = $recipientContactPhone;
        return $this;
    }
    /**
     * Get recipientEmail value
     * @return string|null
     */
    public function getRecipientEmail()
    {
        return $this->recipientEmail;
    }
    /**
     * Set recipientEmail value
     * @param string $recipientEmail
     * @return \Model\Consignment
     */
    public function setRecipientEmail($recipientEmail = null)
    {
        // validation for constraint: string
        if (!is_null($recipientEmail) && !is_string($recipientEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientEmail)), __LINE__);
        }
        $this->recipientEmail = $recipientEmail;
        return $this;
    }
    /**
     * Get recipientFirstName value
     * @return string|null
     */
    public function getRecipientFirstName()
    {
        return $this->recipientFirstName;
    }
    /**
     * Set recipientFirstName value
     * @param string $recipientFirstName
     * @return \Model\Consignment
     */
    public function setRecipientFirstName($recipientFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($recipientFirstName) && !is_string($recipientFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientFirstName)), __LINE__);
        }
        $this->recipientFirstName = $recipientFirstName;
        return $this;
    }
    /**
     * Get recipientLastName value
     * @return string|null
     */
    public function getRecipientLastName()
    {
        return $this->recipientLastName;
    }
    /**
     * Set recipientLastName value
     * @param string $recipientLastName
     * @return \Model\Consignment
     */
    public function setRecipientLastName($recipientLastName = null)
    {
        // validation for constraint: string
        if (!is_null($recipientLastName) && !is_string($recipientLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientLastName)), __LINE__);
        }
        $this->recipientLastName = $recipientLastName;
        return $this;
    }
    /**
     * Get recipientMobilePhone value
     * @return string|null
     */
    public function getRecipientMobilePhone()
    {
        return $this->recipientMobilePhone;
    }
    /**
     * Set recipientMobilePhone value
     * @param string $recipientMobilePhone
     * @return \Model\Consignment
     */
    public function setRecipientMobilePhone($recipientMobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($recipientMobilePhone) && !is_string($recipientMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientMobilePhone)), __LINE__);
        }
        $this->recipientMobilePhone = $recipientMobilePhone;
        return $this;
    }
    /**
     * Get recipientName value
     * @return string|null
     */
    public function getRecipientName()
    {
        return $this->recipientName;
    }
    /**
     * Set recipientName value
     * @param string $recipientName
     * @return \Model\Consignment
     */
    public function setRecipientName($recipientName = null)
    {
        // validation for constraint: string
        if (!is_null($recipientName) && !is_string($recipientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientName)), __LINE__);
        }
        $this->recipientName = $recipientName;
        return $this;
    }
    /**
     * Get recipientNotificationType value
     * @return string|null
     */
    public function getRecipientNotificationType()
    {
        return $this->recipientNotificationType;
    }
    /**
     * Set recipientNotificationType value
     * @param string $recipientNotificationType
     * @return \Model\Consignment
     */
    public function setRecipientNotificationType($recipientNotificationType = null)
    {
        // validation for constraint: string
        if (!is_null($recipientNotificationType) && !is_string($recipientNotificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientNotificationType)), __LINE__);
        }
        $this->recipientNotificationType = $recipientNotificationType;
        return $this;
    }
    /**
     * Get recipientPhone value
     * @return string|null
     */
    public function getRecipientPhone()
    {
        return $this->recipientPhone;
    }
    /**
     * Set recipientPhone value
     * @param string $recipientPhone
     * @return \Model\Consignment
     */
    public function setRecipientPhone($recipientPhone = null)
    {
        // validation for constraint: string
        if (!is_null($recipientPhone) && !is_string($recipientPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientPhone)), __LINE__);
        }
        $this->recipientPhone = $recipientPhone;
        return $this;
    }
    /**
     * Get recipientTimeZone value
     * @return string|null
     */
    public function getRecipientTimeZone()
    {
        return $this->recipientTimeZone;
    }
    /**
     * Set recipientTimeZone value
     * @param string $recipientTimeZone
     * @return \Model\Consignment
     */
    public function setRecipientTimeZone($recipientTimeZone = null)
    {
        // validation for constraint: string
        if (!is_null($recipientTimeZone) && !is_string($recipientTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientTimeZone)), __LINE__);
        }
        $this->recipientTimeZone = $recipientTimeZone;
        return $this;
    }
    /**
     * Get recipientTitle value
     * @return string|null
     */
    public function getRecipientTitle()
    {
        return $this->recipientTitle;
    }
    /**
     * Set recipientTitle value
     * @param string $recipientTitle
     * @return \Model\Consignment
     */
    public function setRecipientTitle($recipientTitle = null)
    {
        // validation for constraint: string
        if (!is_null($recipientTitle) && !is_string($recipientTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientTitle)), __LINE__);
        }
        $this->recipientTitle = $recipientTitle;
        return $this;
    }
    /**
     * Get recipientVatNumber value
     * @return string|null
     */
    public function getRecipientVatNumber()
    {
        return $this->recipientVatNumber;
    }
    /**
     * Set recipientVatNumber value
     * @param string $recipientVatNumber
     * @return \Model\Consignment
     */
    public function setRecipientVatNumber($recipientVatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($recipientVatNumber) && !is_string($recipientVatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientVatNumber)), __LINE__);
        }
        $this->recipientVatNumber = $recipientVatNumber;
        return $this;
    }
    /**
     * Get returnAddress value
     * @return \Model\Address|null
     */
    public function getReturnAddress()
    {
        return $this->returnAddress;
    }
    /**
     * Set returnAddress value
     * @param \Model\Address $returnAddress
     * @return \Model\Consignment
     */
    public function setReturnAddress(\Model\Address $returnAddress = null)
    {
        $this->returnAddress = $returnAddress;
        return $this;
    }
    /**
     * Get returnEmail value
     * @return string|null
     */
    public function getReturnEmail()
    {
        return $this->returnEmail;
    }
    /**
     * Set returnEmail value
     * @param string $returnEmail
     * @return \Model\Consignment
     */
    public function setReturnEmail($returnEmail = null)
    {
        // validation for constraint: string
        if (!is_null($returnEmail) && !is_string($returnEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnEmail)), __LINE__);
        }
        $this->returnEmail = $returnEmail;
        return $this;
    }
    /**
     * Get returnFirstName value
     * @return string|null
     */
    public function getReturnFirstName()
    {
        return $this->returnFirstName;
    }
    /**
     * Set returnFirstName value
     * @param string $returnFirstName
     * @return \Model\Consignment
     */
    public function setReturnFirstName($returnFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($returnFirstName) && !is_string($returnFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnFirstName)), __LINE__);
        }
        $this->returnFirstName = $returnFirstName;
        return $this;
    }
    /**
     * Get returnLastName value
     * @return string|null
     */
    public function getReturnLastName()
    {
        return $this->returnLastName;
    }
    /**
     * Set returnLastName value
     * @param string $returnLastName
     * @return \Model\Consignment
     */
    public function setReturnLastName($returnLastName = null)
    {
        // validation for constraint: string
        if (!is_null($returnLastName) && !is_string($returnLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnLastName)), __LINE__);
        }
        $this->returnLastName = $returnLastName;
        return $this;
    }
    /**
     * Get returnMobile value
     * @return string|null
     */
    public function getReturnMobile()
    {
        return $this->returnMobile;
    }
    /**
     * Set returnMobile value
     * @param string $returnMobile
     * @return \Model\Consignment
     */
    public function setReturnMobile($returnMobile = null)
    {
        // validation for constraint: string
        if (!is_null($returnMobile) && !is_string($returnMobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnMobile)), __LINE__);
        }
        $this->returnMobile = $returnMobile;
        return $this;
    }
    /**
     * Get returnName value
     * @return string|null
     */
    public function getReturnName()
    {
        return $this->returnName;
    }
    /**
     * Set returnName value
     * @param string $returnName
     * @return \Model\Consignment
     */
    public function setReturnName($returnName = null)
    {
        // validation for constraint: string
        if (!is_null($returnName) && !is_string($returnName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnName)), __LINE__);
        }
        $this->returnName = $returnName;
        return $this;
    }
    /**
     * Get returnPhone value
     * @return string|null
     */
    public function getReturnPhone()
    {
        return $this->returnPhone;
    }
    /**
     * Set returnPhone value
     * @param string $returnPhone
     * @return \Model\Consignment
     */
    public function setReturnPhone($returnPhone = null)
    {
        // validation for constraint: string
        if (!is_null($returnPhone) && !is_string($returnPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnPhone)), __LINE__);
        }
        $this->returnPhone = $returnPhone;
        return $this;
    }
    /**
     * Get returnTitle value
     * @return string|null
     */
    public function getReturnTitle()
    {
        return $this->returnTitle;
    }
    /**
     * Set returnTitle value
     * @param string $returnTitle
     * @return \Model\Consignment
     */
    public function setReturnTitle($returnTitle = null)
    {
        // validation for constraint: string
        if (!is_null($returnTitle) && !is_string($returnTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnTitle)), __LINE__);
        }
        $this->returnTitle = $returnTitle;
        return $this;
    }
    /**
     * Get senderAddress value
     * @return \Model\Address|null
     */
    public function getSenderAddress()
    {
        return $this->senderAddress;
    }
    /**
     * Set senderAddress value
     * @param \Model\Address $senderAddress
     * @return \Model\Consignment
     */
    public function setSenderAddress(\Model\Address $senderAddress = null)
    {
        $this->senderAddress = $senderAddress;
        return $this;
    }
    /**
     * Get senderCode value
     * @return string|null
     */
    public function getSenderCode()
    {
        return $this->senderCode;
    }
    /**
     * Set senderCode value
     * @param string $senderCode
     * @return \Model\Consignment
     */
    public function setSenderCode($senderCode = null)
    {
        // validation for constraint: string
        if (!is_null($senderCode) && !is_string($senderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderCode)), __LINE__);
        }
        $this->senderCode = $senderCode;
        return $this;
    }
    /**
     * Get senderContactPhone value
     * @return string|null
     */
    public function getSenderContactPhone()
    {
        return $this->senderContactPhone;
    }
    /**
     * Set senderContactPhone value
     * @param string $senderContactPhone
     * @return \Model\Consignment
     */
    public function setSenderContactPhone($senderContactPhone = null)
    {
        // validation for constraint: string
        if (!is_null($senderContactPhone) && !is_string($senderContactPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderContactPhone)), __LINE__);
        }
        $this->senderContactPhone = $senderContactPhone;
        return $this;
    }
    /**
     * Get senderEmail value
     * @return string|null
     */
    public function getSenderEmail()
    {
        return $this->senderEmail;
    }
    /**
     * Set senderEmail value
     * @param string $senderEmail
     * @return \Model\Consignment
     */
    public function setSenderEmail($senderEmail = null)
    {
        // validation for constraint: string
        if (!is_null($senderEmail) && !is_string($senderEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderEmail)), __LINE__);
        }
        $this->senderEmail = $senderEmail;
        return $this;
    }
    /**
     * Get senderFirstName value
     * @return string|null
     */
    public function getSenderFirstName()
    {
        return $this->senderFirstName;
    }
    /**
     * Set senderFirstName value
     * @param string $senderFirstName
     * @return \Model\Consignment
     */
    public function setSenderFirstName($senderFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($senderFirstName) && !is_string($senderFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderFirstName)), __LINE__);
        }
        $this->senderFirstName = $senderFirstName;
        return $this;
    }
    /**
     * Get senderLastName value
     * @return string|null
     */
    public function getSenderLastName()
    {
        return $this->senderLastName;
    }
    /**
     * Set senderLastName value
     * @param string $senderLastName
     * @return \Model\Consignment
     */
    public function setSenderLastName($senderLastName = null)
    {
        // validation for constraint: string
        if (!is_null($senderLastName) && !is_string($senderLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderLastName)), __LINE__);
        }
        $this->senderLastName = $senderLastName;
        return $this;
    }
    /**
     * Get senderMobilePhone value
     * @return string|null
     */
    public function getSenderMobilePhone()
    {
        return $this->senderMobilePhone;
    }
    /**
     * Set senderMobilePhone value
     * @param string $senderMobilePhone
     * @return \Model\Consignment
     */
    public function setSenderMobilePhone($senderMobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($senderMobilePhone) && !is_string($senderMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderMobilePhone)), __LINE__);
        }
        $this->senderMobilePhone = $senderMobilePhone;
        return $this;
    }
    /**
     * Get senderName value
     * @return string|null
     */
    public function getSenderName()
    {
        return $this->senderName;
    }
    /**
     * Set senderName value
     * @param string $senderName
     * @return \Model\Consignment
     */
    public function setSenderName($senderName = null)
    {
        // validation for constraint: string
        if (!is_null($senderName) && !is_string($senderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderName)), __LINE__);
        }
        $this->senderName = $senderName;
        return $this;
    }
    /**
     * Get senderNotificationType value
     * @return string|null
     */
    public function getSenderNotificationType()
    {
        return $this->senderNotificationType;
    }
    /**
     * Set senderNotificationType value
     * @param string $senderNotificationType
     * @return \Model\Consignment
     */
    public function setSenderNotificationType($senderNotificationType = null)
    {
        // validation for constraint: string
        if (!is_null($senderNotificationType) && !is_string($senderNotificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderNotificationType)), __LINE__);
        }
        $this->senderNotificationType = $senderNotificationType;
        return $this;
    }
    /**
     * Get senderPhone value
     * @return string|null
     */
    public function getSenderPhone()
    {
        return $this->senderPhone;
    }
    /**
     * Set senderPhone value
     * @param string $senderPhone
     * @return \Model\Consignment
     */
    public function setSenderPhone($senderPhone = null)
    {
        // validation for constraint: string
        if (!is_null($senderPhone) && !is_string($senderPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderPhone)), __LINE__);
        }
        $this->senderPhone = $senderPhone;
        return $this;
    }
    /**
     * Get senderTimeZone value
     * @return string|null
     */
    public function getSenderTimeZone()
    {
        return $this->senderTimeZone;
    }
    /**
     * Set senderTimeZone value
     * @param string $senderTimeZone
     * @return \Model\Consignment
     */
    public function setSenderTimeZone($senderTimeZone = null)
    {
        // validation for constraint: string
        if (!is_null($senderTimeZone) && !is_string($senderTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderTimeZone)), __LINE__);
        }
        $this->senderTimeZone = $senderTimeZone;
        return $this;
    }
    /**
     * Get senderTitle value
     * @return string|null
     */
    public function getSenderTitle()
    {
        return $this->senderTitle;
    }
    /**
     * Set senderTitle value
     * @param string $senderTitle
     * @return \Model\Consignment
     */
    public function setSenderTitle($senderTitle = null)
    {
        // validation for constraint: string
        if (!is_null($senderTitle) && !is_string($senderTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderTitle)), __LINE__);
        }
        $this->senderTitle = $senderTitle;
        return $this;
    }
    /**
     * Get senderVatNumber value
     * @return string|null
     */
    public function getSenderVatNumber()
    {
        return $this->senderVatNumber;
    }
    /**
     * Set senderVatNumber value
     * @param string $senderVatNumber
     * @return \Model\Consignment
     */
    public function setSenderVatNumber($senderVatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($senderVatNumber) && !is_string($senderVatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderVatNumber)), __LINE__);
        }
        $this->senderVatNumber = $senderVatNumber;
        return $this;
    }
    /**
     * Get shipmentTypeCode value
     * @return string|null
     */
    public function getShipmentTypeCode()
    {
        return $this->shipmentTypeCode;
    }
    /**
     * Set shipmentTypeCode value
     * @param string $shipmentTypeCode
     * @return \Model\Consignment
     */
    public function setShipmentTypeCode($shipmentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentTypeCode) && !is_string($shipmentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentTypeCode)), __LINE__);
        }
        $this->shipmentTypeCode = $shipmentTypeCode;
        return $this;
    }
    /**
     * Get shippingAccount value
     * @return string|null
     */
    public function getShippingAccount()
    {
        return $this->shippingAccount;
    }
    /**
     * Set shippingAccount value
     * @param string $shippingAccount
     * @return \Model\Consignment
     */
    public function setShippingAccount($shippingAccount = null)
    {
        // validation for constraint: string
        if (!is_null($shippingAccount) && !is_string($shippingAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingAccount)), __LINE__);
        }
        $this->shippingAccount = $shippingAccount;
        return $this;
    }
    /**
     * Get shippingCharge value
     * @return float|null
     */
    public function getShippingCharge()
    {
        return $this->shippingCharge;
    }
    /**
     * Set shippingCharge value
     * @param float $shippingCharge
     * @return \Model\Consignment
     */
    public function setShippingCharge($shippingCharge = null)
    {
        $this->shippingCharge = $shippingCharge;
        return $this;
    }
    /**
     * Get shippingChargeCurrencyCode value
     * @return string|null
     */
    public function getShippingChargeCurrencyCode()
    {
        return $this->shippingChargeCurrencyCode;
    }
    /**
     * Set shippingChargeCurrencyCode value
     * @param string $shippingChargeCurrencyCode
     * @return \Model\Consignment
     */
    public function setShippingChargeCurrencyCode($shippingChargeCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingChargeCurrencyCode) && !is_string($shippingChargeCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingChargeCurrencyCode)), __LINE__);
        }
        $this->shippingChargeCurrencyCode = $shippingChargeCurrencyCode;
        return $this;
    }
    /**
     * Get shippingChargeCurrencyRate value
     * @return float|null
     */
    public function getShippingChargeCurrencyRate()
    {
        return $this->shippingChargeCurrencyRate;
    }
    /**
     * Set shippingChargeCurrencyRate value
     * @param float $shippingChargeCurrencyRate
     * @return \Model\Consignment
     */
    public function setShippingChargeCurrencyRate($shippingChargeCurrencyRate = null)
    {
        $this->shippingChargeCurrencyRate = $shippingChargeCurrencyRate;
        return $this;
    }
    /**
     * Get shippingCost value
     * @return float|null
     */
    public function getShippingCost()
    {
        return $this->shippingCost;
    }
    /**
     * Set shippingCost value
     * @param float $shippingCost
     * @return \Model\Consignment
     */
    public function setShippingCost($shippingCost = null)
    {
        $this->shippingCost = $shippingCost;
        return $this;
    }
    /**
     * Get shippingCostCurrencyCode value
     * @return string|null
     */
    public function getShippingCostCurrencyCode()
    {
        return $this->shippingCostCurrencyCode;
    }
    /**
     * Set shippingCostCurrencyCode value
     * @param string $shippingCostCurrencyCode
     * @return \Model\Consignment
     */
    public function setShippingCostCurrencyCode($shippingCostCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingCostCurrencyCode) && !is_string($shippingCostCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingCostCurrencyCode)), __LINE__);
        }
        $this->shippingCostCurrencyCode = $shippingCostCurrencyCode;
        return $this;
    }
    /**
     * Get shippingCostCurrencyRate value
     * @return float|null
     */
    public function getShippingCostCurrencyRate()
    {
        return $this->shippingCostCurrencyRate;
    }
    /**
     * Set shippingCostCurrencyRate value
     * @param float $shippingCostCurrencyRate
     * @return \Model\Consignment
     */
    public function setShippingCostCurrencyRate($shippingCostCurrencyRate = null)
    {
        $this->shippingCostCurrencyRate = $shippingCostCurrencyRate;
        return $this;
    }
    /**
     * Get signatoryOnCustoms value
     * @return string|null
     */
    public function getSignatoryOnCustoms()
    {
        return $this->signatoryOnCustoms;
    }
    /**
     * Set signatoryOnCustoms value
     * @param string $signatoryOnCustoms
     * @return \Model\Consignment
     */
    public function setSignatoryOnCustoms($signatoryOnCustoms = null)
    {
        // validation for constraint: string
        if (!is_null($signatoryOnCustoms) && !is_string($signatoryOnCustoms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signatoryOnCustoms)), __LINE__);
        }
        $this->signatoryOnCustoms = $signatoryOnCustoms;
        return $this;
    }
    /**
     * Get specialInstructions1 value
     * @return string|null
     */
    public function getSpecialInstructions1()
    {
        return $this->specialInstructions1;
    }
    /**
     * Set specialInstructions1 value
     * @param string $specialInstructions1
     * @return \Model\Consignment
     */
    public function setSpecialInstructions1($specialInstructions1 = null)
    {
        // validation for constraint: string
        if (!is_null($specialInstructions1) && !is_string($specialInstructions1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($specialInstructions1)), __LINE__);
        }
        $this->specialInstructions1 = $specialInstructions1;
        return $this;
    }
    /**
     * Get specialInstructions2 value
     * @return string|null
     */
    public function getSpecialInstructions2()
    {
        return $this->specialInstructions2;
    }
    /**
     * Set specialInstructions2 value
     * @param string $specialInstructions2
     * @return \Model\Consignment
     */
    public function setSpecialInstructions2($specialInstructions2 = null)
    {
        // validation for constraint: string
        if (!is_null($specialInstructions2) && !is_string($specialInstructions2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($specialInstructions2)), __LINE__);
        }
        $this->specialInstructions2 = $specialInstructions2;
        return $this;
    }
    /**
     * Get startVatNumber value
     * @return string|null
     */
    public function getStartVatNumber()
    {
        return $this->startVatNumber;
    }
    /**
     * Set startVatNumber value
     * @param string $startVatNumber
     * @return \Model\Consignment
     */
    public function setStartVatNumber($startVatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($startVatNumber) && !is_string($startVatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startVatNumber)), __LINE__);
        }
        $this->startVatNumber = $startVatNumber;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \Model\Consignment
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get taxAndDuty value
     * @return float|null
     */
    public function getTaxAndDuty()
    {
        return $this->taxAndDuty;
    }
    /**
     * Set taxAndDuty value
     * @param float $taxAndDuty
     * @return \Model\Consignment
     */
    public function setTaxAndDuty($taxAndDuty = null)
    {
        $this->taxAndDuty = $taxAndDuty;
        return $this;
    }
    /**
     * Get taxAndDutyCurrencyCode value
     * @return string|null
     */
    public function getTaxAndDutyCurrencyCode()
    {
        return $this->taxAndDutyCurrencyCode;
    }
    /**
     * Set taxAndDutyCurrencyCode value
     * @param string $taxAndDutyCurrencyCode
     * @return \Model\Consignment
     */
    public function setTaxAndDutyCurrencyCode($taxAndDutyCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxAndDutyCurrencyCode) && !is_string($taxAndDutyCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxAndDutyCurrencyCode)), __LINE__);
        }
        $this->taxAndDutyCurrencyCode = $taxAndDutyCurrencyCode;
        return $this;
    }
    /**
     * Get taxAndDutyCurrencyRate value
     * @return float|null
     */
    public function getTaxAndDutyCurrencyRate()
    {
        return $this->taxAndDutyCurrencyRate;
    }
    /**
     * Set taxAndDutyCurrencyRate value
     * @param float $taxAndDutyCurrencyRate
     * @return \Model\Consignment
     */
    public function setTaxAndDutyCurrencyRate($taxAndDutyCurrencyRate = null)
    {
        $this->taxAndDutyCurrencyRate = $taxAndDutyCurrencyRate;
        return $this;
    }
    /**
     * Get taxAndDutyStatusText value
     * @return string|null
     */
    public function getTaxAndDutyStatusText()
    {
        return $this->taxAndDutyStatusText;
    }
    /**
     * Set taxAndDutyStatusText value
     * @param string $taxAndDutyStatusText
     * @return \Model\Consignment
     */
    public function setTaxAndDutyStatusText($taxAndDutyStatusText = null)
    {
        // validation for constraint: string
        if (!is_null($taxAndDutyStatusText) && !is_string($taxAndDutyStatusText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxAndDutyStatusText)), __LINE__);
        }
        $this->taxAndDutyStatusText = $taxAndDutyStatusText;
        return $this;
    }
    /**
     * Get taxDutyDeclarationCurrencyCode value
     * @return string|null
     */
    public function getTaxDutyDeclarationCurrencyCode()
    {
        return $this->taxDutyDeclarationCurrencyCode;
    }
    /**
     * Set taxDutyDeclarationCurrencyCode value
     * @param string $taxDutyDeclarationCurrencyCode
     * @return \Model\Consignment
     */
    public function setTaxDutyDeclarationCurrencyCode($taxDutyDeclarationCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxDutyDeclarationCurrencyCode) && !is_string($taxDutyDeclarationCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxDutyDeclarationCurrencyCode)), __LINE__);
        }
        $this->taxDutyDeclarationCurrencyCode = $taxDutyDeclarationCurrencyCode;
        return $this;
    }
    /**
     * Get termsOfTradeCode value
     * @return string|null
     */
    public function getTermsOfTradeCode()
    {
        return $this->termsOfTradeCode;
    }
    /**
     * Set termsOfTradeCode value
     * @param string $termsOfTradeCode
     * @return \Model\Consignment
     */
    public function setTermsOfTradeCode($termsOfTradeCode = null)
    {
        // validation for constraint: string
        if (!is_null($termsOfTradeCode) && !is_string($termsOfTradeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($termsOfTradeCode)), __LINE__);
        }
        $this->termsOfTradeCode = $termsOfTradeCode;
        return $this;
    }
    /**
     * Get transactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->transactionType;
    }
    /**
     * Set transactionType value
     * @param string $transactionType
     * @return \Model\Consignment
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: string
        if (!is_null($transactionType) && !is_string($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionType)), __LINE__);
        }
        $this->transactionType = $transactionType;
        return $this;
    }
    /**
     * Get twoManLiftFlag value
     * @return bool|null
     */
    public function getTwoManLiftFlag()
    {
        return $this->twoManLiftFlag;
    }
    /**
     * Set twoManLiftFlag value
     * @param bool $twoManLiftFlag
     * @return \Model\Consignment
     */
    public function setTwoManLiftFlag($twoManLiftFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($twoManLiftFlag) && !is_bool($twoManLiftFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($twoManLiftFlag)), __LINE__);
        }
        $this->twoManLiftFlag = $twoManLiftFlag;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Model\Consignment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
