<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Scan ServiceType
 * @subpackage Services
 */
class Scan extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named scanOrderToManifestGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $orderNumber
     * @param string $manifestGroupCode
     * @return boolean|bool
     */
    public function scanOrderToManifestGroup($orderNumber, $manifestGroupCode)
    {
        try {
            $this->setResult(self::getSoapClient()->scanOrderToManifestGroup($orderNumber, $manifestGroupCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named scanCartonToManifestGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $cartonId
     * @param string $manifestGroupCode
     * @return boolean|bool
     */
    public function scanCartonToManifestGroup($cartonId, $manifestGroupCode)
    {
        try {
            $this->setResult(self::getSoapClient()->scanCartonToManifestGroup($cartonId, $manifestGroupCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
