<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createConsignments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $consignments
     * @return \Model\Consignment[]|bool
     */
    public function createConsignments($consignments)
    {
        try {
            $this->setResult(self::getSoapClient()->createConsignments($consignments));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createPaperworkForParcel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $consignmentCode
     * @param string $parcelNumber
     * @param string $parameters
     * @return \Model\Paperwork|bool
     */
    public function createPaperworkForParcel($consignmentCode, $parcelNumber, $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createPaperworkForParcel($consignmentCode, $parcelNumber, $parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createPaperworkForConsignments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $consignmentCodes
     * @param string $parameters
     * @return \Model\Paperwork|bool
     */
    public function createPaperworkForConsignments($consignmentCodes, $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createPaperworkForConsignments($consignmentCodes, $parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createNextPaperworkForConsignment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $consignmentCode
     * @param string $parcelCount
     * @param string $parameters
     * @return \Model\Paperwork|bool
     */
    public function createNextPaperworkForConsignment($consignmentCode, $parcelCount, $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createNextPaperworkForConsignment($consignmentCode, $parcelCount, $parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createPaperworkForCarton
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $consignmentCode
     * @param string $cartonId
     * @param string $parameters
     * @return \Model\Paperwork|bool
     */
    public function createPaperworkForCarton($consignmentCode, $cartonId, $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createPaperworkForCarton($consignmentCode, $cartonId, $parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Model\Consignment[]|\Model\Paperwork
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
