<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Append ServiceType
 * @subpackage Services
 */
class Append extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named appendParcelsToConsignment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $consignmentCode
     * @param string $parcels
     * @param string $recalculateTaxAndDuty
     * @return \Model\Parcel[]|bool
     */
    public function appendParcelsToConsignment($consignmentCode, $parcels, $recalculateTaxAndDuty)
    {
        try {
            $this->setResult(self::getSoapClient()->appendParcelsToConsignment($consignmentCode, $parcels, $recalculateTaxAndDuty));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Model\Parcel[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
