<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addInnerToOuter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $innerConsignmentCode
     * @param string $innerParcelNumber
     * @param string $outerConsignmentCode
     * @param string $outerParcelNumber
     * @return boolean|bool
     */
    public function addInnerToOuter($innerConsignmentCode, $innerParcelNumber, $outerConsignmentCode, $outerParcelNumber)
    {
        try {
            $this->setResult(self::getSoapClient()->addInnerToOuter($innerConsignmentCode, $innerParcelNumber, $outerConsignmentCode, $outerParcelNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addConsignmentsToGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $consignmentCodes
     * @param string $manifestGroupCode
     * @return boolean|bool
     */
    public function addConsignmentsToGroup($consignmentCodes, $manifestGroupCode)
    {
        try {
            $this->setResult(self::getSoapClient()->addConsignmentsToGroup($consignmentCodes, $manifestGroupCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
