<?php

namespace Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxAndDuty Model
 * @subpackage Structs
 */
class TaxAndDuty extends AbstractStructBase
{
    /**
     * The properties
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - arrayType: tns1:Property[]
     * - ref: soapenc:arrayType
     * @var \Model\Property[]
     */
    public $properties;
    /**
     * The taxAndDuty
     * @var float
     */
    public $taxAndDuty;
    /**
     * The taxAndDutyCurrencyCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $taxAndDutyCurrencyCode;
    /**
     * The taxAndDutyCurrencyRate
     * @var float
     */
    public $taxAndDutyCurrencyRate;
    /**
     * The taxAndDutyStatusText
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $taxAndDutyStatusText;
    /**
     * Constructor method for TaxAndDuty
     * @uses TaxAndDuty::setProperties()
     * @uses TaxAndDuty::setTaxAndDuty()
     * @uses TaxAndDuty::setTaxAndDutyCurrencyCode()
     * @uses TaxAndDuty::setTaxAndDutyCurrencyRate()
     * @uses TaxAndDuty::setTaxAndDutyStatusText()
     * @param \Model\Property[] $properties
     * @param float $taxAndDuty
     * @param string $taxAndDutyCurrencyCode
     * @param float $taxAndDutyCurrencyRate
     * @param string $taxAndDutyStatusText
     */
    public function __construct(array $properties = array(), $taxAndDuty = null, $taxAndDutyCurrencyCode = null, $taxAndDutyCurrencyRate = null, $taxAndDutyStatusText = null)
    {
        $this
            ->setProperties($properties)
            ->setTaxAndDuty($taxAndDuty)
            ->setTaxAndDutyCurrencyCode($taxAndDutyCurrencyCode)
            ->setTaxAndDutyCurrencyRate($taxAndDutyCurrencyRate)
            ->setTaxAndDutyStatusText($taxAndDutyStatusText);
    }
    /**
     * Get properties value
     * @return \Model\Property[]|null
     */
    public function getProperties()
    {
        return $this->properties;
    }
    /**
     * Set properties value
     * @throws \InvalidArgumentException
     * @param \Model\Property[] $properties
     * @return \Model\TaxAndDuty
     */
    public function setProperties(array $properties = array())
    {
        foreach ($properties as $taxAndDutyPropertiesItem) {
            // validation for constraint: itemType
            if (!$taxAndDutyPropertiesItem instanceof \Model\Property) {
                throw new \InvalidArgumentException(sprintf('The properties property can only contain items of \Model\Property, "%s" given', is_object($taxAndDutyPropertiesItem) ? get_class($taxAndDutyPropertiesItem) : gettype($taxAndDutyPropertiesItem)), __LINE__);
            }
        }
        $this->properties = $properties;
        return $this;
    }
    /**
     * Add item to properties value
     * @throws \InvalidArgumentException
     * @param \Model\Property $item
     * @return \Model\TaxAndDuty
     */
    public function addToProperties(\Model\Property $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Model\Property) {
            throw new \InvalidArgumentException(sprintf('The properties property can only contain items of \Model\Property, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->properties[] = $item;
        return $this;
    }
    /**
     * Get taxAndDuty value
     * @return float|null
     */
    public function getTaxAndDuty()
    {
        return $this->taxAndDuty;
    }
    /**
     * Set taxAndDuty value
     * @param float $taxAndDuty
     * @return \Model\TaxAndDuty
     */
    public function setTaxAndDuty($taxAndDuty = null)
    {
        $this->taxAndDuty = $taxAndDuty;
        return $this;
    }
    /**
     * Get taxAndDutyCurrencyCode value
     * @return string|null
     */
    public function getTaxAndDutyCurrencyCode()
    {
        return $this->taxAndDutyCurrencyCode;
    }
    /**
     * Set taxAndDutyCurrencyCode value
     * @param string $taxAndDutyCurrencyCode
     * @return \Model\TaxAndDuty
     */
    public function setTaxAndDutyCurrencyCode($taxAndDutyCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxAndDutyCurrencyCode) && !is_string($taxAndDutyCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxAndDutyCurrencyCode)), __LINE__);
        }
        $this->taxAndDutyCurrencyCode = $taxAndDutyCurrencyCode;
        return $this;
    }
    /**
     * Get taxAndDutyCurrencyRate value
     * @return float|null
     */
    public function getTaxAndDutyCurrencyRate()
    {
        return $this->taxAndDutyCurrencyRate;
    }
    /**
     * Set taxAndDutyCurrencyRate value
     * @param float $taxAndDutyCurrencyRate
     * @return \Model\TaxAndDuty
     */
    public function setTaxAndDutyCurrencyRate($taxAndDutyCurrencyRate = null)
    {
        $this->taxAndDutyCurrencyRate = $taxAndDutyCurrencyRate;
        return $this;
    }
    /**
     * Get taxAndDutyStatusText value
     * @return string|null
     */
    public function getTaxAndDutyStatusText()
    {
        return $this->taxAndDutyStatusText;
    }
    /**
     * Set taxAndDutyStatusText value
     * @param string $taxAndDutyStatusText
     * @return \Model\TaxAndDuty
     */
    public function setTaxAndDutyStatusText($taxAndDutyStatusText = null)
    {
        // validation for constraint: string
        if (!is_null($taxAndDutyStatusText) && !is_string($taxAndDutyStatusText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxAndDutyStatusText)), __LINE__);
        }
        $this->taxAndDutyStatusText = $taxAndDutyStatusText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Model\TaxAndDuty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
