<?php

namespace Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Parcel Model
 * @subpackage Structs
 */
class Parcel extends AbstractStructBase
{
    /**
     * The CODParcelAmount
     * @var float
     */
    public $CODParcelAmount;
    /**
     * The cartonId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cartonId;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $code;
    /**
     * The destinationReference
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $destinationReference;
    /**
     * The dutyPaid
     * @var float
     */
    public $dutyPaid;
    /**
     * The number
     * @var int
     */
    public $number;
    /**
     * The originReference
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $originReference;
    /**
     * The outerConsignmentCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $outerConsignmentCode;
    /**
     * The outerParcelNumber
     * @var int
     */
    public $outerParcelNumber;
    /**
     * The packageTypeCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $packageTypeCode;
    /**
     * The parcelDepth
     * @var float
     */
    public $parcelDepth;
    /**
     * The parcelHeight
     * @var float
     */
    public $parcelHeight;
    /**
     * The parcelPrintStatus
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $parcelPrintStatus;
    /**
     * The parcelValue
     * @var float
     */
    public $parcelValue;
    /**
     * The parcelWeight
     * @var float
     */
    public $parcelWeight;
    /**
     * The parcelWidth
     * @var float
     */
    public $parcelWidth;
    /**
     * The products
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - arrayType: tns1:Product[]
     * - ref: soapenc:arrayType
     * @var \Model\Product[]
     */
    public $products;
    /**
     * The recipientReference
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $recipientReference;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $reference;
    /**
     * The senderReference
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $senderReference;
    /**
     * The trackingCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $trackingCode;
    /**
     * The trackingUrl
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $trackingUrl;
    /**
     * Constructor method for Parcel
     * @uses Parcel::setCODParcelAmount()
     * @uses Parcel::setCartonId()
     * @uses Parcel::setCode()
     * @uses Parcel::setDestinationReference()
     * @uses Parcel::setDutyPaid()
     * @uses Parcel::setNumber()
     * @uses Parcel::setOriginReference()
     * @uses Parcel::setOuterConsignmentCode()
     * @uses Parcel::setOuterParcelNumber()
     * @uses Parcel::setPackageTypeCode()
     * @uses Parcel::setParcelDepth()
     * @uses Parcel::setParcelHeight()
     * @uses Parcel::setParcelPrintStatus()
     * @uses Parcel::setParcelValue()
     * @uses Parcel::setParcelWeight()
     * @uses Parcel::setParcelWidth()
     * @uses Parcel::setProducts()
     * @uses Parcel::setRecipientReference()
     * @uses Parcel::setReference()
     * @uses Parcel::setSenderReference()
     * @uses Parcel::setTrackingCode()
     * @uses Parcel::setTrackingUrl()
     * @param float $cODParcelAmount
     * @param string $cartonId
     * @param string $code
     * @param string $destinationReference
     * @param float $dutyPaid
     * @param int $number
     * @param string $originReference
     * @param string $outerConsignmentCode
     * @param int $outerParcelNumber
     * @param string $packageTypeCode
     * @param float $parcelDepth
     * @param float $parcelHeight
     * @param string $parcelPrintStatus
     * @param float $parcelValue
     * @param float $parcelWeight
     * @param float $parcelWidth
     * @param \Model\Product[] $products
     * @param string $recipientReference
     * @param string $reference
     * @param string $senderReference
     * @param string $trackingCode
     * @param string $trackingUrl
     */
    public function __construct($cODParcelAmount = null, $cartonId = null, $code = null, $destinationReference = null, $dutyPaid = null, $number = null, $originReference = null, $outerConsignmentCode = null, $outerParcelNumber = null, $packageTypeCode = null, $parcelDepth = null, $parcelHeight = null, $parcelPrintStatus = null, $parcelValue = null, $parcelWeight = null, $parcelWidth = null, array $products = array(), $recipientReference = null, $reference = null, $senderReference = null, $trackingCode = null, $trackingUrl = null)
    {
        $this
            ->setCODParcelAmount($cODParcelAmount)
            ->setCartonId($cartonId)
            ->setCode($code)
            ->setDestinationReference($destinationReference)
            ->setDutyPaid($dutyPaid)
            ->setNumber($number)
            ->setOriginReference($originReference)
            ->setOuterConsignmentCode($outerConsignmentCode)
            ->setOuterParcelNumber($outerParcelNumber)
            ->setPackageTypeCode($packageTypeCode)
            ->setParcelDepth($parcelDepth)
            ->setParcelHeight($parcelHeight)
            ->setParcelPrintStatus($parcelPrintStatus)
            ->setParcelValue($parcelValue)
            ->setParcelWeight($parcelWeight)
            ->setParcelWidth($parcelWidth)
            ->setProducts($products)
            ->setRecipientReference($recipientReference)
            ->setReference($reference)
            ->setSenderReference($senderReference)
            ->setTrackingCode($trackingCode)
            ->setTrackingUrl($trackingUrl);
    }
    /**
     * Get CODParcelAmount value
     * @return float|null
     */
    public function getCODParcelAmount()
    {
        return $this->CODParcelAmount;
    }
    /**
     * Set CODParcelAmount value
     * @param float $cODParcelAmount
     * @return \Model\Parcel
     */
    public function setCODParcelAmount($cODParcelAmount = null)
    {
        $this->CODParcelAmount = $cODParcelAmount;
        return $this;
    }
    /**
     * Get cartonId value
     * @return string|null
     */
    public function getCartonId()
    {
        return $this->cartonId;
    }
    /**
     * Set cartonId value
     * @param string $cartonId
     * @return \Model\Parcel
     */
    public function setCartonId($cartonId = null)
    {
        // validation for constraint: string
        if (!is_null($cartonId) && !is_string($cartonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cartonId)), __LINE__);
        }
        $this->cartonId = $cartonId;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \Model\Parcel
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get destinationReference value
     * @return string|null
     */
    public function getDestinationReference()
    {
        return $this->destinationReference;
    }
    /**
     * Set destinationReference value
     * @param string $destinationReference
     * @return \Model\Parcel
     */
    public function setDestinationReference($destinationReference = null)
    {
        // validation for constraint: string
        if (!is_null($destinationReference) && !is_string($destinationReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationReference)), __LINE__);
        }
        $this->destinationReference = $destinationReference;
        return $this;
    }
    /**
     * Get dutyPaid value
     * @return float|null
     */
    public function getDutyPaid()
    {
        return $this->dutyPaid;
    }
    /**
     * Set dutyPaid value
     * @param float $dutyPaid
     * @return \Model\Parcel
     */
    public function setDutyPaid($dutyPaid = null)
    {
        $this->dutyPaid = $dutyPaid;
        return $this;
    }
    /**
     * Get number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \Model\Parcel
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !is_numeric($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get originReference value
     * @return string|null
     */
    public function getOriginReference()
    {
        return $this->originReference;
    }
    /**
     * Set originReference value
     * @param string $originReference
     * @return \Model\Parcel
     */
    public function setOriginReference($originReference = null)
    {
        // validation for constraint: string
        if (!is_null($originReference) && !is_string($originReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originReference)), __LINE__);
        }
        $this->originReference = $originReference;
        return $this;
    }
    /**
     * Get outerConsignmentCode value
     * @return string|null
     */
    public function getOuterConsignmentCode()
    {
        return $this->outerConsignmentCode;
    }
    /**
     * Set outerConsignmentCode value
     * @param string $outerConsignmentCode
     * @return \Model\Parcel
     */
    public function setOuterConsignmentCode($outerConsignmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($outerConsignmentCode) && !is_string($outerConsignmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($outerConsignmentCode)), __LINE__);
        }
        $this->outerConsignmentCode = $outerConsignmentCode;
        return $this;
    }
    /**
     * Get outerParcelNumber value
     * @return int|null
     */
    public function getOuterParcelNumber()
    {
        return $this->outerParcelNumber;
    }
    /**
     * Set outerParcelNumber value
     * @param int $outerParcelNumber
     * @return \Model\Parcel
     */
    public function setOuterParcelNumber($outerParcelNumber = null)
    {
        // validation for constraint: int
        if (!is_null($outerParcelNumber) && !is_numeric($outerParcelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($outerParcelNumber)), __LINE__);
        }
        $this->outerParcelNumber = $outerParcelNumber;
        return $this;
    }
    /**
     * Get packageTypeCode value
     * @return string|null
     */
    public function getPackageTypeCode()
    {
        return $this->packageTypeCode;
    }
    /**
     * Set packageTypeCode value
     * @param string $packageTypeCode
     * @return \Model\Parcel
     */
    public function setPackageTypeCode($packageTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($packageTypeCode) && !is_string($packageTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageTypeCode)), __LINE__);
        }
        $this->packageTypeCode = $packageTypeCode;
        return $this;
    }
    /**
     * Get parcelDepth value
     * @return float|null
     */
    public function getParcelDepth()
    {
        return $this->parcelDepth;
    }
    /**
     * Set parcelDepth value
     * @param float $parcelDepth
     * @return \Model\Parcel
     */
    public function setParcelDepth($parcelDepth = null)
    {
        $this->parcelDepth = $parcelDepth;
        return $this;
    }
    /**
     * Get parcelHeight value
     * @return float|null
     */
    public function getParcelHeight()
    {
        return $this->parcelHeight;
    }
    /**
     * Set parcelHeight value
     * @param float $parcelHeight
     * @return \Model\Parcel
     */
    public function setParcelHeight($parcelHeight = null)
    {
        $this->parcelHeight = $parcelHeight;
        return $this;
    }
    /**
     * Get parcelPrintStatus value
     * @return string|null
     */
    public function getParcelPrintStatus()
    {
        return $this->parcelPrintStatus;
    }
    /**
     * Set parcelPrintStatus value
     * @param string $parcelPrintStatus
     * @return \Model\Parcel
     */
    public function setParcelPrintStatus($parcelPrintStatus = null)
    {
        // validation for constraint: string
        if (!is_null($parcelPrintStatus) && !is_string($parcelPrintStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parcelPrintStatus)), __LINE__);
        }
        $this->parcelPrintStatus = $parcelPrintStatus;
        return $this;
    }
    /**
     * Get parcelValue value
     * @return float|null
     */
    public function getParcelValue()
    {
        return $this->parcelValue;
    }
    /**
     * Set parcelValue value
     * @param float $parcelValue
     * @return \Model\Parcel
     */
    public function setParcelValue($parcelValue = null)
    {
        $this->parcelValue = $parcelValue;
        return $this;
    }
    /**
     * Get parcelWeight value
     * @return float|null
     */
    public function getParcelWeight()
    {
        return $this->parcelWeight;
    }
    /**
     * Set parcelWeight value
     * @param float $parcelWeight
     * @return \Model\Parcel
     */
    public function setParcelWeight($parcelWeight = null)
    {
        $this->parcelWeight = $parcelWeight;
        return $this;
    }
    /**
     * Get parcelWidth value
     * @return float|null
     */
    public function getParcelWidth()
    {
        return $this->parcelWidth;
    }
    /**
     * Set parcelWidth value
     * @param float $parcelWidth
     * @return \Model\Parcel
     */
    public function setParcelWidth($parcelWidth = null)
    {
        $this->parcelWidth = $parcelWidth;
        return $this;
    }
    /**
     * Get products value
     * @return \Model\Product[]|null
     */
    public function getProducts()
    {
        return $this->products;
    }
    /**
     * Set products value
     * @throws \InvalidArgumentException
     * @param \Model\Product[] $products
     * @return \Model\Parcel
     */
    public function setProducts(array $products = array())
    {
        foreach ($products as $parcelProductsItem) {
            // validation for constraint: itemType
            if (!$parcelProductsItem instanceof \Model\Product) {
                throw new \InvalidArgumentException(sprintf('The products property can only contain items of \Model\Product, "%s" given', is_object($parcelProductsItem) ? get_class($parcelProductsItem) : gettype($parcelProductsItem)), __LINE__);
            }
        }
        $this->products = $products;
        return $this;
    }
    /**
     * Add item to products value
     * @throws \InvalidArgumentException
     * @param \Model\Product $item
     * @return \Model\Parcel
     */
    public function addToProducts(\Model\Product $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Model\Product) {
            throw new \InvalidArgumentException(sprintf('The products property can only contain items of \Model\Product, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->products[] = $item;
        return $this;
    }
    /**
     * Get recipientReference value
     * @return string|null
     */
    public function getRecipientReference()
    {
        return $this->recipientReference;
    }
    /**
     * Set recipientReference value
     * @param string $recipientReference
     * @return \Model\Parcel
     */
    public function setRecipientReference($recipientReference = null)
    {
        // validation for constraint: string
        if (!is_null($recipientReference) && !is_string($recipientReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientReference)), __LINE__);
        }
        $this->recipientReference = $recipientReference;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \Model\Parcel
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get senderReference value
     * @return string|null
     */
    public function getSenderReference()
    {
        return $this->senderReference;
    }
    /**
     * Set senderReference value
     * @param string $senderReference
     * @return \Model\Parcel
     */
    public function setSenderReference($senderReference = null)
    {
        // validation for constraint: string
        if (!is_null($senderReference) && !is_string($senderReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderReference)), __LINE__);
        }
        $this->senderReference = $senderReference;
        return $this;
    }
    /**
     * Get trackingCode value
     * @return string|null
     */
    public function getTrackingCode()
    {
        return $this->trackingCode;
    }
    /**
     * Set trackingCode value
     * @param string $trackingCode
     * @return \Model\Parcel
     */
    public function setTrackingCode($trackingCode = null)
    {
        // validation for constraint: string
        if (!is_null($trackingCode) && !is_string($trackingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingCode)), __LINE__);
        }
        $this->trackingCode = $trackingCode;
        return $this;
    }
    /**
     * Get trackingUrl value
     * @return string|null
     */
    public function getTrackingUrl()
    {
        return $this->trackingUrl;
    }
    /**
     * Set trackingUrl value
     * @param string $trackingUrl
     * @return \Model\Parcel
     */
    public function setTrackingUrl($trackingUrl = null)
    {
        // validation for constraint: string
        if (!is_null($trackingUrl) && !is_string($trackingUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingUrl)), __LINE__);
        }
        $this->trackingUrl = $trackingUrl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Model\Parcel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
