<?php

namespace Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Paperwork Model
 * @subpackage Structs
 */
class Paperwork extends AbstractStructBase
{
    /**
     * The documents
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $documents;
    /**
     * The labels
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $labels;
    /**
     * Constructor method for Paperwork
     * @uses Paperwork::setDocuments()
     * @uses Paperwork::setLabels()
     * @param string $documents
     * @param string $labels
     */
    public function __construct($documents = null, $labels = null)
    {
        $this
            ->setDocuments($documents)
            ->setLabels($labels);
    }
    /**
     * Get documents value
     * @return string|null
     */
    public function getDocuments()
    {
        return $this->documents;
    }
    /**
     * Set documents value
     * @param string $documents
     * @return \Model\Paperwork
     */
    public function setDocuments($documents = null)
    {
        // validation for constraint: string
        if (!is_null($documents) && !is_string($documents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documents)), __LINE__);
        }
        $this->documents = $documents;
        return $this;
    }
    /**
     * Get labels value
     * @return string|null
     */
    public function getLabels()
    {
        return $this->labels;
    }
    /**
     * Set labels value
     * @param string $labels
     * @return \Model\Paperwork
     */
    public function setLabels($labels = null)
    {
        // validation for constraint: string
        if (!is_null($labels) && !is_string($labels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($labels)), __LINE__);
        }
        $this->labels = $labels;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Model\Paperwork
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
