<?php

namespace Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address Model
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The companyName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $companyName;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $countryCode;
    /**
     * The floor
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $floor;
    /**
     * The line1
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $line1;
    /**
     * The line2
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $line2;
    /**
     * The line3
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $line3;
    /**
     * The line4
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $line4;
    /**
     * The postCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $postCode;
    /**
     * The region
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $region;
    /**
     * The streetName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $streetName;
    /**
     * The streetNo
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $streetNo;
    /**
     * The streetType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $streetType;
    /**
     * The town
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $town;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $type;
    /**
     * Constructor method for Address
     * @uses Address::setCompanyName()
     * @uses Address::setCountryCode()
     * @uses Address::setFloor()
     * @uses Address::setLine1()
     * @uses Address::setLine2()
     * @uses Address::setLine3()
     * @uses Address::setLine4()
     * @uses Address::setPostCode()
     * @uses Address::setRegion()
     * @uses Address::setStreetName()
     * @uses Address::setStreetNo()
     * @uses Address::setStreetType()
     * @uses Address::setTown()
     * @uses Address::setType()
     * @param string $companyName
     * @param string $countryCode
     * @param string $floor
     * @param string $line1
     * @param string $line2
     * @param string $line3
     * @param string $line4
     * @param string $postCode
     * @param string $region
     * @param string $streetName
     * @param string $streetNo
     * @param string $streetType
     * @param string $town
     * @param string $type
     */
    public function __construct($companyName = null, $countryCode = null, $floor = null, $line1 = null, $line2 = null, $line3 = null, $line4 = null, $postCode = null, $region = null, $streetName = null, $streetNo = null, $streetType = null, $town = null, $type = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setCountryCode($countryCode)
            ->setFloor($floor)
            ->setLine1($line1)
            ->setLine2($line2)
            ->setLine3($line3)
            ->setLine4($line4)
            ->setPostCode($postCode)
            ->setRegion($region)
            ->setStreetName($streetName)
            ->setStreetNo($streetNo)
            ->setStreetType($streetType)
            ->setTown($town)
            ->setType($type);
    }
    /**
     * Get companyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->companyName;
    }
    /**
     * Set companyName value
     * @param string $companyName
     * @return \Model\Address
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyName)), __LINE__);
        }
        $this->companyName = $companyName;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \Model\Address
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get floor value
     * @return string|null
     */
    public function getFloor()
    {
        return $this->floor;
    }
    /**
     * Set floor value
     * @param string $floor
     * @return \Model\Address
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($floor)), __LINE__);
        }
        $this->floor = $floor;
        return $this;
    }
    /**
     * Get line1 value
     * @return string|null
     */
    public function getLine1()
    {
        return $this->line1;
    }
    /**
     * Set line1 value
     * @param string $line1
     * @return \Model\Address
     */
    public function setLine1($line1 = null)
    {
        // validation for constraint: string
        if (!is_null($line1) && !is_string($line1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($line1)), __LINE__);
        }
        $this->line1 = $line1;
        return $this;
    }
    /**
     * Get line2 value
     * @return string|null
     */
    public function getLine2()
    {
        return $this->line2;
    }
    /**
     * Set line2 value
     * @param string $line2
     * @return \Model\Address
     */
    public function setLine2($line2 = null)
    {
        // validation for constraint: string
        if (!is_null($line2) && !is_string($line2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($line2)), __LINE__);
        }
        $this->line2 = $line2;
        return $this;
    }
    /**
     * Get line3 value
     * @return string|null
     */
    public function getLine3()
    {
        return $this->line3;
    }
    /**
     * Set line3 value
     * @param string $line3
     * @return \Model\Address
     */
    public function setLine3($line3 = null)
    {
        // validation for constraint: string
        if (!is_null($line3) && !is_string($line3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($line3)), __LINE__);
        }
        $this->line3 = $line3;
        return $this;
    }
    /**
     * Get line4 value
     * @return string|null
     */
    public function getLine4()
    {
        return $this->line4;
    }
    /**
     * Set line4 value
     * @param string $line4
     * @return \Model\Address
     */
    public function setLine4($line4 = null)
    {
        // validation for constraint: string
        if (!is_null($line4) && !is_string($line4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($line4)), __LINE__);
        }
        $this->line4 = $line4;
        return $this;
    }
    /**
     * Get postCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->postCode;
    }
    /**
     * Set postCode value
     * @param string $postCode
     * @return \Model\Address
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postCode)), __LINE__);
        }
        $this->postCode = $postCode;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \Model\Address
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get streetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->streetName;
    }
    /**
     * Set streetName value
     * @param string $streetName
     * @return \Model\Address
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetName)), __LINE__);
        }
        $this->streetName = $streetName;
        return $this;
    }
    /**
     * Get streetNo value
     * @return string|null
     */
    public function getStreetNo()
    {
        return $this->streetNo;
    }
    /**
     * Set streetNo value
     * @param string $streetNo
     * @return \Model\Address
     */
    public function setStreetNo($streetNo = null)
    {
        // validation for constraint: string
        if (!is_null($streetNo) && !is_string($streetNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetNo)), __LINE__);
        }
        $this->streetNo = $streetNo;
        return $this;
    }
    /**
     * Get streetType value
     * @return string|null
     */
    public function getStreetType()
    {
        return $this->streetType;
    }
    /**
     * Set streetType value
     * @param string $streetType
     * @return \Model\Address
     */
    public function setStreetType($streetType = null)
    {
        // validation for constraint: string
        if (!is_null($streetType) && !is_string($streetType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetType)), __LINE__);
        }
        $this->streetType = $streetType;
        return $this;
    }
    /**
     * Get town value
     * @return string|null
     */
    public function getTown()
    {
        return $this->town;
    }
    /**
     * Set town value
     * @param string $town
     * @return \Model\Address
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($town)), __LINE__);
        }
        $this->town = $town;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Model\Address
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Model\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
