<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://demo-ipg.comtrust.ae:2443/MerchantAPIX.svc?singleWsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://demo-ipg.comtrust.ae:2443/MerchantAPIX.svc?singleWsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Register ServiceType
 */
$register = new \ServiceType\Register($options);
/**
 * Sample call for Register operation/method
 */
if ($register->Register(new \StructType\Register()) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Samples for Authorize ServiceType
 */
$authorize = new \ServiceType\Authorize($options);
/**
 * Sample call for Authorize operation/method
 */
if ($authorize->Authorize(new \StructType\Authorize()) !== false) {
    print_r($authorize->getResult());
} else {
    print_r($authorize->getLastError());
}
/**
 * Samples for Finalize ServiceType
 */
$finalize = new \ServiceType\Finalize($options);
/**
 * Sample call for Finalize operation/method
 */
if ($finalize->Finalize(new \StructType\Finalize()) !== false) {
    print_r($finalize->getResult());
} else {
    print_r($finalize->getLastError());
}
/**
 * Samples for Capture ServiceType
 */
$capture = new \ServiceType\Capture($options);
/**
 * Sample call for Capture operation/method
 */
if ($capture->Capture(new \StructType\Capture()) !== false) {
    print_r($capture->getResult());
} else {
    print_r($capture->getLastError());
}
/**
 * Samples for Reverse ServiceType
 */
$reverse = new \ServiceType\Reverse($options);
/**
 * Sample call for Reverse operation/method
 */
if ($reverse->Reverse(new \StructType\Reverse()) !== false) {
    print_r($reverse->getResult());
} else {
    print_r($reverse->getLastError());
}
/**
 * Samples for Refund ServiceType
 */
$refund = new \ServiceType\Refund($options);
/**
 * Sample call for Refund operation/method
 */
if ($refund->Refund(new \StructType\Refund()) !== false) {
    print_r($refund->getResult());
} else {
    print_r($refund->getLastError());
}
/**
 * Samples for Execute ServiceType
 */
$execute = new \ServiceType\Execute($options);
/**
 * Sample call for Execute operation/method
 */
if ($execute->Execute(new \StructType\Execute()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Samples for Query ServiceType
 */
$query = new \ServiceType\Query($options);
/**
 * Sample call for QueryTransaction operation/method
 */
if ($query->QueryTransaction(new \StructType\QueryTransaction()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryData operation/method
 */
if ($query->QueryData(new \StructType\QueryData()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Samples for Emv ServiceType
 */
$emv = new \ServiceType\Emv($options);
/**
 * Sample call for EmvAuthorize operation/method
 */
if ($emv->EmvAuthorize(new \StructType\EmvAuthorize()) !== false) {
    print_r($emv->getResult());
} else {
    print_r($emv->getLastError());
}
