<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionRequestBaseX StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionRequestBaseX
 * @subpackage Structs
 */
class TransactionRequestBaseX extends AbstractStructBase
{
    /**
     * The RequestDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestDate;
    /**
     * The RequestGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestGuid;
    /**
     * The RequestXML
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestXML;
    /**
     * The ResponseCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseCode;
    /**
     * The ResponseXML
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseXML;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DataX
     */
    public $Type;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Version;
    /**
     * Constructor method for TransactionRequestBaseX
     * @uses TransactionRequestBaseX::setRequestDate()
     * @uses TransactionRequestBaseX::setRequestGuid()
     * @uses TransactionRequestBaseX::setRequestXML()
     * @uses TransactionRequestBaseX::setResponseCode()
     * @uses TransactionRequestBaseX::setResponseXML()
     * @uses TransactionRequestBaseX::setType()
     * @uses TransactionRequestBaseX::setVersion()
     * @param string $requestDate
     * @param string $requestGuid
     * @param string $requestXML
     * @param string $responseCode
     * @param string $responseXML
     * @param \StructType\DataX $type
     * @param string $version
     */
    public function __construct($requestDate = null, $requestGuid = null, $requestXML = null, $responseCode = null, $responseXML = null, \StructType\DataX $type = null, $version = null)
    {
        $this
            ->setRequestDate($requestDate)
            ->setRequestGuid($requestGuid)
            ->setRequestXML($requestXML)
            ->setResponseCode($responseCode)
            ->setResponseXML($responseXML)
            ->setType($type)
            ->setVersion($version);
    }
    /**
     * Get RequestDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestDate()
    {
        return isset($this->RequestDate) ? $this->RequestDate : null;
    }
    /**
     * Set RequestDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestDate
     * @return \StructType\TransactionRequestBaseX
     */
    public function setRequestDate($requestDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestDate) && !is_string($requestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestDate)), __LINE__);
        }
        if (is_null($requestDate) || (is_array($requestDate) && empty($requestDate))) {
            unset($this->RequestDate);
        } else {
            $this->RequestDate = $requestDate;
        }
        return $this;
    }
    /**
     * Get RequestGuid value
     * @return string|null
     */
    public function getRequestGuid()
    {
        return $this->RequestGuid;
    }
    /**
     * Set RequestGuid value
     * @param string $requestGuid
     * @return \StructType\TransactionRequestBaseX
     */
    public function setRequestGuid($requestGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requestGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($requestGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestGuid) && !is_string($requestGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestGuid)), __LINE__);
        }
        $this->RequestGuid = $requestGuid;
        return $this;
    }
    /**
     * Get RequestXML value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestXML()
    {
        return isset($this->RequestXML) ? $this->RequestXML : null;
    }
    /**
     * Set RequestXML value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestXML
     * @return \StructType\TransactionRequestBaseX
     */
    public function setRequestXML($requestXML = null)
    {
        // validation for constraint: string
        if (!is_null($requestXML) && !is_string($requestXML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestXML)), __LINE__);
        }
        if (is_null($requestXML) || (is_array($requestXML) && empty($requestXML))) {
            unset($this->RequestXML);
        } else {
            $this->RequestXML = $requestXML;
        }
        return $this;
    }
    /**
     * Get ResponseCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseCode()
    {
        return isset($this->ResponseCode) ? $this->ResponseCode : null;
    }
    /**
     * Set ResponseCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseCode
     * @return \StructType\TransactionRequestBaseX
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseCode)), __LINE__);
        }
        if (is_null($responseCode) || (is_array($responseCode) && empty($responseCode))) {
            unset($this->ResponseCode);
        } else {
            $this->ResponseCode = $responseCode;
        }
        return $this;
    }
    /**
     * Get ResponseXML value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseXML()
    {
        return isset($this->ResponseXML) ? $this->ResponseXML : null;
    }
    /**
     * Set ResponseXML value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseXML
     * @return \StructType\TransactionRequestBaseX
     */
    public function setResponseXML($responseXML = null)
    {
        // validation for constraint: string
        if (!is_null($responseXML) && !is_string($responseXML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseXML)), __LINE__);
        }
        if (is_null($responseXML) || (is_array($responseXML) && empty($responseXML))) {
            unset($this->ResponseXML);
        } else {
            $this->ResponseXML = $responseXML;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DataX|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DataX $type
     * @return \StructType\TransactionRequestBaseX
     */
    public function setType(\StructType\DataX $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get Version value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVersion()
    {
        return isset($this->Version) ? $this->Version : null;
    }
    /**
     * Set Version value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $version
     * @return \StructType\TransactionRequestBaseX
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        if (is_null($version) || (is_array($version) && empty($version))) {
            unset($this->Version);
        } else {
            $this->Version = $version;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransactionRequestBaseX
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
