<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionMasterX StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionMasterX
 * @subpackage Structs
 */
class TransactionMasterX extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The Balance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Balance;
    /**
     * The Channel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Channel;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Fees;
    /**
     * The Hint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Hint;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderID;
    /**
     * The OrderInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderInfo;
    /**
     * The OrderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderName;
    /**
     * The ResponseParamters
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDataX
     */
    public $ResponseParamters;
    /**
     * Constructor method for TransactionMasterX
     * @uses TransactionMasterX::setAmount()
     * @uses TransactionMasterX::setBalance()
     * @uses TransactionMasterX::setChannel()
     * @uses TransactionMasterX::setCurrency()
     * @uses TransactionMasterX::setFees()
     * @uses TransactionMasterX::setHint()
     * @uses TransactionMasterX::setOrderID()
     * @uses TransactionMasterX::setOrderInfo()
     * @uses TransactionMasterX::setOrderName()
     * @uses TransactionMasterX::setResponseParamters()
     * @param float $amount
     * @param float $balance
     * @param string $channel
     * @param string $currency
     * @param float $fees
     * @param string $hint
     * @param string $orderID
     * @param string $orderInfo
     * @param string $orderName
     * @param \ArrayType\ArrayOfDataX $responseParamters
     */
    public function __construct($amount = null, $balance = null, $channel = null, $currency = null, $fees = null, $hint = null, $orderID = null, $orderInfo = null, $orderName = null, \ArrayType\ArrayOfDataX $responseParamters = null)
    {
        $this
            ->setAmount($amount)
            ->setBalance($balance)
            ->setChannel($channel)
            ->setCurrency($currency)
            ->setFees($fees)
            ->setHint($hint)
            ->setOrderID($orderID)
            ->setOrderInfo($orderInfo)
            ->setOrderName($orderName)
            ->setResponseParamters($responseParamters);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amount
     * @return \StructType\TransactionMasterX
     */
    public function setAmount($amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get Balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \StructType\TransactionMasterX
     */
    public function setBalance($balance = null)
    {
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get Channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->Channel;
    }
    /**
     * Set Channel value
     * @uses \EnumType\Channels::valueIsValid()
     * @uses \EnumType\Channels::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $channel
     * @return \StructType\TransactionMasterX
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Channels::valueIsValid($channel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $channel, implode(', ', \EnumType\Channels::getValidValues())), __LINE__);
        }
        $this->Channel = $channel;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @uses \EnumType\Currencies::valueIsValid()
     * @uses \EnumType\Currencies::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\TransactionMasterX
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Currencies::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $currency, implode(', ', \EnumType\Currencies::getValidValues())), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Fees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFees()
    {
        return isset($this->Fees) ? $this->Fees : null;
    }
    /**
     * Set Fees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $fees
     * @return \StructType\TransactionMasterX
     */
    public function setFees($fees = null)
    {
        if (is_null($fees) || (is_array($fees) && empty($fees))) {
            unset($this->Fees);
        } else {
            $this->Fees = $fees;
        }
        return $this;
    }
    /**
     * Get Hint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHint()
    {
        return isset($this->Hint) ? $this->Hint : null;
    }
    /**
     * Set Hint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hint
     * @return \StructType\TransactionMasterX
     */
    public function setHint($hint = null)
    {
        // validation for constraint: string
        if (!is_null($hint) && !is_string($hint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hint)), __LINE__);
        }
        if (is_null($hint) || (is_array($hint) && empty($hint))) {
            unset($this->Hint);
        } else {
            $this->Hint = $hint;
        }
        return $this;
    }
    /**
     * Get OrderID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderID()
    {
        return isset($this->OrderID) ? $this->OrderID : null;
    }
    /**
     * Set OrderID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderID
     * @return \StructType\TransactionMasterX
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderID)), __LINE__);
        }
        if (is_null($orderID) || (is_array($orderID) && empty($orderID))) {
            unset($this->OrderID);
        } else {
            $this->OrderID = $orderID;
        }
        return $this;
    }
    /**
     * Get OrderInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderInfo()
    {
        return isset($this->OrderInfo) ? $this->OrderInfo : null;
    }
    /**
     * Set OrderInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderInfo
     * @return \StructType\TransactionMasterX
     */
    public function setOrderInfo($orderInfo = null)
    {
        // validation for constraint: string
        if (!is_null($orderInfo) && !is_string($orderInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderInfo)), __LINE__);
        }
        if (is_null($orderInfo) || (is_array($orderInfo) && empty($orderInfo))) {
            unset($this->OrderInfo);
        } else {
            $this->OrderInfo = $orderInfo;
        }
        return $this;
    }
    /**
     * Get OrderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderName()
    {
        return isset($this->OrderName) ? $this->OrderName : null;
    }
    /**
     * Set OrderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderName
     * @return \StructType\TransactionMasterX
     */
    public function setOrderName($orderName = null)
    {
        // validation for constraint: string
        if (!is_null($orderName) && !is_string($orderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderName)), __LINE__);
        }
        if (is_null($orderName) || (is_array($orderName) && empty($orderName))) {
            unset($this->OrderName);
        } else {
            $this->OrderName = $orderName;
        }
        return $this;
    }
    /**
     * Get ResponseParamters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDataX|null
     */
    public function getResponseParamters()
    {
        return isset($this->ResponseParamters) ? $this->ResponseParamters : null;
    }
    /**
     * Set ResponseParamters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDataX $responseParamters
     * @return \StructType\TransactionMasterX
     */
    public function setResponseParamters(\ArrayType\ArrayOfDataX $responseParamters = null)
    {
        if (is_null($responseParamters) || (is_array($responseParamters) && empty($responseParamters))) {
            unset($this->ResponseParamters);
        } else {
            $this->ResponseParamters = $responseParamters;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransactionMasterX
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
