<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionAccountX StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionAccountX
 * @subpackage Structs
 */
class TransactionAccountX extends AbstractStructBase
{
    /**
     * The Acquirer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Acquirer;
    /**
     * The Merchant
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Merchant;
    /**
     * The MerchantAccount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchantAccount;
    /**
     * The ResponseParameters
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDataX
     */
    public $ResponseParameters;
    /**
     * The Store
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Store;
    /**
     * The Terminal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Terminal;
    /**
     * Constructor method for TransactionAccountX
     * @uses TransactionAccountX::setAcquirer()
     * @uses TransactionAccountX::setMerchant()
     * @uses TransactionAccountX::setMerchantAccount()
     * @uses TransactionAccountX::setResponseParameters()
     * @uses TransactionAccountX::setStore()
     * @uses TransactionAccountX::setTerminal()
     * @param string $acquirer
     * @param string $merchant
     * @param string $merchantAccount
     * @param \ArrayType\ArrayOfDataX $responseParameters
     * @param string $store
     * @param string $terminal
     */
    public function __construct($acquirer = null, $merchant = null, $merchantAccount = null, \ArrayType\ArrayOfDataX $responseParameters = null, $store = null, $terminal = null)
    {
        $this
            ->setAcquirer($acquirer)
            ->setMerchant($merchant)
            ->setMerchantAccount($merchantAccount)
            ->setResponseParameters($responseParameters)
            ->setStore($store)
            ->setTerminal($terminal);
    }
    /**
     * Get Acquirer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcquirer()
    {
        return isset($this->Acquirer) ? $this->Acquirer : null;
    }
    /**
     * Set Acquirer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acquirer
     * @return \StructType\TransactionAccountX
     */
    public function setAcquirer($acquirer = null)
    {
        // validation for constraint: string
        if (!is_null($acquirer) && !is_string($acquirer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acquirer)), __LINE__);
        }
        if (is_null($acquirer) || (is_array($acquirer) && empty($acquirer))) {
            unset($this->Acquirer);
        } else {
            $this->Acquirer = $acquirer;
        }
        return $this;
    }
    /**
     * Get Merchant value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchant()
    {
        return isset($this->Merchant) ? $this->Merchant : null;
    }
    /**
     * Set Merchant value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchant
     * @return \StructType\TransactionAccountX
     */
    public function setMerchant($merchant = null)
    {
        // validation for constraint: string
        if (!is_null($merchant) && !is_string($merchant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($merchant)), __LINE__);
        }
        if (is_null($merchant) || (is_array($merchant) && empty($merchant))) {
            unset($this->Merchant);
        } else {
            $this->Merchant = $merchant;
        }
        return $this;
    }
    /**
     * Get MerchantAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchantAccount()
    {
        return isset($this->MerchantAccount) ? $this->MerchantAccount : null;
    }
    /**
     * Set MerchantAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchantAccount
     * @return \StructType\TransactionAccountX
     */
    public function setMerchantAccount($merchantAccount = null)
    {
        // validation for constraint: string
        if (!is_null($merchantAccount) && !is_string($merchantAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($merchantAccount)), __LINE__);
        }
        if (is_null($merchantAccount) || (is_array($merchantAccount) && empty($merchantAccount))) {
            unset($this->MerchantAccount);
        } else {
            $this->MerchantAccount = $merchantAccount;
        }
        return $this;
    }
    /**
     * Get ResponseParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDataX|null
     */
    public function getResponseParameters()
    {
        return isset($this->ResponseParameters) ? $this->ResponseParameters : null;
    }
    /**
     * Set ResponseParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDataX $responseParameters
     * @return \StructType\TransactionAccountX
     */
    public function setResponseParameters(\ArrayType\ArrayOfDataX $responseParameters = null)
    {
        if (is_null($responseParameters) || (is_array($responseParameters) && empty($responseParameters))) {
            unset($this->ResponseParameters);
        } else {
            $this->ResponseParameters = $responseParameters;
        }
        return $this;
    }
    /**
     * Get Store value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStore()
    {
        return isset($this->Store) ? $this->Store : null;
    }
    /**
     * Set Store value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $store
     * @return \StructType\TransactionAccountX
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store)), __LINE__);
        }
        if (is_null($store) || (is_array($store) && empty($store))) {
            unset($this->Store);
        } else {
            $this->Store = $store;
        }
        return $this;
    }
    /**
     * Get Terminal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminal()
    {
        return isset($this->Terminal) ? $this->Terminal : null;
    }
    /**
     * Set Terminal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminal
     * @return \StructType\TransactionAccountX
     */
    public function setTerminal($terminal = null)
    {
        // validation for constraint: string
        if (!is_null($terminal) && !is_string($terminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminal)), __LINE__);
        }
        if (is_null($terminal) || (is_array($terminal) && empty($terminal))) {
            unset($this->Terminal);
        } else {
            $this->Terminal = $terminal;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransactionAccountX
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
