<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemplateResponseX StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TemplateResponseX
 * @subpackage Structs
 */
class TemplateResponseX extends AbstractStructBase
{
    /**
     * The ResponseCode
     * @var int
     */
    public $ResponseCode;
    /**
     * The ResponseDescription
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ResponseDescription;
    /**
     * The ResponseParameters
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDataX
     */
    public $ResponseParameters;
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\UniqueId
     */
    public $UniqueID;
    /**
     * Constructor method for TemplateResponseX
     * @uses TemplateResponseX::setResponseCode()
     * @uses TemplateResponseX::setResponseDescription()
     * @uses TemplateResponseX::setResponseParameters()
     * @uses TemplateResponseX::setUniqueID()
     * @param int $responseCode
     * @param string $responseDescription
     * @param \ArrayType\ArrayOfDataX $responseParameters
     * @param \StructType\UniqueId $uniqueID
     */
    public function __construct($responseCode = null, $responseDescription = null, \ArrayType\ArrayOfDataX $responseParameters = null, \StructType\UniqueId $uniqueID = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setResponseDescription($responseDescription)
            ->setResponseParameters($responseParameters)
            ->setUniqueID($uniqueID);
    }
    /**
     * Get ResponseCode value
     * @return int|null
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param int $responseCode
     * @return \StructType\TemplateResponseX
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: int
        if (!is_null($responseCode) && !is_numeric($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get ResponseDescription value
     * @return string|null
     */
    public function getResponseDescription()
    {
        return $this->ResponseDescription;
    }
    /**
     * Set ResponseDescription value
     * @param string $responseDescription
     * @return \StructType\TemplateResponseX
     */
    public function setResponseDescription($responseDescription = null)
    {
        // validation for constraint: string
        if (!is_null($responseDescription) && !is_string($responseDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseDescription)), __LINE__);
        }
        $this->ResponseDescription = $responseDescription;
        return $this;
    }
    /**
     * Get ResponseParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDataX|null
     */
    public function getResponseParameters()
    {
        return isset($this->ResponseParameters) ? $this->ResponseParameters : null;
    }
    /**
     * Set ResponseParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDataX $responseParameters
     * @return \StructType\TemplateResponseX
     */
    public function setResponseParameters(\ArrayType\ArrayOfDataX $responseParameters = null)
    {
        if (is_null($responseParameters) || (is_array($responseParameters) && empty($responseParameters))) {
            unset($this->ResponseParameters);
        } else {
            $this->ResponseParameters = $responseParameters;
        }
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueId|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueId $uniqueID
     * @return \StructType\TemplateResponseX
     */
    public function setUniqueID(\StructType\UniqueId $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TemplateResponseX
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
