<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmvAuthorizationResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EmvAuthorizationResponse
 * @subpackage Structs
 */
class EmvAuthorizationResponse extends TemplateResponseX
{
    /**
     * The AccountBrand
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountBrand;
    /**
     * The AccountExpiry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountExpiry;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The AccountToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountToken;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The ApprovalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApprovalCode;
    /**
     * The Balance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Balance;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Fees;
    /**
     * The IssuerAuthenticationData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssuerAuthenticationData;
    /**
     * The IssuerScript
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssuerScript;
    /**
     * The IssuerScriptTemplate1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssuerScriptTemplate1;
    /**
     * The IssuerScriptTemplate2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssuerScriptTemplate2;
    /**
     * The MerchantAccount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchantAccount;
    /**
     * The OfflineAuthorization
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OfflineAuthorization;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderID;
    /**
     * The RecurrenceID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecurrenceID;
    /**
     * The TransactionID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for EmvAuthorizationResponse
     * @uses EmvAuthorizationResponse::setAccountBrand()
     * @uses EmvAuthorizationResponse::setAccountExpiry()
     * @uses EmvAuthorizationResponse::setAccountNumber()
     * @uses EmvAuthorizationResponse::setAccountToken()
     * @uses EmvAuthorizationResponse::setAmount()
     * @uses EmvAuthorizationResponse::setApprovalCode()
     * @uses EmvAuthorizationResponse::setBalance()
     * @uses EmvAuthorizationResponse::setFees()
     * @uses EmvAuthorizationResponse::setIssuerAuthenticationData()
     * @uses EmvAuthorizationResponse::setIssuerScript()
     * @uses EmvAuthorizationResponse::setIssuerScriptTemplate1()
     * @uses EmvAuthorizationResponse::setIssuerScriptTemplate2()
     * @uses EmvAuthorizationResponse::setMerchantAccount()
     * @uses EmvAuthorizationResponse::setOfflineAuthorization()
     * @uses EmvAuthorizationResponse::setOrderID()
     * @uses EmvAuthorizationResponse::setRecurrenceID()
     * @uses EmvAuthorizationResponse::setTransactionID()
     * @param string $accountBrand
     * @param string $accountExpiry
     * @param string $accountNumber
     * @param string $accountToken
     * @param float $amount
     * @param string $approvalCode
     * @param float $balance
     * @param float $fees
     * @param string $issuerAuthenticationData
     * @param string $issuerScript
     * @param string $issuerScriptTemplate1
     * @param string $issuerScriptTemplate2
     * @param string $merchantAccount
     * @param bool $offlineAuthorization
     * @param string $orderID
     * @param string $recurrenceID
     * @param string $transactionID
     */
    public function __construct($accountBrand = null, $accountExpiry = null, $accountNumber = null, $accountToken = null, $amount = null, $approvalCode = null, $balance = null, $fees = null, $issuerAuthenticationData = null, $issuerScript = null, $issuerScriptTemplate1 = null, $issuerScriptTemplate2 = null, $merchantAccount = null, $offlineAuthorization = null, $orderID = null, $recurrenceID = null, $transactionID = null)
    {
        $this
            ->setAccountBrand($accountBrand)
            ->setAccountExpiry($accountExpiry)
            ->setAccountNumber($accountNumber)
            ->setAccountToken($accountToken)
            ->setAmount($amount)
            ->setApprovalCode($approvalCode)
            ->setBalance($balance)
            ->setFees($fees)
            ->setIssuerAuthenticationData($issuerAuthenticationData)
            ->setIssuerScript($issuerScript)
            ->setIssuerScriptTemplate1($issuerScriptTemplate1)
            ->setIssuerScriptTemplate2($issuerScriptTemplate2)
            ->setMerchantAccount($merchantAccount)
            ->setOfflineAuthorization($offlineAuthorization)
            ->setOrderID($orderID)
            ->setRecurrenceID($recurrenceID)
            ->setTransactionID($transactionID);
    }
    /**
     * Get AccountBrand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountBrand()
    {
        return isset($this->AccountBrand) ? $this->AccountBrand : null;
    }
    /**
     * Set AccountBrand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountBrand
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setAccountBrand($accountBrand = null)
    {
        // validation for constraint: string
        if (!is_null($accountBrand) && !is_string($accountBrand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountBrand)), __LINE__);
        }
        if (is_null($accountBrand) || (is_array($accountBrand) && empty($accountBrand))) {
            unset($this->AccountBrand);
        } else {
            $this->AccountBrand = $accountBrand;
        }
        return $this;
    }
    /**
     * Get AccountExpiry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountExpiry()
    {
        return isset($this->AccountExpiry) ? $this->AccountExpiry : null;
    }
    /**
     * Set AccountExpiry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountExpiry
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setAccountExpiry($accountExpiry = null)
    {
        // validation for constraint: string
        if (!is_null($accountExpiry) && !is_string($accountExpiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountExpiry)), __LINE__);
        }
        if (is_null($accountExpiry) || (is_array($accountExpiry) && empty($accountExpiry))) {
            unset($this->AccountExpiry);
        } else {
            $this->AccountExpiry = $accountExpiry;
        }
        return $this;
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get AccountToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountToken()
    {
        return isset($this->AccountToken) ? $this->AccountToken : null;
    }
    /**
     * Set AccountToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountToken
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setAccountToken($accountToken = null)
    {
        // validation for constraint: string
        if (!is_null($accountToken) && !is_string($accountToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountToken)), __LINE__);
        }
        if (is_null($accountToken) || (is_array($accountToken) && empty($accountToken))) {
            unset($this->AccountToken);
        } else {
            $this->AccountToken = $accountToken;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ApprovalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApprovalCode()
    {
        return isset($this->ApprovalCode) ? $this->ApprovalCode : null;
    }
    /**
     * Set ApprovalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $approvalCode
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setApprovalCode($approvalCode = null)
    {
        // validation for constraint: string
        if (!is_null($approvalCode) && !is_string($approvalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approvalCode)), __LINE__);
        }
        if (is_null($approvalCode) || (is_array($approvalCode) && empty($approvalCode))) {
            unset($this->ApprovalCode);
        } else {
            $this->ApprovalCode = $approvalCode;
        }
        return $this;
    }
    /**
     * Get Balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setBalance($balance = null)
    {
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get Fees value
     * @return float|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param float $fees
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setFees($fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get IssuerAuthenticationData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssuerAuthenticationData()
    {
        return isset($this->IssuerAuthenticationData) ? $this->IssuerAuthenticationData : null;
    }
    /**
     * Set IssuerAuthenticationData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issuerAuthenticationData
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setIssuerAuthenticationData($issuerAuthenticationData = null)
    {
        // validation for constraint: string
        if (!is_null($issuerAuthenticationData) && !is_string($issuerAuthenticationData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuerAuthenticationData)), __LINE__);
        }
        if (is_null($issuerAuthenticationData) || (is_array($issuerAuthenticationData) && empty($issuerAuthenticationData))) {
            unset($this->IssuerAuthenticationData);
        } else {
            $this->IssuerAuthenticationData = $issuerAuthenticationData;
        }
        return $this;
    }
    /**
     * Get IssuerScript value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssuerScript()
    {
        return isset($this->IssuerScript) ? $this->IssuerScript : null;
    }
    /**
     * Set IssuerScript value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issuerScript
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setIssuerScript($issuerScript = null)
    {
        // validation for constraint: string
        if (!is_null($issuerScript) && !is_string($issuerScript)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuerScript)), __LINE__);
        }
        if (is_null($issuerScript) || (is_array($issuerScript) && empty($issuerScript))) {
            unset($this->IssuerScript);
        } else {
            $this->IssuerScript = $issuerScript;
        }
        return $this;
    }
    /**
     * Get IssuerScriptTemplate1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssuerScriptTemplate1()
    {
        return isset($this->IssuerScriptTemplate1) ? $this->IssuerScriptTemplate1 : null;
    }
    /**
     * Set IssuerScriptTemplate1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issuerScriptTemplate1
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setIssuerScriptTemplate1($issuerScriptTemplate1 = null)
    {
        // validation for constraint: string
        if (!is_null($issuerScriptTemplate1) && !is_string($issuerScriptTemplate1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuerScriptTemplate1)), __LINE__);
        }
        if (is_null($issuerScriptTemplate1) || (is_array($issuerScriptTemplate1) && empty($issuerScriptTemplate1))) {
            unset($this->IssuerScriptTemplate1);
        } else {
            $this->IssuerScriptTemplate1 = $issuerScriptTemplate1;
        }
        return $this;
    }
    /**
     * Get IssuerScriptTemplate2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssuerScriptTemplate2()
    {
        return isset($this->IssuerScriptTemplate2) ? $this->IssuerScriptTemplate2 : null;
    }
    /**
     * Set IssuerScriptTemplate2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issuerScriptTemplate2
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setIssuerScriptTemplate2($issuerScriptTemplate2 = null)
    {
        // validation for constraint: string
        if (!is_null($issuerScriptTemplate2) && !is_string($issuerScriptTemplate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuerScriptTemplate2)), __LINE__);
        }
        if (is_null($issuerScriptTemplate2) || (is_array($issuerScriptTemplate2) && empty($issuerScriptTemplate2))) {
            unset($this->IssuerScriptTemplate2);
        } else {
            $this->IssuerScriptTemplate2 = $issuerScriptTemplate2;
        }
        return $this;
    }
    /**
     * Get MerchantAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchantAccount()
    {
        return isset($this->MerchantAccount) ? $this->MerchantAccount : null;
    }
    /**
     * Set MerchantAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchantAccount
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setMerchantAccount($merchantAccount = null)
    {
        // validation for constraint: string
        if (!is_null($merchantAccount) && !is_string($merchantAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($merchantAccount)), __LINE__);
        }
        if (is_null($merchantAccount) || (is_array($merchantAccount) && empty($merchantAccount))) {
            unset($this->MerchantAccount);
        } else {
            $this->MerchantAccount = $merchantAccount;
        }
        return $this;
    }
    /**
     * Get OfflineAuthorization value
     * @return bool|null
     */
    public function getOfflineAuthorization()
    {
        return $this->OfflineAuthorization;
    }
    /**
     * Set OfflineAuthorization value
     * @param bool $offlineAuthorization
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setOfflineAuthorization($offlineAuthorization = null)
    {
        // validation for constraint: boolean
        if (!is_null($offlineAuthorization) && !is_bool($offlineAuthorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($offlineAuthorization)), __LINE__);
        }
        $this->OfflineAuthorization = $offlineAuthorization;
        return $this;
    }
    /**
     * Get OrderID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderID()
    {
        return isset($this->OrderID) ? $this->OrderID : null;
    }
    /**
     * Set OrderID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderID
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderID)), __LINE__);
        }
        if (is_null($orderID) || (is_array($orderID) && empty($orderID))) {
            unset($this->OrderID);
        } else {
            $this->OrderID = $orderID;
        }
        return $this;
    }
    /**
     * Get RecurrenceID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecurrenceID()
    {
        return isset($this->RecurrenceID) ? $this->RecurrenceID : null;
    }
    /**
     * Set RecurrenceID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recurrenceID
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setRecurrenceID($recurrenceID = null)
    {
        // validation for constraint: string
        if (!is_null($recurrenceID) && !is_string($recurrenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recurrenceID)), __LINE__);
        }
        if (is_null($recurrenceID) || (is_array($recurrenceID) && empty($recurrenceID))) {
            unset($this->RecurrenceID);
        } else {
            $this->RecurrenceID = $recurrenceID;
        }
        return $this;
    }
    /**
     * Get TransactionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionID()
    {
        return isset($this->TransactionID) ? $this->TransactionID : null;
    }
    /**
     * Set TransactionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionID
     * @return \StructType\EmvAuthorizationResponse
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionID)), __LINE__);
        }
        if (is_null($transactionID) || (is_array($transactionID) && empty($transactionID))) {
            unset($this->TransactionID);
        } else {
            $this->TransactionID = $transactionID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmvAuthorizationResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
