<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorizationRequestX StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AuthorizationRequestX
 * @subpackage Structs
 */
class AuthorizationRequestX extends TemplateRequestX
{
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The CardTrackData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardTrackData;
    /**
     * The Channel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Channel;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The ExpiryDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpiryDate;
    /**
     * The IsFallBack
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsFallBack;
    /**
     * The IsMagneticStrip
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsMagneticStrip;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderID;
    /**
     * The OrderInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderInfo;
    /**
     * The OrderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderName;
    /**
     * The Recurrence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RecurrenceInfoX
     */
    public $Recurrence;
    /**
     * The RecurrenceID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecurrenceID;
    /**
     * The TransactionHint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionHint;
    /**
     * The VerifyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VerifyCode;
    /**
     * Constructor method for AuthorizationRequestX
     * @uses AuthorizationRequestX::setAccountNumber()
     * @uses AuthorizationRequestX::setAmount()
     * @uses AuthorizationRequestX::setCardTrackData()
     * @uses AuthorizationRequestX::setChannel()
     * @uses AuthorizationRequestX::setCurrency()
     * @uses AuthorizationRequestX::setExpiryDate()
     * @uses AuthorizationRequestX::setIsFallBack()
     * @uses AuthorizationRequestX::setIsMagneticStrip()
     * @uses AuthorizationRequestX::setOrderID()
     * @uses AuthorizationRequestX::setOrderInfo()
     * @uses AuthorizationRequestX::setOrderName()
     * @uses AuthorizationRequestX::setRecurrence()
     * @uses AuthorizationRequestX::setRecurrenceID()
     * @uses AuthorizationRequestX::setTransactionHint()
     * @uses AuthorizationRequestX::setVerifyCode()
     * @param string $accountNumber
     * @param float $amount
     * @param string $cardTrackData
     * @param string $channel
     * @param string $currency
     * @param string $expiryDate
     * @param string $isFallBack
     * @param string $isMagneticStrip
     * @param string $orderID
     * @param string $orderInfo
     * @param string $orderName
     * @param \StructType\RecurrenceInfoX $recurrence
     * @param string $recurrenceID
     * @param string $transactionHint
     * @param string $verifyCode
     */
    public function __construct($accountNumber = null, $amount = null, $cardTrackData = null, $channel = null, $currency = null, $expiryDate = null, $isFallBack = null, $isMagneticStrip = null, $orderID = null, $orderInfo = null, $orderName = null, \StructType\RecurrenceInfoX $recurrence = null, $recurrenceID = null, $transactionHint = null, $verifyCode = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setAmount($amount)
            ->setCardTrackData($cardTrackData)
            ->setChannel($channel)
            ->setCurrency($currency)
            ->setExpiryDate($expiryDate)
            ->setIsFallBack($isFallBack)
            ->setIsMagneticStrip($isMagneticStrip)
            ->setOrderID($orderID)
            ->setOrderInfo($orderInfo)
            ->setOrderName($orderName)
            ->setRecurrence($recurrence)
            ->setRecurrenceID($recurrenceID)
            ->setTransactionHint($transactionHint)
            ->setVerifyCode($verifyCode);
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \StructType\AuthorizationRequestX
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AuthorizationRequestX
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CardTrackData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardTrackData()
    {
        return isset($this->CardTrackData) ? $this->CardTrackData : null;
    }
    /**
     * Set CardTrackData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardTrackData
     * @return \StructType\AuthorizationRequestX
     */
    public function setCardTrackData($cardTrackData = null)
    {
        // validation for constraint: string
        if (!is_null($cardTrackData) && !is_string($cardTrackData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardTrackData)), __LINE__);
        }
        if (is_null($cardTrackData) || (is_array($cardTrackData) && empty($cardTrackData))) {
            unset($this->CardTrackData);
        } else {
            $this->CardTrackData = $cardTrackData;
        }
        return $this;
    }
    /**
     * Get Channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->Channel;
    }
    /**
     * Set Channel value
     * @uses \EnumType\Channels::valueIsValid()
     * @uses \EnumType\Channels::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $channel
     * @return \StructType\AuthorizationRequestX
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Channels::valueIsValid($channel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $channel, implode(', ', \EnumType\Channels::getValidValues())), __LINE__);
        }
        $this->Channel = $channel;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @uses \EnumType\Currencies::valueIsValid()
     * @uses \EnumType\Currencies::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\AuthorizationRequestX
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Currencies::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $currency, implode(', ', \EnumType\Currencies::getValidValues())), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param string $expiryDate
     * @return \StructType\AuthorizationRequestX
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDate)), __LINE__);
        }
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get IsFallBack value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsFallBack()
    {
        return isset($this->IsFallBack) ? $this->IsFallBack : null;
    }
    /**
     * Set IsFallBack value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isFallBack
     * @return \StructType\AuthorizationRequestX
     */
    public function setIsFallBack($isFallBack = null)
    {
        // validation for constraint: string
        if (!is_null($isFallBack) && !is_string($isFallBack)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isFallBack)), __LINE__);
        }
        if (is_null($isFallBack) || (is_array($isFallBack) && empty($isFallBack))) {
            unset($this->IsFallBack);
        } else {
            $this->IsFallBack = $isFallBack;
        }
        return $this;
    }
    /**
     * Get IsMagneticStrip value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsMagneticStrip()
    {
        return isset($this->IsMagneticStrip) ? $this->IsMagneticStrip : null;
    }
    /**
     * Set IsMagneticStrip value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isMagneticStrip
     * @return \StructType\AuthorizationRequestX
     */
    public function setIsMagneticStrip($isMagneticStrip = null)
    {
        // validation for constraint: string
        if (!is_null($isMagneticStrip) && !is_string($isMagneticStrip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isMagneticStrip)), __LINE__);
        }
        if (is_null($isMagneticStrip) || (is_array($isMagneticStrip) && empty($isMagneticStrip))) {
            unset($this->IsMagneticStrip);
        } else {
            $this->IsMagneticStrip = $isMagneticStrip;
        }
        return $this;
    }
    /**
     * Get OrderID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderID()
    {
        return isset($this->OrderID) ? $this->OrderID : null;
    }
    /**
     * Set OrderID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderID
     * @return \StructType\AuthorizationRequestX
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderID)), __LINE__);
        }
        if (is_null($orderID) || (is_array($orderID) && empty($orderID))) {
            unset($this->OrderID);
        } else {
            $this->OrderID = $orderID;
        }
        return $this;
    }
    /**
     * Get OrderInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderInfo()
    {
        return isset($this->OrderInfo) ? $this->OrderInfo : null;
    }
    /**
     * Set OrderInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderInfo
     * @return \StructType\AuthorizationRequestX
     */
    public function setOrderInfo($orderInfo = null)
    {
        // validation for constraint: string
        if (!is_null($orderInfo) && !is_string($orderInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderInfo)), __LINE__);
        }
        if (is_null($orderInfo) || (is_array($orderInfo) && empty($orderInfo))) {
            unset($this->OrderInfo);
        } else {
            $this->OrderInfo = $orderInfo;
        }
        return $this;
    }
    /**
     * Get OrderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderName()
    {
        return isset($this->OrderName) ? $this->OrderName : null;
    }
    /**
     * Set OrderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderName
     * @return \StructType\AuthorizationRequestX
     */
    public function setOrderName($orderName = null)
    {
        // validation for constraint: string
        if (!is_null($orderName) && !is_string($orderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderName)), __LINE__);
        }
        if (is_null($orderName) || (is_array($orderName) && empty($orderName))) {
            unset($this->OrderName);
        } else {
            $this->OrderName = $orderName;
        }
        return $this;
    }
    /**
     * Get Recurrence value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RecurrenceInfoX|null
     */
    public function getRecurrence()
    {
        return isset($this->Recurrence) ? $this->Recurrence : null;
    }
    /**
     * Set Recurrence value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RecurrenceInfoX $recurrence
     * @return \StructType\AuthorizationRequestX
     */
    public function setRecurrence(\StructType\RecurrenceInfoX $recurrence = null)
    {
        if (is_null($recurrence) || (is_array($recurrence) && empty($recurrence))) {
            unset($this->Recurrence);
        } else {
            $this->Recurrence = $recurrence;
        }
        return $this;
    }
    /**
     * Get RecurrenceID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecurrenceID()
    {
        return isset($this->RecurrenceID) ? $this->RecurrenceID : null;
    }
    /**
     * Set RecurrenceID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recurrenceID
     * @return \StructType\AuthorizationRequestX
     */
    public function setRecurrenceID($recurrenceID = null)
    {
        // validation for constraint: string
        if (!is_null($recurrenceID) && !is_string($recurrenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recurrenceID)), __LINE__);
        }
        if (is_null($recurrenceID) || (is_array($recurrenceID) && empty($recurrenceID))) {
            unset($this->RecurrenceID);
        } else {
            $this->RecurrenceID = $recurrenceID;
        }
        return $this;
    }
    /**
     * Get TransactionHint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionHint()
    {
        return isset($this->TransactionHint) ? $this->TransactionHint : null;
    }
    /**
     * Set TransactionHint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionHint
     * @return \StructType\AuthorizationRequestX
     */
    public function setTransactionHint($transactionHint = null)
    {
        // validation for constraint: string
        if (!is_null($transactionHint) && !is_string($transactionHint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionHint)), __LINE__);
        }
        if (is_null($transactionHint) || (is_array($transactionHint) && empty($transactionHint))) {
            unset($this->TransactionHint);
        } else {
            $this->TransactionHint = $transactionHint;
        }
        return $this;
    }
    /**
     * Get VerifyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVerifyCode()
    {
        return isset($this->VerifyCode) ? $this->VerifyCode : null;
    }
    /**
     * Set VerifyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $verifyCode
     * @return \StructType\AuthorizationRequestX
     */
    public function setVerifyCode($verifyCode = null)
    {
        // validation for constraint: string
        if (!is_null($verifyCode) && !is_string($verifyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($verifyCode)), __LINE__);
        }
        if (is_null($verifyCode) || (is_array($verifyCode) && empty($verifyCode))) {
            unset($this->VerifyCode);
        } else {
            $this->VerifyCode = $verifyCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthorizationRequestX
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
