<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInputParameter ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfInputParameter
 * @subpackage Arrays
 */
class ArrayOfInputParameter extends AbstractStructArrayBase
{
    /**
     * The InputParameter
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InputParameter[]
     */
    public $InputParameter;
    /**
     * Constructor method for ArrayOfInputParameter
     * @uses ArrayOfInputParameter::setInputParameter()
     * @param \StructType\InputParameter[] $inputParameter
     */
    public function __construct(array $inputParameter = array())
    {
        $this
            ->setInputParameter($inputParameter);
    }
    /**
     * Get InputParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InputParameter[]|null
     */
    public function getInputParameter()
    {
        return isset($this->InputParameter) ? $this->InputParameter : null;
    }
    /**
     * Set InputParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InputParameter[] $inputParameter
     * @return \ArrayType\ArrayOfInputParameter
     */
    public function setInputParameter(array $inputParameter = array())
    {
        foreach ($inputParameter as $arrayOfInputParameterInputParameterItem) {
            // validation for constraint: itemType
            if (!$arrayOfInputParameterInputParameterItem instanceof \StructType\InputParameter) {
                throw new \InvalidArgumentException(sprintf('The InputParameter property can only contain items of \StructType\InputParameter, "%s" given', is_object($arrayOfInputParameterInputParameterItem) ? get_class($arrayOfInputParameterInputParameterItem) : gettype($arrayOfInputParameterInputParameterItem)), __LINE__);
            }
        }
        if (is_null($inputParameter) || (is_array($inputParameter) && empty($inputParameter))) {
            unset($this->InputParameter);
        } else {
            $this->InputParameter = $inputParameter;
        }
        return $this;
    }
    /**
     * Add item to InputParameter value
     * @throws \InvalidArgumentException
     * @param \StructType\InputParameter $item
     * @return \ArrayType\ArrayOfInputParameter
     */
    public function addToInputParameter(\StructType\InputParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InputParameter) {
            throw new \InvalidArgumentException(sprintf('The InputParameter property can only contain items of \StructType\InputParameter, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InputParameter[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InputParameter|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InputParameter|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InputParameter|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InputParameter|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InputParameter|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InputParameter
     */
    public function getAttributeName()
    {
        return 'InputParameter';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfInputParameter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
