<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionPayerX StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionPayerX
 * @subpackage Structs
 */
class TransactionPayerX extends AbstractStructBase
{
    /**
     * The AccountExpiry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountExpiry;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The AccountToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountToken;
    /**
     * The Authentication
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DataX
     */
    public $Authentication;
    /**
     * The CardBrand
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DataX
     */
    public $CardBrand;
    /**
     * The Instrument
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DataX
     */
    public $Instrument;
    /**
     * The ResponseParamters
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDataX
     */
    public $ResponseParamters;
    /**
     * Constructor method for TransactionPayerX
     * @uses TransactionPayerX::setAccountExpiry()
     * @uses TransactionPayerX::setAccountNumber()
     * @uses TransactionPayerX::setAccountToken()
     * @uses TransactionPayerX::setAuthentication()
     * @uses TransactionPayerX::setCardBrand()
     * @uses TransactionPayerX::setInstrument()
     * @uses TransactionPayerX::setResponseParamters()
     * @param string $accountExpiry
     * @param string $accountNumber
     * @param string $accountToken
     * @param \StructType\DataX $authentication
     * @param \StructType\DataX $cardBrand
     * @param \StructType\DataX $instrument
     * @param \ArrayType\ArrayOfDataX $responseParamters
     */
    public function __construct($accountExpiry = null, $accountNumber = null, $accountToken = null, \StructType\DataX $authentication = null, \StructType\DataX $cardBrand = null, \StructType\DataX $instrument = null, \ArrayType\ArrayOfDataX $responseParamters = null)
    {
        $this
            ->setAccountExpiry($accountExpiry)
            ->setAccountNumber($accountNumber)
            ->setAccountToken($accountToken)
            ->setAuthentication($authentication)
            ->setCardBrand($cardBrand)
            ->setInstrument($instrument)
            ->setResponseParamters($responseParamters);
    }
    /**
     * Get AccountExpiry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountExpiry()
    {
        return isset($this->AccountExpiry) ? $this->AccountExpiry : null;
    }
    /**
     * Set AccountExpiry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountExpiry
     * @return \StructType\TransactionPayerX
     */
    public function setAccountExpiry($accountExpiry = null)
    {
        // validation for constraint: string
        if (!is_null($accountExpiry) && !is_string($accountExpiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountExpiry)), __LINE__);
        }
        if (is_null($accountExpiry) || (is_array($accountExpiry) && empty($accountExpiry))) {
            unset($this->AccountExpiry);
        } else {
            $this->AccountExpiry = $accountExpiry;
        }
        return $this;
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \StructType\TransactionPayerX
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get AccountToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountToken()
    {
        return isset($this->AccountToken) ? $this->AccountToken : null;
    }
    /**
     * Set AccountToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountToken
     * @return \StructType\TransactionPayerX
     */
    public function setAccountToken($accountToken = null)
    {
        // validation for constraint: string
        if (!is_null($accountToken) && !is_string($accountToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountToken)), __LINE__);
        }
        if (is_null($accountToken) || (is_array($accountToken) && empty($accountToken))) {
            unset($this->AccountToken);
        } else {
            $this->AccountToken = $accountToken;
        }
        return $this;
    }
    /**
     * Get Authentication value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DataX|null
     */
    public function getAuthentication()
    {
        return isset($this->Authentication) ? $this->Authentication : null;
    }
    /**
     * Set Authentication value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DataX $authentication
     * @return \StructType\TransactionPayerX
     */
    public function setAuthentication(\StructType\DataX $authentication = null)
    {
        if (is_null($authentication) || (is_array($authentication) && empty($authentication))) {
            unset($this->Authentication);
        } else {
            $this->Authentication = $authentication;
        }
        return $this;
    }
    /**
     * Get CardBrand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DataX|null
     */
    public function getCardBrand()
    {
        return isset($this->CardBrand) ? $this->CardBrand : null;
    }
    /**
     * Set CardBrand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DataX $cardBrand
     * @return \StructType\TransactionPayerX
     */
    public function setCardBrand(\StructType\DataX $cardBrand = null)
    {
        if (is_null($cardBrand) || (is_array($cardBrand) && empty($cardBrand))) {
            unset($this->CardBrand);
        } else {
            $this->CardBrand = $cardBrand;
        }
        return $this;
    }
    /**
     * Get Instrument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DataX|null
     */
    public function getInstrument()
    {
        return isset($this->Instrument) ? $this->Instrument : null;
    }
    /**
     * Set Instrument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DataX $instrument
     * @return \StructType\TransactionPayerX
     */
    public function setInstrument(\StructType\DataX $instrument = null)
    {
        if (is_null($instrument) || (is_array($instrument) && empty($instrument))) {
            unset($this->Instrument);
        } else {
            $this->Instrument = $instrument;
        }
        return $this;
    }
    /**
     * Get ResponseParamters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDataX|null
     */
    public function getResponseParamters()
    {
        return isset($this->ResponseParamters) ? $this->ResponseParamters : null;
    }
    /**
     * Set ResponseParamters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDataX $responseParamters
     * @return \StructType\TransactionPayerX
     */
    public function setResponseParamters(\ArrayType\ArrayOfDataX $responseParamters = null)
    {
        if (is_null($responseParamters) || (is_array($responseParamters) && empty($responseParamters))) {
            unset($this->ResponseParamters);
        } else {
            $this->ResponseParamters = $responseParamters;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransactionPayerX
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
