<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefundResponseX StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RefundResponseX
 * @subpackage Structs
 */
class RefundResponseX extends TemplateResponseX
{
    /**
     * The ApprovalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApprovalCode;
    /**
     * The Balance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Balance;
    /**
     * Constructor method for RefundResponseX
     * @uses RefundResponseX::setApprovalCode()
     * @uses RefundResponseX::setBalance()
     * @param string $approvalCode
     * @param float $balance
     */
    public function __construct($approvalCode = null, $balance = null)
    {
        $this
            ->setApprovalCode($approvalCode)
            ->setBalance($balance);
    }
    /**
     * Get ApprovalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApprovalCode()
    {
        return isset($this->ApprovalCode) ? $this->ApprovalCode : null;
    }
    /**
     * Set ApprovalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $approvalCode
     * @return \StructType\RefundResponseX
     */
    public function setApprovalCode($approvalCode = null)
    {
        // validation for constraint: string
        if (!is_null($approvalCode) && !is_string($approvalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approvalCode)), __LINE__);
        }
        if (is_null($approvalCode) || (is_array($approvalCode) && empty($approvalCode))) {
            unset($this->ApprovalCode);
        } else {
            $this->ApprovalCode = $approvalCode;
        }
        return $this;
    }
    /**
     * Get Balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \StructType\RefundResponseX
     */
    public function setBalance($balance = null)
    {
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RefundResponseX
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
