<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecurrenceInfoX StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RecurrenceInfoX
 * @subpackage Structs
 */
class RecurrenceInfoX extends AbstractStructBase
{
    /**
     * The AccountExpiry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountExpiry;
    /**
     * The AutomatciPostBackUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AutomatciPostBackUrl;
    /**
     * The AutomaticRecurrenceAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AutomaticRecurrenceAmount;
    /**
     * The AutomaticRecurrenceFrequency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $AutomaticRecurrenceFrequency;
    /**
     * The AutomaticRecurrenceRetry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AutomaticRecurrenceRetry;
    /**
     * The MaximumRecurrenceAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaximumRecurrenceAmount;
    /**
     * The MaximumRecurrenceCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaximumRecurrenceCount;
    /**
     * The MinimumRecurrencePeriod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $MinimumRecurrencePeriod;
    /**
     * The RecurrenceEndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecurrenceEndDate;
    /**
     * The RecurrenceParameters
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDataX
     */
    public $RecurrenceParameters;
    /**
     * The RecurrenceStartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecurrenceStartDate;
    /**
     * The RecurrenceType
     * @var string
     */
    public $RecurrenceType;
    /**
     * Constructor method for RecurrenceInfoX
     * @uses RecurrenceInfoX::setAccountExpiry()
     * @uses RecurrenceInfoX::setAutomatciPostBackUrl()
     * @uses RecurrenceInfoX::setAutomaticRecurrenceAmount()
     * @uses RecurrenceInfoX::setAutomaticRecurrenceFrequency()
     * @uses RecurrenceInfoX::setAutomaticRecurrenceRetry()
     * @uses RecurrenceInfoX::setMaximumRecurrenceAmount()
     * @uses RecurrenceInfoX::setMaximumRecurrenceCount()
     * @uses RecurrenceInfoX::setMinimumRecurrencePeriod()
     * @uses RecurrenceInfoX::setRecurrenceEndDate()
     * @uses RecurrenceInfoX::setRecurrenceParameters()
     * @uses RecurrenceInfoX::setRecurrenceStartDate()
     * @uses RecurrenceInfoX::setRecurrenceType()
     * @param string $accountExpiry
     * @param string $automatciPostBackUrl
     * @param float $automaticRecurrenceAmount
     * @param string $automaticRecurrenceFrequency
     * @param bool $automaticRecurrenceRetry
     * @param float $maximumRecurrenceAmount
     * @param int $maximumRecurrenceCount
     * @param string $minimumRecurrencePeriod
     * @param string $recurrenceEndDate
     * @param \ArrayType\ArrayOfDataX $recurrenceParameters
     * @param string $recurrenceStartDate
     * @param string $recurrenceType
     */
    public function __construct($accountExpiry = null, $automatciPostBackUrl = null, $automaticRecurrenceAmount = null, $automaticRecurrenceFrequency = null, $automaticRecurrenceRetry = null, $maximumRecurrenceAmount = null, $maximumRecurrenceCount = null, $minimumRecurrencePeriod = null, $recurrenceEndDate = null, \ArrayType\ArrayOfDataX $recurrenceParameters = null, $recurrenceStartDate = null, $recurrenceType = null)
    {
        $this
            ->setAccountExpiry($accountExpiry)
            ->setAutomatciPostBackUrl($automatciPostBackUrl)
            ->setAutomaticRecurrenceAmount($automaticRecurrenceAmount)
            ->setAutomaticRecurrenceFrequency($automaticRecurrenceFrequency)
            ->setAutomaticRecurrenceRetry($automaticRecurrenceRetry)
            ->setMaximumRecurrenceAmount($maximumRecurrenceAmount)
            ->setMaximumRecurrenceCount($maximumRecurrenceCount)
            ->setMinimumRecurrencePeriod($minimumRecurrencePeriod)
            ->setRecurrenceEndDate($recurrenceEndDate)
            ->setRecurrenceParameters($recurrenceParameters)
            ->setRecurrenceStartDate($recurrenceStartDate)
            ->setRecurrenceType($recurrenceType);
    }
    /**
     * Get AccountExpiry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountExpiry()
    {
        return isset($this->AccountExpiry) ? $this->AccountExpiry : null;
    }
    /**
     * Set AccountExpiry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountExpiry
     * @return \StructType\RecurrenceInfoX
     */
    public function setAccountExpiry($accountExpiry = null)
    {
        // validation for constraint: string
        if (!is_null($accountExpiry) && !is_string($accountExpiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountExpiry)), __LINE__);
        }
        if (is_null($accountExpiry) || (is_array($accountExpiry) && empty($accountExpiry))) {
            unset($this->AccountExpiry);
        } else {
            $this->AccountExpiry = $accountExpiry;
        }
        return $this;
    }
    /**
     * Get AutomatciPostBackUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAutomatciPostBackUrl()
    {
        return isset($this->AutomatciPostBackUrl) ? $this->AutomatciPostBackUrl : null;
    }
    /**
     * Set AutomatciPostBackUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $automatciPostBackUrl
     * @return \StructType\RecurrenceInfoX
     */
    public function setAutomatciPostBackUrl($automatciPostBackUrl = null)
    {
        // validation for constraint: string
        if (!is_null($automatciPostBackUrl) && !is_string($automatciPostBackUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($automatciPostBackUrl)), __LINE__);
        }
        if (is_null($automatciPostBackUrl) || (is_array($automatciPostBackUrl) && empty($automatciPostBackUrl))) {
            unset($this->AutomatciPostBackUrl);
        } else {
            $this->AutomatciPostBackUrl = $automatciPostBackUrl;
        }
        return $this;
    }
    /**
     * Get AutomaticRecurrenceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAutomaticRecurrenceAmount()
    {
        return isset($this->AutomaticRecurrenceAmount) ? $this->AutomaticRecurrenceAmount : null;
    }
    /**
     * Set AutomaticRecurrenceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $automaticRecurrenceAmount
     * @return \StructType\RecurrenceInfoX
     */
    public function setAutomaticRecurrenceAmount($automaticRecurrenceAmount = null)
    {
        if (is_null($automaticRecurrenceAmount) || (is_array($automaticRecurrenceAmount) && empty($automaticRecurrenceAmount))) {
            unset($this->AutomaticRecurrenceAmount);
        } else {
            $this->AutomaticRecurrenceAmount = $automaticRecurrenceAmount;
        }
        return $this;
    }
    /**
     * Get AutomaticRecurrenceFrequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAutomaticRecurrenceFrequency()
    {
        return isset($this->AutomaticRecurrenceFrequency) ? $this->AutomaticRecurrenceFrequency : null;
    }
    /**
     * Set AutomaticRecurrenceFrequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $automaticRecurrenceFrequency
     * @return \StructType\RecurrenceInfoX
     */
    public function setAutomaticRecurrenceFrequency($automaticRecurrenceFrequency = null)
    {
        // validation for constraint: maxInclusive
        if ($automaticRecurrenceFrequency > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 0, "%s" given', $automaticRecurrenceFrequency), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($automaticRecurrenceFrequency < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $automaticRecurrenceFrequency), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($automaticRecurrenceFrequency) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $automaticRecurrenceFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?", "%s" given', var_export($automaticRecurrenceFrequency, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($automaticRecurrenceFrequency) && !is_string($automaticRecurrenceFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($automaticRecurrenceFrequency)), __LINE__);
        }
        if (is_null($automaticRecurrenceFrequency) || (is_array($automaticRecurrenceFrequency) && empty($automaticRecurrenceFrequency))) {
            unset($this->AutomaticRecurrenceFrequency);
        } else {
            $this->AutomaticRecurrenceFrequency = $automaticRecurrenceFrequency;
        }
        return $this;
    }
    /**
     * Get AutomaticRecurrenceRetry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAutomaticRecurrenceRetry()
    {
        return isset($this->AutomaticRecurrenceRetry) ? $this->AutomaticRecurrenceRetry : null;
    }
    /**
     * Set AutomaticRecurrenceRetry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $automaticRecurrenceRetry
     * @return \StructType\RecurrenceInfoX
     */
    public function setAutomaticRecurrenceRetry($automaticRecurrenceRetry = null)
    {
        // validation for constraint: boolean
        if (!is_null($automaticRecurrenceRetry) && !is_bool($automaticRecurrenceRetry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($automaticRecurrenceRetry)), __LINE__);
        }
        if (is_null($automaticRecurrenceRetry) || (is_array($automaticRecurrenceRetry) && empty($automaticRecurrenceRetry))) {
            unset($this->AutomaticRecurrenceRetry);
        } else {
            $this->AutomaticRecurrenceRetry = $automaticRecurrenceRetry;
        }
        return $this;
    }
    /**
     * Get MaximumRecurrenceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaximumRecurrenceAmount()
    {
        return isset($this->MaximumRecurrenceAmount) ? $this->MaximumRecurrenceAmount : null;
    }
    /**
     * Set MaximumRecurrenceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maximumRecurrenceAmount
     * @return \StructType\RecurrenceInfoX
     */
    public function setMaximumRecurrenceAmount($maximumRecurrenceAmount = null)
    {
        if (is_null($maximumRecurrenceAmount) || (is_array($maximumRecurrenceAmount) && empty($maximumRecurrenceAmount))) {
            unset($this->MaximumRecurrenceAmount);
        } else {
            $this->MaximumRecurrenceAmount = $maximumRecurrenceAmount;
        }
        return $this;
    }
    /**
     * Get MaximumRecurrenceCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaximumRecurrenceCount()
    {
        return isset($this->MaximumRecurrenceCount) ? $this->MaximumRecurrenceCount : null;
    }
    /**
     * Set MaximumRecurrenceCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maximumRecurrenceCount
     * @return \StructType\RecurrenceInfoX
     */
    public function setMaximumRecurrenceCount($maximumRecurrenceCount = null)
    {
        // validation for constraint: int
        if (!is_null($maximumRecurrenceCount) && !is_numeric($maximumRecurrenceCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumRecurrenceCount)), __LINE__);
        }
        if (is_null($maximumRecurrenceCount) || (is_array($maximumRecurrenceCount) && empty($maximumRecurrenceCount))) {
            unset($this->MaximumRecurrenceCount);
        } else {
            $this->MaximumRecurrenceCount = $maximumRecurrenceCount;
        }
        return $this;
    }
    /**
     * Get MinimumRecurrencePeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMinimumRecurrencePeriod()
    {
        return isset($this->MinimumRecurrencePeriod) ? $this->MinimumRecurrencePeriod : null;
    }
    /**
     * Set MinimumRecurrencePeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $minimumRecurrencePeriod
     * @return \StructType\RecurrenceInfoX
     */
    public function setMinimumRecurrencePeriod($minimumRecurrencePeriod = null)
    {
        // validation for constraint: maxInclusive
        if ($minimumRecurrencePeriod > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 0, "%s" given', $minimumRecurrencePeriod), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($minimumRecurrencePeriod < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $minimumRecurrencePeriod), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($minimumRecurrencePeriod) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $minimumRecurrencePeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?", "%s" given', var_export($minimumRecurrencePeriod, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($minimumRecurrencePeriod) && !is_string($minimumRecurrencePeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minimumRecurrencePeriod)), __LINE__);
        }
        if (is_null($minimumRecurrencePeriod) || (is_array($minimumRecurrencePeriod) && empty($minimumRecurrencePeriod))) {
            unset($this->MinimumRecurrencePeriod);
        } else {
            $this->MinimumRecurrencePeriod = $minimumRecurrencePeriod;
        }
        return $this;
    }
    /**
     * Get RecurrenceEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecurrenceEndDate()
    {
        return isset($this->RecurrenceEndDate) ? $this->RecurrenceEndDate : null;
    }
    /**
     * Set RecurrenceEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recurrenceEndDate
     * @return \StructType\RecurrenceInfoX
     */
    public function setRecurrenceEndDate($recurrenceEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($recurrenceEndDate) && !is_string($recurrenceEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recurrenceEndDate)), __LINE__);
        }
        if (is_null($recurrenceEndDate) || (is_array($recurrenceEndDate) && empty($recurrenceEndDate))) {
            unset($this->RecurrenceEndDate);
        } else {
            $this->RecurrenceEndDate = $recurrenceEndDate;
        }
        return $this;
    }
    /**
     * Get RecurrenceParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDataX|null
     */
    public function getRecurrenceParameters()
    {
        return isset($this->RecurrenceParameters) ? $this->RecurrenceParameters : null;
    }
    /**
     * Set RecurrenceParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDataX $recurrenceParameters
     * @return \StructType\RecurrenceInfoX
     */
    public function setRecurrenceParameters(\ArrayType\ArrayOfDataX $recurrenceParameters = null)
    {
        if (is_null($recurrenceParameters) || (is_array($recurrenceParameters) && empty($recurrenceParameters))) {
            unset($this->RecurrenceParameters);
        } else {
            $this->RecurrenceParameters = $recurrenceParameters;
        }
        return $this;
    }
    /**
     * Get RecurrenceStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecurrenceStartDate()
    {
        return isset($this->RecurrenceStartDate) ? $this->RecurrenceStartDate : null;
    }
    /**
     * Set RecurrenceStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recurrenceStartDate
     * @return \StructType\RecurrenceInfoX
     */
    public function setRecurrenceStartDate($recurrenceStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($recurrenceStartDate) && !is_string($recurrenceStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recurrenceStartDate)), __LINE__);
        }
        if (is_null($recurrenceStartDate) || (is_array($recurrenceStartDate) && empty($recurrenceStartDate))) {
            unset($this->RecurrenceStartDate);
        } else {
            $this->RecurrenceStartDate = $recurrenceStartDate;
        }
        return $this;
    }
    /**
     * Get RecurrenceType value
     * @return string|null
     */
    public function getRecurrenceType()
    {
        return $this->RecurrenceType;
    }
    /**
     * Set RecurrenceType value
     * @uses \EnumType\RecurrenceType::valueIsValid()
     * @uses \EnumType\RecurrenceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recurrenceType
     * @return \StructType\RecurrenceInfoX
     */
    public function setRecurrenceType($recurrenceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RecurrenceType::valueIsValid($recurrenceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $recurrenceType, implode(', ', \EnumType\RecurrenceType::getValidValues())), __LINE__);
        }
        $this->RecurrenceType = $recurrenceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecurrenceInfoX
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
