<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmvRequestInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EmvRequestInfo
 * @subpackage Structs
 */
class EmvRequestInfo extends AbstractStructBase
{
    /**
     * The ApplicationIdentifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationIdentifier;
    /**
     * The ApplicationInterchangeProfile
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationInterchangeProfile;
    /**
     * The ApplicationTransactionCounter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationTransactionCounter;
    /**
     * The ApplicationUsageControl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationUsageControl;
    /**
     * The CardSequenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardSequenceNumber;
    /**
     * The Cryptogram
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cryptogram;
    /**
     * The CryptogramInformationData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CryptogramInformationData;
    /**
     * The CvmResults
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CvmResults;
    /**
     * The InterfaceDeviceSerialNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InterfaceDeviceSerialNumber;
    /**
     * The IssuerActionCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EmvIssuerActionCode
     */
    public $IssuerActionCode;
    /**
     * The IssuerApplicationData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssuerApplicationData;
    /**
     * The PosGeographicData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PosGeographicData;
    /**
     * The SponserBank
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SponserBank;
    /**
     * The TerminalApplicationVersionNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TerminalApplicationVersionNumber;
    /**
     * The TerminalCapabilities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TerminalCapabilities;
    /**
     * The TerminalCountryCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TerminalCountryCode;
    /**
     * The TerminalType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TerminalType;
    /**
     * The TerminalVerificationResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TerminalVerificationResult;
    /**
     * The Track2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Track2;
    /**
     * The TransactionCategoryCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionCategoryCode;
    /**
     * The TransactionDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionSequenceCounter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionSequenceCounter;
    /**
     * The UnpredictableNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnpredictableNumber;
    /**
     * Constructor method for EmvRequestInfo
     * @uses EmvRequestInfo::setApplicationIdentifier()
     * @uses EmvRequestInfo::setApplicationInterchangeProfile()
     * @uses EmvRequestInfo::setApplicationTransactionCounter()
     * @uses EmvRequestInfo::setApplicationUsageControl()
     * @uses EmvRequestInfo::setCardSequenceNumber()
     * @uses EmvRequestInfo::setCryptogram()
     * @uses EmvRequestInfo::setCryptogramInformationData()
     * @uses EmvRequestInfo::setCvmResults()
     * @uses EmvRequestInfo::setInterfaceDeviceSerialNumber()
     * @uses EmvRequestInfo::setIssuerActionCode()
     * @uses EmvRequestInfo::setIssuerApplicationData()
     * @uses EmvRequestInfo::setPosGeographicData()
     * @uses EmvRequestInfo::setSponserBank()
     * @uses EmvRequestInfo::setTerminalApplicationVersionNumber()
     * @uses EmvRequestInfo::setTerminalCapabilities()
     * @uses EmvRequestInfo::setTerminalCountryCode()
     * @uses EmvRequestInfo::setTerminalType()
     * @uses EmvRequestInfo::setTerminalVerificationResult()
     * @uses EmvRequestInfo::setTrack2()
     * @uses EmvRequestInfo::setTransactionCategoryCode()
     * @uses EmvRequestInfo::setTransactionDate()
     * @uses EmvRequestInfo::setTransactionSequenceCounter()
     * @uses EmvRequestInfo::setUnpredictableNumber()
     * @param string $applicationIdentifier
     * @param string $applicationInterchangeProfile
     * @param string $applicationTransactionCounter
     * @param string $applicationUsageControl
     * @param string $cardSequenceNumber
     * @param string $cryptogram
     * @param string $cryptogramInformationData
     * @param string $cvmResults
     * @param string $interfaceDeviceSerialNumber
     * @param \StructType\EmvIssuerActionCode $issuerActionCode
     * @param string $issuerApplicationData
     * @param string $posGeographicData
     * @param string $sponserBank
     * @param string $terminalApplicationVersionNumber
     * @param string $terminalCapabilities
     * @param string $terminalCountryCode
     * @param string $terminalType
     * @param string $terminalVerificationResult
     * @param string $track2
     * @param string $transactionCategoryCode
     * @param string $transactionDate
     * @param string $transactionSequenceCounter
     * @param string $unpredictableNumber
     */
    public function __construct($applicationIdentifier = null, $applicationInterchangeProfile = null, $applicationTransactionCounter = null, $applicationUsageControl = null, $cardSequenceNumber = null, $cryptogram = null, $cryptogramInformationData = null, $cvmResults = null, $interfaceDeviceSerialNumber = null, \StructType\EmvIssuerActionCode $issuerActionCode = null, $issuerApplicationData = null, $posGeographicData = null, $sponserBank = null, $terminalApplicationVersionNumber = null, $terminalCapabilities = null, $terminalCountryCode = null, $terminalType = null, $terminalVerificationResult = null, $track2 = null, $transactionCategoryCode = null, $transactionDate = null, $transactionSequenceCounter = null, $unpredictableNumber = null)
    {
        $this
            ->setApplicationIdentifier($applicationIdentifier)
            ->setApplicationInterchangeProfile($applicationInterchangeProfile)
            ->setApplicationTransactionCounter($applicationTransactionCounter)
            ->setApplicationUsageControl($applicationUsageControl)
            ->setCardSequenceNumber($cardSequenceNumber)
            ->setCryptogram($cryptogram)
            ->setCryptogramInformationData($cryptogramInformationData)
            ->setCvmResults($cvmResults)
            ->setInterfaceDeviceSerialNumber($interfaceDeviceSerialNumber)
            ->setIssuerActionCode($issuerActionCode)
            ->setIssuerApplicationData($issuerApplicationData)
            ->setPosGeographicData($posGeographicData)
            ->setSponserBank($sponserBank)
            ->setTerminalApplicationVersionNumber($terminalApplicationVersionNumber)
            ->setTerminalCapabilities($terminalCapabilities)
            ->setTerminalCountryCode($terminalCountryCode)
            ->setTerminalType($terminalType)
            ->setTerminalVerificationResult($terminalVerificationResult)
            ->setTrack2($track2)
            ->setTransactionCategoryCode($transactionCategoryCode)
            ->setTransactionDate($transactionDate)
            ->setTransactionSequenceCounter($transactionSequenceCounter)
            ->setUnpredictableNumber($unpredictableNumber);
    }
    /**
     * Get ApplicationIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationIdentifier()
    {
        return isset($this->ApplicationIdentifier) ? $this->ApplicationIdentifier : null;
    }
    /**
     * Set ApplicationIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationIdentifier
     * @return \StructType\EmvRequestInfo
     */
    public function setApplicationIdentifier($applicationIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($applicationIdentifier) && !is_string($applicationIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationIdentifier)), __LINE__);
        }
        if (is_null($applicationIdentifier) || (is_array($applicationIdentifier) && empty($applicationIdentifier))) {
            unset($this->ApplicationIdentifier);
        } else {
            $this->ApplicationIdentifier = $applicationIdentifier;
        }
        return $this;
    }
    /**
     * Get ApplicationInterchangeProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationInterchangeProfile()
    {
        return isset($this->ApplicationInterchangeProfile) ? $this->ApplicationInterchangeProfile : null;
    }
    /**
     * Set ApplicationInterchangeProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationInterchangeProfile
     * @return \StructType\EmvRequestInfo
     */
    public function setApplicationInterchangeProfile($applicationInterchangeProfile = null)
    {
        // validation for constraint: string
        if (!is_null($applicationInterchangeProfile) && !is_string($applicationInterchangeProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationInterchangeProfile)), __LINE__);
        }
        if (is_null($applicationInterchangeProfile) || (is_array($applicationInterchangeProfile) && empty($applicationInterchangeProfile))) {
            unset($this->ApplicationInterchangeProfile);
        } else {
            $this->ApplicationInterchangeProfile = $applicationInterchangeProfile;
        }
        return $this;
    }
    /**
     * Get ApplicationTransactionCounter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationTransactionCounter()
    {
        return isset($this->ApplicationTransactionCounter) ? $this->ApplicationTransactionCounter : null;
    }
    /**
     * Set ApplicationTransactionCounter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationTransactionCounter
     * @return \StructType\EmvRequestInfo
     */
    public function setApplicationTransactionCounter($applicationTransactionCounter = null)
    {
        // validation for constraint: string
        if (!is_null($applicationTransactionCounter) && !is_string($applicationTransactionCounter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationTransactionCounter)), __LINE__);
        }
        if (is_null($applicationTransactionCounter) || (is_array($applicationTransactionCounter) && empty($applicationTransactionCounter))) {
            unset($this->ApplicationTransactionCounter);
        } else {
            $this->ApplicationTransactionCounter = $applicationTransactionCounter;
        }
        return $this;
    }
    /**
     * Get ApplicationUsageControl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationUsageControl()
    {
        return isset($this->ApplicationUsageControl) ? $this->ApplicationUsageControl : null;
    }
    /**
     * Set ApplicationUsageControl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationUsageControl
     * @return \StructType\EmvRequestInfo
     */
    public function setApplicationUsageControl($applicationUsageControl = null)
    {
        // validation for constraint: string
        if (!is_null($applicationUsageControl) && !is_string($applicationUsageControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationUsageControl)), __LINE__);
        }
        if (is_null($applicationUsageControl) || (is_array($applicationUsageControl) && empty($applicationUsageControl))) {
            unset($this->ApplicationUsageControl);
        } else {
            $this->ApplicationUsageControl = $applicationUsageControl;
        }
        return $this;
    }
    /**
     * Get CardSequenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardSequenceNumber()
    {
        return isset($this->CardSequenceNumber) ? $this->CardSequenceNumber : null;
    }
    /**
     * Set CardSequenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardSequenceNumber
     * @return \StructType\EmvRequestInfo
     */
    public function setCardSequenceNumber($cardSequenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardSequenceNumber) && !is_string($cardSequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardSequenceNumber)), __LINE__);
        }
        if (is_null($cardSequenceNumber) || (is_array($cardSequenceNumber) && empty($cardSequenceNumber))) {
            unset($this->CardSequenceNumber);
        } else {
            $this->CardSequenceNumber = $cardSequenceNumber;
        }
        return $this;
    }
    /**
     * Get Cryptogram value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCryptogram()
    {
        return isset($this->Cryptogram) ? $this->Cryptogram : null;
    }
    /**
     * Set Cryptogram value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cryptogram
     * @return \StructType\EmvRequestInfo
     */
    public function setCryptogram($cryptogram = null)
    {
        // validation for constraint: string
        if (!is_null($cryptogram) && !is_string($cryptogram)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cryptogram)), __LINE__);
        }
        if (is_null($cryptogram) || (is_array($cryptogram) && empty($cryptogram))) {
            unset($this->Cryptogram);
        } else {
            $this->Cryptogram = $cryptogram;
        }
        return $this;
    }
    /**
     * Get CryptogramInformationData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCryptogramInformationData()
    {
        return isset($this->CryptogramInformationData) ? $this->CryptogramInformationData : null;
    }
    /**
     * Set CryptogramInformationData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cryptogramInformationData
     * @return \StructType\EmvRequestInfo
     */
    public function setCryptogramInformationData($cryptogramInformationData = null)
    {
        // validation for constraint: string
        if (!is_null($cryptogramInformationData) && !is_string($cryptogramInformationData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cryptogramInformationData)), __LINE__);
        }
        if (is_null($cryptogramInformationData) || (is_array($cryptogramInformationData) && empty($cryptogramInformationData))) {
            unset($this->CryptogramInformationData);
        } else {
            $this->CryptogramInformationData = $cryptogramInformationData;
        }
        return $this;
    }
    /**
     * Get CvmResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCvmResults()
    {
        return isset($this->CvmResults) ? $this->CvmResults : null;
    }
    /**
     * Set CvmResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cvmResults
     * @return \StructType\EmvRequestInfo
     */
    public function setCvmResults($cvmResults = null)
    {
        // validation for constraint: string
        if (!is_null($cvmResults) && !is_string($cvmResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cvmResults)), __LINE__);
        }
        if (is_null($cvmResults) || (is_array($cvmResults) && empty($cvmResults))) {
            unset($this->CvmResults);
        } else {
            $this->CvmResults = $cvmResults;
        }
        return $this;
    }
    /**
     * Get InterfaceDeviceSerialNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInterfaceDeviceSerialNumber()
    {
        return isset($this->InterfaceDeviceSerialNumber) ? $this->InterfaceDeviceSerialNumber : null;
    }
    /**
     * Set InterfaceDeviceSerialNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $interfaceDeviceSerialNumber
     * @return \StructType\EmvRequestInfo
     */
    public function setInterfaceDeviceSerialNumber($interfaceDeviceSerialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($interfaceDeviceSerialNumber) && !is_string($interfaceDeviceSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($interfaceDeviceSerialNumber)), __LINE__);
        }
        if (is_null($interfaceDeviceSerialNumber) || (is_array($interfaceDeviceSerialNumber) && empty($interfaceDeviceSerialNumber))) {
            unset($this->InterfaceDeviceSerialNumber);
        } else {
            $this->InterfaceDeviceSerialNumber = $interfaceDeviceSerialNumber;
        }
        return $this;
    }
    /**
     * Get IssuerActionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EmvIssuerActionCode|null
     */
    public function getIssuerActionCode()
    {
        return isset($this->IssuerActionCode) ? $this->IssuerActionCode : null;
    }
    /**
     * Set IssuerActionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\EmvIssuerActionCode $issuerActionCode
     * @return \StructType\EmvRequestInfo
     */
    public function setIssuerActionCode(\StructType\EmvIssuerActionCode $issuerActionCode = null)
    {
        if (is_null($issuerActionCode) || (is_array($issuerActionCode) && empty($issuerActionCode))) {
            unset($this->IssuerActionCode);
        } else {
            $this->IssuerActionCode = $issuerActionCode;
        }
        return $this;
    }
    /**
     * Get IssuerApplicationData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssuerApplicationData()
    {
        return isset($this->IssuerApplicationData) ? $this->IssuerApplicationData : null;
    }
    /**
     * Set IssuerApplicationData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issuerApplicationData
     * @return \StructType\EmvRequestInfo
     */
    public function setIssuerApplicationData($issuerApplicationData = null)
    {
        // validation for constraint: string
        if (!is_null($issuerApplicationData) && !is_string($issuerApplicationData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuerApplicationData)), __LINE__);
        }
        if (is_null($issuerApplicationData) || (is_array($issuerApplicationData) && empty($issuerApplicationData))) {
            unset($this->IssuerApplicationData);
        } else {
            $this->IssuerApplicationData = $issuerApplicationData;
        }
        return $this;
    }
    /**
     * Get PosGeographicData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPosGeographicData()
    {
        return isset($this->PosGeographicData) ? $this->PosGeographicData : null;
    }
    /**
     * Set PosGeographicData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $posGeographicData
     * @return \StructType\EmvRequestInfo
     */
    public function setPosGeographicData($posGeographicData = null)
    {
        // validation for constraint: string
        if (!is_null($posGeographicData) && !is_string($posGeographicData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($posGeographicData)), __LINE__);
        }
        if (is_null($posGeographicData) || (is_array($posGeographicData) && empty($posGeographicData))) {
            unset($this->PosGeographicData);
        } else {
            $this->PosGeographicData = $posGeographicData;
        }
        return $this;
    }
    /**
     * Get SponserBank value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSponserBank()
    {
        return isset($this->SponserBank) ? $this->SponserBank : null;
    }
    /**
     * Set SponserBank value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sponserBank
     * @return \StructType\EmvRequestInfo
     */
    public function setSponserBank($sponserBank = null)
    {
        // validation for constraint: string
        if (!is_null($sponserBank) && !is_string($sponserBank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sponserBank)), __LINE__);
        }
        if (is_null($sponserBank) || (is_array($sponserBank) && empty($sponserBank))) {
            unset($this->SponserBank);
        } else {
            $this->SponserBank = $sponserBank;
        }
        return $this;
    }
    /**
     * Get TerminalApplicationVersionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminalApplicationVersionNumber()
    {
        return isset($this->TerminalApplicationVersionNumber) ? $this->TerminalApplicationVersionNumber : null;
    }
    /**
     * Set TerminalApplicationVersionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminalApplicationVersionNumber
     * @return \StructType\EmvRequestInfo
     */
    public function setTerminalApplicationVersionNumber($terminalApplicationVersionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($terminalApplicationVersionNumber) && !is_string($terminalApplicationVersionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminalApplicationVersionNumber)), __LINE__);
        }
        if (is_null($terminalApplicationVersionNumber) || (is_array($terminalApplicationVersionNumber) && empty($terminalApplicationVersionNumber))) {
            unset($this->TerminalApplicationVersionNumber);
        } else {
            $this->TerminalApplicationVersionNumber = $terminalApplicationVersionNumber;
        }
        return $this;
    }
    /**
     * Get TerminalCapabilities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminalCapabilities()
    {
        return isset($this->TerminalCapabilities) ? $this->TerminalCapabilities : null;
    }
    /**
     * Set TerminalCapabilities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminalCapabilities
     * @return \StructType\EmvRequestInfo
     */
    public function setTerminalCapabilities($terminalCapabilities = null)
    {
        // validation for constraint: string
        if (!is_null($terminalCapabilities) && !is_string($terminalCapabilities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminalCapabilities)), __LINE__);
        }
        if (is_null($terminalCapabilities) || (is_array($terminalCapabilities) && empty($terminalCapabilities))) {
            unset($this->TerminalCapabilities);
        } else {
            $this->TerminalCapabilities = $terminalCapabilities;
        }
        return $this;
    }
    /**
     * Get TerminalCountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminalCountryCode()
    {
        return isset($this->TerminalCountryCode) ? $this->TerminalCountryCode : null;
    }
    /**
     * Set TerminalCountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminalCountryCode
     * @return \StructType\EmvRequestInfo
     */
    public function setTerminalCountryCode($terminalCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($terminalCountryCode) && !is_string($terminalCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminalCountryCode)), __LINE__);
        }
        if (is_null($terminalCountryCode) || (is_array($terminalCountryCode) && empty($terminalCountryCode))) {
            unset($this->TerminalCountryCode);
        } else {
            $this->TerminalCountryCode = $terminalCountryCode;
        }
        return $this;
    }
    /**
     * Get TerminalType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminalType()
    {
        return isset($this->TerminalType) ? $this->TerminalType : null;
    }
    /**
     * Set TerminalType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminalType
     * @return \StructType\EmvRequestInfo
     */
    public function setTerminalType($terminalType = null)
    {
        // validation for constraint: string
        if (!is_null($terminalType) && !is_string($terminalType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminalType)), __LINE__);
        }
        if (is_null($terminalType) || (is_array($terminalType) && empty($terminalType))) {
            unset($this->TerminalType);
        } else {
            $this->TerminalType = $terminalType;
        }
        return $this;
    }
    /**
     * Get TerminalVerificationResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminalVerificationResult()
    {
        return isset($this->TerminalVerificationResult) ? $this->TerminalVerificationResult : null;
    }
    /**
     * Set TerminalVerificationResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminalVerificationResult
     * @return \StructType\EmvRequestInfo
     */
    public function setTerminalVerificationResult($terminalVerificationResult = null)
    {
        // validation for constraint: string
        if (!is_null($terminalVerificationResult) && !is_string($terminalVerificationResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminalVerificationResult)), __LINE__);
        }
        if (is_null($terminalVerificationResult) || (is_array($terminalVerificationResult) && empty($terminalVerificationResult))) {
            unset($this->TerminalVerificationResult);
        } else {
            $this->TerminalVerificationResult = $terminalVerificationResult;
        }
        return $this;
    }
    /**
     * Get Track2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrack2()
    {
        return isset($this->Track2) ? $this->Track2 : null;
    }
    /**
     * Set Track2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $track2
     * @return \StructType\EmvRequestInfo
     */
    public function setTrack2($track2 = null)
    {
        // validation for constraint: string
        if (!is_null($track2) && !is_string($track2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($track2)), __LINE__);
        }
        if (is_null($track2) || (is_array($track2) && empty($track2))) {
            unset($this->Track2);
        } else {
            $this->Track2 = $track2;
        }
        return $this;
    }
    /**
     * Get TransactionCategoryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionCategoryCode()
    {
        return isset($this->TransactionCategoryCode) ? $this->TransactionCategoryCode : null;
    }
    /**
     * Set TransactionCategoryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionCategoryCode
     * @return \StructType\EmvRequestInfo
     */
    public function setTransactionCategoryCode($transactionCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionCategoryCode) && !is_string($transactionCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionCategoryCode)), __LINE__);
        }
        if (is_null($transactionCategoryCode) || (is_array($transactionCategoryCode) && empty($transactionCategoryCode))) {
            unset($this->TransactionCategoryCode);
        } else {
            $this->TransactionCategoryCode = $transactionCategoryCode;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDate
     * @return \StructType\EmvRequestInfo
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDate)), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get TransactionSequenceCounter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionSequenceCounter()
    {
        return isset($this->TransactionSequenceCounter) ? $this->TransactionSequenceCounter : null;
    }
    /**
     * Set TransactionSequenceCounter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionSequenceCounter
     * @return \StructType\EmvRequestInfo
     */
    public function setTransactionSequenceCounter($transactionSequenceCounter = null)
    {
        // validation for constraint: string
        if (!is_null($transactionSequenceCounter) && !is_string($transactionSequenceCounter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionSequenceCounter)), __LINE__);
        }
        if (is_null($transactionSequenceCounter) || (is_array($transactionSequenceCounter) && empty($transactionSequenceCounter))) {
            unset($this->TransactionSequenceCounter);
        } else {
            $this->TransactionSequenceCounter = $transactionSequenceCounter;
        }
        return $this;
    }
    /**
     * Get UnpredictableNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnpredictableNumber()
    {
        return isset($this->UnpredictableNumber) ? $this->UnpredictableNumber : null;
    }
    /**
     * Set UnpredictableNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unpredictableNumber
     * @return \StructType\EmvRequestInfo
     */
    public function setUnpredictableNumber($unpredictableNumber = null)
    {
        // validation for constraint: string
        if (!is_null($unpredictableNumber) && !is_string($unpredictableNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unpredictableNumber)), __LINE__);
        }
        if (is_null($unpredictableNumber) || (is_array($unpredictableNumber) && empty($unpredictableNumber))) {
            unset($this->UnpredictableNumber);
        } else {
            $this->UnpredictableNumber = $unpredictableNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmvRequestInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
