<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmvAuthorizationRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EmvAuthorizationRequest
 * @subpackage Structs
 */
class EmvAuthorizationRequest extends TemplateRequestX
{
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The CardTrackData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardTrackData;
    /**
     * The Channel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Channel;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The CurrencyISO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CurrencyISO;
    /**
     * The EmvRequest
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EmvRequestInfo
     */
    public $EmvRequest;
    /**
     * The ExpiryDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpiryDate;
    /**
     * The MerchantType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MerchantType;
    /**
     * The OfflineAuthorization
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OfflineAuthorization;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderID;
    /**
     * The OrderInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderInfo;
    /**
     * The OrderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderName;
    /**
     * The PinBlock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PinBlock;
    /**
     * The TransactionCertificate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionCertificate;
    /**
     * The TransactionHint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionHint;
    /**
     * The VerifyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VerifyCode;
    /**
     * Constructor method for EmvAuthorizationRequest
     * @uses EmvAuthorizationRequest::setAccountNumber()
     * @uses EmvAuthorizationRequest::setAmount()
     * @uses EmvAuthorizationRequest::setCardTrackData()
     * @uses EmvAuthorizationRequest::setChannel()
     * @uses EmvAuthorizationRequest::setCurrency()
     * @uses EmvAuthorizationRequest::setCurrencyISO()
     * @uses EmvAuthorizationRequest::setEmvRequest()
     * @uses EmvAuthorizationRequest::setExpiryDate()
     * @uses EmvAuthorizationRequest::setMerchantType()
     * @uses EmvAuthorizationRequest::setOfflineAuthorization()
     * @uses EmvAuthorizationRequest::setOrderID()
     * @uses EmvAuthorizationRequest::setOrderInfo()
     * @uses EmvAuthorizationRequest::setOrderName()
     * @uses EmvAuthorizationRequest::setPinBlock()
     * @uses EmvAuthorizationRequest::setTransactionCertificate()
     * @uses EmvAuthorizationRequest::setTransactionHint()
     * @uses EmvAuthorizationRequest::setVerifyCode()
     * @param string $accountNumber
     * @param float $amount
     * @param string $cardTrackData
     * @param string $channel
     * @param string $currency
     * @param int $currencyISO
     * @param \StructType\EmvRequestInfo $emvRequest
     * @param string $expiryDate
     * @param string $merchantType
     * @param bool $offlineAuthorization
     * @param string $orderID
     * @param string $orderInfo
     * @param string $orderName
     * @param string $pinBlock
     * @param string $transactionCertificate
     * @param string $transactionHint
     * @param string $verifyCode
     */
    public function __construct($accountNumber = null, $amount = null, $cardTrackData = null, $channel = null, $currency = null, $currencyISO = null, \StructType\EmvRequestInfo $emvRequest = null, $expiryDate = null, $merchantType = null, $offlineAuthorization = null, $orderID = null, $orderInfo = null, $orderName = null, $pinBlock = null, $transactionCertificate = null, $transactionHint = null, $verifyCode = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setAmount($amount)
            ->setCardTrackData($cardTrackData)
            ->setChannel($channel)
            ->setCurrency($currency)
            ->setCurrencyISO($currencyISO)
            ->setEmvRequest($emvRequest)
            ->setExpiryDate($expiryDate)
            ->setMerchantType($merchantType)
            ->setOfflineAuthorization($offlineAuthorization)
            ->setOrderID($orderID)
            ->setOrderInfo($orderInfo)
            ->setOrderName($orderName)
            ->setPinBlock($pinBlock)
            ->setTransactionCertificate($transactionCertificate)
            ->setTransactionHint($transactionHint)
            ->setVerifyCode($verifyCode);
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CardTrackData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardTrackData()
    {
        return isset($this->CardTrackData) ? $this->CardTrackData : null;
    }
    /**
     * Set CardTrackData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardTrackData
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setCardTrackData($cardTrackData = null)
    {
        // validation for constraint: string
        if (!is_null($cardTrackData) && !is_string($cardTrackData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardTrackData)), __LINE__);
        }
        if (is_null($cardTrackData) || (is_array($cardTrackData) && empty($cardTrackData))) {
            unset($this->CardTrackData);
        } else {
            $this->CardTrackData = $cardTrackData;
        }
        return $this;
    }
    /**
     * Get Channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->Channel;
    }
    /**
     * Set Channel value
     * @uses \EnumType\Channels::valueIsValid()
     * @uses \EnumType\Channels::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $channel
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Channels::valueIsValid($channel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $channel, implode(', ', \EnumType\Channels::getValidValues())), __LINE__);
        }
        $this->Channel = $channel;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @uses \EnumType\Currencies::valueIsValid()
     * @uses \EnumType\Currencies::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Currencies::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $currency, implode(', ', \EnumType\Currencies::getValidValues())), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get CurrencyISO value
     * @return int|null
     */
    public function getCurrencyISO()
    {
        return $this->CurrencyISO;
    }
    /**
     * Set CurrencyISO value
     * @param int $currencyISO
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setCurrencyISO($currencyISO = null)
    {
        // validation for constraint: int
        if (!is_null($currencyISO) && !is_numeric($currencyISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currencyISO)), __LINE__);
        }
        $this->CurrencyISO = $currencyISO;
        return $this;
    }
    /**
     * Get EmvRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EmvRequestInfo|null
     */
    public function getEmvRequest()
    {
        return isset($this->EmvRequest) ? $this->EmvRequest : null;
    }
    /**
     * Set EmvRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\EmvRequestInfo $emvRequest
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setEmvRequest(\StructType\EmvRequestInfo $emvRequest = null)
    {
        if (is_null($emvRequest) || (is_array($emvRequest) && empty($emvRequest))) {
            unset($this->EmvRequest);
        } else {
            $this->EmvRequest = $emvRequest;
        }
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param string $expiryDate
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDate)), __LINE__);
        }
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get MerchantType value
     * @return string|null
     */
    public function getMerchantType()
    {
        return $this->MerchantType;
    }
    /**
     * Set MerchantType value
     * @uses \EnumType\MerchantType::valueIsValid()
     * @uses \EnumType\MerchantType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $merchantType
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setMerchantType($merchantType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MerchantType::valueIsValid($merchantType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $merchantType, implode(', ', \EnumType\MerchantType::getValidValues())), __LINE__);
        }
        $this->MerchantType = $merchantType;
        return $this;
    }
    /**
     * Get OfflineAuthorization value
     * @return bool|null
     */
    public function getOfflineAuthorization()
    {
        return $this->OfflineAuthorization;
    }
    /**
     * Set OfflineAuthorization value
     * @param bool $offlineAuthorization
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setOfflineAuthorization($offlineAuthorization = null)
    {
        // validation for constraint: boolean
        if (!is_null($offlineAuthorization) && !is_bool($offlineAuthorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($offlineAuthorization)), __LINE__);
        }
        $this->OfflineAuthorization = $offlineAuthorization;
        return $this;
    }
    /**
     * Get OrderID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderID()
    {
        return isset($this->OrderID) ? $this->OrderID : null;
    }
    /**
     * Set OrderID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderID
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderID)), __LINE__);
        }
        if (is_null($orderID) || (is_array($orderID) && empty($orderID))) {
            unset($this->OrderID);
        } else {
            $this->OrderID = $orderID;
        }
        return $this;
    }
    /**
     * Get OrderInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderInfo()
    {
        return isset($this->OrderInfo) ? $this->OrderInfo : null;
    }
    /**
     * Set OrderInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderInfo
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setOrderInfo($orderInfo = null)
    {
        // validation for constraint: string
        if (!is_null($orderInfo) && !is_string($orderInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderInfo)), __LINE__);
        }
        if (is_null($orderInfo) || (is_array($orderInfo) && empty($orderInfo))) {
            unset($this->OrderInfo);
        } else {
            $this->OrderInfo = $orderInfo;
        }
        return $this;
    }
    /**
     * Get OrderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderName()
    {
        return isset($this->OrderName) ? $this->OrderName : null;
    }
    /**
     * Set OrderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderName
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setOrderName($orderName = null)
    {
        // validation for constraint: string
        if (!is_null($orderName) && !is_string($orderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderName)), __LINE__);
        }
        if (is_null($orderName) || (is_array($orderName) && empty($orderName))) {
            unset($this->OrderName);
        } else {
            $this->OrderName = $orderName;
        }
        return $this;
    }
    /**
     * Get PinBlock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPinBlock()
    {
        return isset($this->PinBlock) ? $this->PinBlock : null;
    }
    /**
     * Set PinBlock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pinBlock
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setPinBlock($pinBlock = null)
    {
        // validation for constraint: string
        if (!is_null($pinBlock) && !is_string($pinBlock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pinBlock)), __LINE__);
        }
        if (is_null($pinBlock) || (is_array($pinBlock) && empty($pinBlock))) {
            unset($this->PinBlock);
        } else {
            $this->PinBlock = $pinBlock;
        }
        return $this;
    }
    /**
     * Get TransactionCertificate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionCertificate()
    {
        return isset($this->TransactionCertificate) ? $this->TransactionCertificate : null;
    }
    /**
     * Set TransactionCertificate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionCertificate
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setTransactionCertificate($transactionCertificate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionCertificate) && !is_string($transactionCertificate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionCertificate)), __LINE__);
        }
        if (is_null($transactionCertificate) || (is_array($transactionCertificate) && empty($transactionCertificate))) {
            unset($this->TransactionCertificate);
        } else {
            $this->TransactionCertificate = $transactionCertificate;
        }
        return $this;
    }
    /**
     * Get TransactionHint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionHint()
    {
        return isset($this->TransactionHint) ? $this->TransactionHint : null;
    }
    /**
     * Set TransactionHint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionHint
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setTransactionHint($transactionHint = null)
    {
        // validation for constraint: string
        if (!is_null($transactionHint) && !is_string($transactionHint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionHint)), __LINE__);
        }
        if (is_null($transactionHint) || (is_array($transactionHint) && empty($transactionHint))) {
            unset($this->TransactionHint);
        } else {
            $this->TransactionHint = $transactionHint;
        }
        return $this;
    }
    /**
     * Get VerifyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVerifyCode()
    {
        return isset($this->VerifyCode) ? $this->VerifyCode : null;
    }
    /**
     * Set VerifyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $verifyCode
     * @return \StructType\EmvAuthorizationRequest
     */
    public function setVerifyCode($verifyCode = null)
    {
        // validation for constraint: string
        if (!is_null($verifyCode) && !is_string($verifyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($verifyCode)), __LINE__);
        }
        if (is_null($verifyCode) || (is_array($verifyCode) && empty($verifyCode))) {
            unset($this->VerifyCode);
        } else {
            $this->VerifyCode = $verifyCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmvAuthorizationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
