<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Query ServiceType
 * @subpackage Services
 */
class Query extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named QueryTransaction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\QueryTransaction $parameters
     * @return \StructType\QueryTransactionResponse|bool
     */
    public function QueryTransaction(\StructType\QueryTransaction $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->QueryTransaction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\QueryData $parameters
     * @return \StructType\QueryDataResponse|bool
     */
    public function QueryData(\StructType\QueryData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->QueryData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\QueryDataResponse|\StructType\QueryTransactionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
