<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Emv ServiceType
 * @subpackage Services
 */
class Emv extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EmvAuthorize
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmvAuthorize $parameters
     * @return \StructType\EmvAuthorizeResponse|bool
     */
    public function EmvAuthorize(\StructType\EmvAuthorize $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EmvAuthorize($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EmvAuthorizeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
