<?php

namespace EnumType;

/**
 * This class stands for MerchantType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MerchantType
 * @subpackage Enumerations
 */
class MerchantType
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Etisalat'
     * @return string 'Etisalat'
     */
    const VALUE_ETISALAT = 'Etisalat';
    /**
     * Constant for value 'FAB'
     * @return string 'FAB'
     */
    const VALUE_FAB = 'FAB';
    /**
     * Constant for value 'EtisalatPartner'
     * @return string 'EtisalatPartner'
     */
    const VALUE_ETISALAT_PARTNER = 'EtisalatPartner';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_ETISALAT
     * @uses self::VALUE_FAB
     * @uses self::VALUE_ETISALAT_PARTNER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_ETISALAT,
            self::VALUE_FAB,
            self::VALUE_ETISALAT_PARTNER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
