<?php

namespace EnumType;

/**
 * This class stands for Currencies EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Currencies
 * @subpackage Enumerations
 */
class Currencies
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'AED'
     * @return string 'AED'
     */
    const VALUE_AED = 'AED';
    /**
     * Constant for value 'USD'
     * @return string 'USD'
     */
    const VALUE_USD = 'USD';
    /**
     * Constant for value 'PKR'
     * @return string 'PKR'
     */
    const VALUE_PKR = 'PKR';
    /**
     * Constant for value 'AUD'
     * @return string 'AUD'
     */
    const VALUE_AUD = 'AUD';
    /**
     * Constant for value 'BRL'
     * @return string 'BRL'
     */
    const VALUE_BRL = 'BRL';
    /**
     * Constant for value 'BGN'
     * @return string 'BGN'
     */
    const VALUE_BGN = 'BGN';
    /**
     * Constant for value 'BHD'
     * @return string 'BHD'
     */
    const VALUE_BHD = 'BHD';
    /**
     * Constant for value 'CHF'
     * @return string 'CHF'
     */
    const VALUE_CHF = 'CHF';
    /**
     * Constant for value 'CYP'
     * @return string 'CYP'
     */
    const VALUE_CYP = 'CYP';
    /**
     * Constant for value 'CNY'
     * @return string 'CNY'
     */
    const VALUE_CNY = 'CNY';
    /**
     * Constant for value 'CAD'
     * @return string 'CAD'
     */
    const VALUE_CAD = 'CAD';
    /**
     * Constant for value 'CZK'
     * @return string 'CZK'
     */
    const VALUE_CZK = 'CZK';
    /**
     * Constant for value 'DZD'
     * @return string 'DZD'
     */
    const VALUE_DZD = 'DZD';
    /**
     * Constant for value 'DKK'
     * @return string 'DKK'
     */
    const VALUE_DKK = 'DKK';
    /**
     * Constant for value 'EUR'
     * @return string 'EUR'
     */
    const VALUE_EUR = 'EUR';
    /**
     * Constant for value 'EEK'
     * @return string 'EEK'
     */
    const VALUE_EEK = 'EEK';
    /**
     * Constant for value 'EGP'
     * @return string 'EGP'
     */
    const VALUE_EGP = 'EGP';
    /**
     * Constant for value 'GBP'
     * @return string 'GBP'
     */
    const VALUE_GBP = 'GBP';
    /**
     * Constant for value 'HKD'
     * @return string 'HKD'
     */
    const VALUE_HKD = 'HKD';
    /**
     * Constant for value 'HUF'
     * @return string 'HUF'
     */
    const VALUE_HUF = 'HUF';
    /**
     * Constant for value 'INR'
     * @return string 'INR'
     */
    const VALUE_INR = 'INR';
    /**
     * Constant for value 'IRR'
     * @return string 'IRR'
     */
    const VALUE_IRR = 'IRR';
    /**
     * Constant for value 'ILS'
     * @return string 'ILS'
     */
    const VALUE_ILS = 'ILS';
    /**
     * Constant for value 'JPY'
     * @return string 'JPY'
     */
    const VALUE_JPY = 'JPY';
    /**
     * Constant for value 'JOD'
     * @return string 'JOD'
     */
    const VALUE_JOD = 'JOD';
    /**
     * Constant for value 'KWD'
     * @return string 'KWD'
     */
    const VALUE_KWD = 'KWD';
    /**
     * Constant for value 'KRW'
     * @return string 'KRW'
     */
    const VALUE_KRW = 'KRW';
    /**
     * Constant for value 'LYD'
     * @return string 'LYD'
     */
    const VALUE_LYD = 'LYD';
    /**
     * Constant for value 'LVL'
     * @return string 'LVL'
     */
    const VALUE_LVL = 'LVL';
    /**
     * Constant for value 'LKR'
     * @return string 'LKR'
     */
    const VALUE_LKR = 'LKR';
    /**
     * Constant for value 'MMK'
     * @return string 'MMK'
     */
    const VALUE_MMK = 'MMK';
    /**
     * Constant for value 'MYR'
     * @return string 'MYR'
     */
    const VALUE_MYR = 'MYR';
    /**
     * Constant for value 'MXN'
     * @return string 'MXN'
     */
    const VALUE_MXN = 'MXN';
    /**
     * Constant for value 'MAD'
     * @return string 'MAD'
     */
    const VALUE_MAD = 'MAD';
    /**
     * Constant for value 'NZD'
     * @return string 'NZD'
     */
    const VALUE_NZD = 'NZD';
    /**
     * Constant for value 'NOK'
     * @return string 'NOK'
     */
    const VALUE_NOK = 'NOK';
    /**
     * Constant for value 'OMR'
     * @return string 'OMR'
     */
    const VALUE_OMR = 'OMR';
    /**
     * Constant for value 'PHP'
     * @return string 'PHP'
     */
    const VALUE_PHP = 'PHP';
    /**
     * Constant for value 'PLN'
     * @return string 'PLN'
     */
    const VALUE_PLN = 'PLN';
    /**
     * Constant for value 'QAR'
     * @return string 'QAR'
     */
    const VALUE_QAR = 'QAR';
    /**
     * Constant for value 'RUB'
     * @return string 'RUB'
     */
    const VALUE_RUB = 'RUB';
    /**
     * Constant for value 'SYP'
     * @return string 'SYP'
     */
    const VALUE_SYP = 'SYP';
    /**
     * Constant for value 'SCR'
     * @return string 'SCR'
     */
    const VALUE_SCR = 'SCR';
    /**
     * Constant for value 'SAR'
     * @return string 'SAR'
     */
    const VALUE_SAR = 'SAR';
    /**
     * Constant for value 'SGD'
     * @return string 'SGD'
     */
    const VALUE_SGD = 'SGD';
    /**
     * Constant for value 'SEK'
     * @return string 'SEK'
     */
    const VALUE_SEK = 'SEK';
    /**
     * Constant for value 'TWD'
     * @return string 'TWD'
     */
    const VALUE_TWD = 'TWD';
    /**
     * Constant for value 'TND'
     * @return string 'TND'
     */
    const VALUE_TND = 'TND';
    /**
     * Constant for value 'THB'
     * @return string 'THB'
     */
    const VALUE_THB = 'THB';
    /**
     * Constant for value 'TRY'
     * @return string 'TRY'
     */
    const VALUE_TRY = 'TRY';
    /**
     * Constant for value 'YER'
     * @return string 'YER'
     */
    const VALUE_YER = 'YER';
    /**
     * Constant for value 'ZAR'
     * @return string 'ZAR'
     */
    const VALUE_ZAR = 'ZAR';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_AED
     * @uses self::VALUE_USD
     * @uses self::VALUE_PKR
     * @uses self::VALUE_AUD
     * @uses self::VALUE_BRL
     * @uses self::VALUE_BGN
     * @uses self::VALUE_BHD
     * @uses self::VALUE_CHF
     * @uses self::VALUE_CYP
     * @uses self::VALUE_CNY
     * @uses self::VALUE_CAD
     * @uses self::VALUE_CZK
     * @uses self::VALUE_DZD
     * @uses self::VALUE_DKK
     * @uses self::VALUE_EUR
     * @uses self::VALUE_EEK
     * @uses self::VALUE_EGP
     * @uses self::VALUE_GBP
     * @uses self::VALUE_HKD
     * @uses self::VALUE_HUF
     * @uses self::VALUE_INR
     * @uses self::VALUE_IRR
     * @uses self::VALUE_ILS
     * @uses self::VALUE_JPY
     * @uses self::VALUE_JOD
     * @uses self::VALUE_KWD
     * @uses self::VALUE_KRW
     * @uses self::VALUE_LYD
     * @uses self::VALUE_LVL
     * @uses self::VALUE_LKR
     * @uses self::VALUE_MMK
     * @uses self::VALUE_MYR
     * @uses self::VALUE_MXN
     * @uses self::VALUE_MAD
     * @uses self::VALUE_NZD
     * @uses self::VALUE_NOK
     * @uses self::VALUE_OMR
     * @uses self::VALUE_PHP
     * @uses self::VALUE_PLN
     * @uses self::VALUE_QAR
     * @uses self::VALUE_RUB
     * @uses self::VALUE_SYP
     * @uses self::VALUE_SCR
     * @uses self::VALUE_SAR
     * @uses self::VALUE_SGD
     * @uses self::VALUE_SEK
     * @uses self::VALUE_TWD
     * @uses self::VALUE_TND
     * @uses self::VALUE_THB
     * @uses self::VALUE_TRY
     * @uses self::VALUE_YER
     * @uses self::VALUE_ZAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_AED,
            self::VALUE_USD,
            self::VALUE_PKR,
            self::VALUE_AUD,
            self::VALUE_BRL,
            self::VALUE_BGN,
            self::VALUE_BHD,
            self::VALUE_CHF,
            self::VALUE_CYP,
            self::VALUE_CNY,
            self::VALUE_CAD,
            self::VALUE_CZK,
            self::VALUE_DZD,
            self::VALUE_DKK,
            self::VALUE_EUR,
            self::VALUE_EEK,
            self::VALUE_EGP,
            self::VALUE_GBP,
            self::VALUE_HKD,
            self::VALUE_HUF,
            self::VALUE_INR,
            self::VALUE_IRR,
            self::VALUE_ILS,
            self::VALUE_JPY,
            self::VALUE_JOD,
            self::VALUE_KWD,
            self::VALUE_KRW,
            self::VALUE_LYD,
            self::VALUE_LVL,
            self::VALUE_LKR,
            self::VALUE_MMK,
            self::VALUE_MYR,
            self::VALUE_MXN,
            self::VALUE_MAD,
            self::VALUE_NZD,
            self::VALUE_NOK,
            self::VALUE_OMR,
            self::VALUE_PHP,
            self::VALUE_PLN,
            self::VALUE_QAR,
            self::VALUE_RUB,
            self::VALUE_SYP,
            self::VALUE_SCR,
            self::VALUE_SAR,
            self::VALUE_SGD,
            self::VALUE_SEK,
            self::VALUE_TWD,
            self::VALUE_TND,
            self::VALUE_THB,
            self::VALUE_TRY,
            self::VALUE_YER,
            self::VALUE_ZAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
