<?php

namespace EnumType;

/**
 * This class stands for Channels EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Channels
 * @subpackage Enumerations
 */
class Channels
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Web'
     * @return string 'Web'
     */
    const VALUE_WEB = 'Web';
    /**
     * Constant for value 'Terminal'
     * @return string 'Terminal'
     */
    const VALUE_TERMINAL = 'Terminal';
    /**
     * Constant for value 'POS'
     * @return string 'POS'
     */
    const VALUE_POS = 'POS';
    /**
     * Constant for value 'Mail'
     * @return string 'Mail'
     */
    const VALUE_MAIL = 'Mail';
    /**
     * Constant for value 'Phone'
     * @return string 'Phone'
     */
    const VALUE_PHONE = 'Phone';
    /**
     * Constant for value 'Recurring'
     * @return string 'Recurring'
     */
    const VALUE_RECURRING = 'Recurring';
    /**
     * Constant for value 'MEC'
     * @return string 'MEC'
     */
    const VALUE_MEC = 'MEC';
    /**
     * Constant for value 'USSD'
     * @return string 'USSD'
     */
    const VALUE_USSD = 'USSD';
    /**
     * Constant for value 'Mobile'
     * @return string 'Mobile'
     */
    const VALUE_MOBILE = 'Mobile';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_WEB
     * @uses self::VALUE_TERMINAL
     * @uses self::VALUE_POS
     * @uses self::VALUE_MAIL
     * @uses self::VALUE_PHONE
     * @uses self::VALUE_RECURRING
     * @uses self::VALUE_MEC
     * @uses self::VALUE_USSD
     * @uses self::VALUE_MOBILE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_WEB,
            self::VALUE_TERMINAL,
            self::VALUE_POS,
            self::VALUE_MAIL,
            self::VALUE_PHONE,
            self::VALUE_RECURRING,
            self::VALUE_MEC,
            self::VALUE_USSD,
            self::VALUE_MOBILE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
