<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'Register' => '\\StructType\\Register',
            'RegisterResponse' => '\\StructType\\RegisterResponse',
            'Authorize' => '\\StructType\\Authorize',
            'AuthorizeResponse' => '\\StructType\\AuthorizeResponse',
            'Finalize' => '\\StructType\\Finalize',
            'FinalizeResponse' => '\\StructType\\FinalizeResponse',
            'Capture' => '\\StructType\\Capture',
            'CaptureResponse' => '\\StructType\\CaptureResponse',
            'Reverse' => '\\StructType\\Reverse',
            'ReverseResponse' => '\\StructType\\ReverseResponse',
            'Refund' => '\\StructType\\Refund',
            'RefundResponse' => '\\StructType\\RefundResponse',
            'Execute' => '\\StructType\\Execute',
            'ExecuteResponse' => '\\StructType\\ExecuteResponse',
            'QueryTransaction' => '\\StructType\\QueryTransaction',
            'QueryTransactionResponse' => '\\StructType\\QueryTransactionResponse',
            'QueryData' => '\\StructType\\QueryData',
            'QueryDataResponse' => '\\StructType\\QueryDataResponse',
            'EmvAuthorize' => '\\StructType\\EmvAuthorize',
            'EmvAuthorizeResponse' => '\\StructType\\EmvAuthorizeResponse',
            'RegistrationRequestX' => '\\StructType\\RegistrationRequestX',
            'TemplateRequestX' => '\\StructType\\TemplateRequestX',
            'ArrayOfDataX' => '\\ArrayType\\ArrayOfDataX',
            'DataX' => '\\StructType\\DataX',
            'RecurrenceInfoX' => '\\StructType\\RecurrenceInfoX',
            'RegistrationResponseX' => '\\StructType\\RegistrationResponseX',
            'TemplateResponseX' => '\\StructType\\TemplateResponseX',
            'AuthorizationRequestX' => '\\StructType\\AuthorizationRequestX',
            'AuthorizationResponseX' => '\\StructType\\AuthorizationResponseX',
            'FinalizationRequestX' => '\\StructType\\FinalizationRequestX',
            'FinalizationResponseX' => '\\StructType\\FinalizationResponseX',
            'CaptureRequestX' => '\\StructType\\CaptureRequestX',
            'CaptureResponseX' => '\\StructType\\CaptureResponseX',
            'ReversalRequestX' => '\\StructType\\ReversalRequestX',
            'ReversalResponseX' => '\\StructType\\ReversalResponseX',
            'RefundRequestX' => '\\StructType\\RefundRequestX',
            'RefundResponseX' => '\\StructType\\RefundResponseX',
            'ExecutionRequestX' => '\\StructType\\ExecutionRequestX',
            'ExecutionResponseX' => '\\StructType\\ExecutionResponseX',
            'QueryTransactionRequestX' => '\\StructType\\QueryTransactionRequestX',
            'QueryTransactionResponseX' => '\\StructType\\QueryTransactionResponseX',
            'TransactionAccountX' => '\\StructType\\TransactionAccountX',
            'TransactionCustomerX' => '\\StructType\\TransactionCustomerX',
            'ArrayOfTransactionDetailX' => '\\ArrayType\\ArrayOfTransactionDetailX',
            'TransactionDetailX' => '\\StructType\\TransactionDetailX',
            'ArrayOfParameters' => '\\ArrayType\\ArrayOfParameters',
            'Parameters' => '\\StructType\\Parameters',
            'TransactionRequestBaseX' => '\\StructType\\TransactionRequestBaseX',
            'ArrayOfQueryTransactionParameter' => '\\ArrayType\\ArrayOfQueryTransactionParameter',
            'QueryTransactionParameter' => '\\StructType\\QueryTransactionParameter',
            'TransactionPayerX' => '\\StructType\\TransactionPayerX',
            'TransactionProcessingStatus' => '\\StructType\\TransactionProcessingStatus',
            'TransactionMasterX' => '\\StructType\\TransactionMasterX',
            'UniqueId' => '\\StructType\\UniqueId',
            'QueryDataRequest' => '\\StructType\\QueryDataRequest',
            'ArrayOfInputParameter' => '\\ArrayType\\ArrayOfInputParameter',
            'InputParameter' => '\\StructType\\InputParameter',
            'ArrayOfRow' => '\\ArrayType\\ArrayOfRow',
            'Row' => '\\StructType\\Row',
            'EmvAuthorizationRequest' => '\\StructType\\EmvAuthorizationRequest',
            'EmvRequestInfo' => '\\StructType\\EmvRequestInfo',
            'EmvIssuerActionCode' => '\\StructType\\EmvIssuerActionCode',
            'EmvAuthorizationResponse' => '\\StructType\\EmvAuthorizationResponse',
        );
    }
}
