<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRow ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRow
 * @subpackage Arrays
 */
class ArrayOfRow extends AbstractStructArrayBase
{
    /**
     * The Row
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Row[]
     */
    public $Row;
    /**
     * Constructor method for ArrayOfRow
     * @uses ArrayOfRow::setRow()
     * @param \StructType\Row[] $row
     */
    public function __construct(array $row = array())
    {
        $this
            ->setRow($row);
    }
    /**
     * Get Row value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Row[]|null
     */
    public function getRow()
    {
        return isset($this->Row) ? $this->Row : null;
    }
    /**
     * Set Row value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Row[] $row
     * @return \ArrayType\ArrayOfRow
     */
    public function setRow(array $row = array())
    {
        foreach ($row as $arrayOfRowRowItem) {
            // validation for constraint: itemType
            if (!$arrayOfRowRowItem instanceof \StructType\Row) {
                throw new \InvalidArgumentException(sprintf('The Row property can only contain items of \StructType\Row, "%s" given', is_object($arrayOfRowRowItem) ? get_class($arrayOfRowRowItem) : gettype($arrayOfRowRowItem)), __LINE__);
            }
        }
        if (is_null($row) || (is_array($row) && empty($row))) {
            unset($this->Row);
        } else {
            $this->Row = $row;
        }
        return $this;
    }
    /**
     * Add item to Row value
     * @throws \InvalidArgumentException
     * @param \StructType\Row $item
     * @return \ArrayType\ArrayOfRow
     */
    public function addToRow(\StructType\Row $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Row) {
            throw new \InvalidArgumentException(sprintf('The Row property can only contain items of \StructType\Row, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Row[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Row|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Row|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Row|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Row|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Row|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Row
     */
    public function getAttributeName()
    {
        return 'Row';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRow
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
