<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfParameters ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfParameters
 * @subpackage Arrays
 */
class ArrayOfParameters extends AbstractStructArrayBase
{
    /**
     * The Parameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Parameters[]
     */
    public $Parameters;
    /**
     * Constructor method for ArrayOfParameters
     * @uses ArrayOfParameters::setParameters()
     * @param \StructType\Parameters[] $parameters
     */
    public function __construct(array $parameters = array())
    {
        $this
            ->setParameters($parameters);
    }
    /**
     * Get Parameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Parameters[]|null
     */
    public function getParameters()
    {
        return isset($this->Parameters) ? $this->Parameters : null;
    }
    /**
     * Set Parameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Parameters[] $parameters
     * @return \ArrayType\ArrayOfParameters
     */
    public function setParameters(array $parameters = array())
    {
        foreach ($parameters as $arrayOfParametersParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfParametersParametersItem instanceof \StructType\Parameters) {
                throw new \InvalidArgumentException(sprintf('The Parameters property can only contain items of \StructType\Parameters, "%s" given', is_object($arrayOfParametersParametersItem) ? get_class($arrayOfParametersParametersItem) : gettype($arrayOfParametersParametersItem)), __LINE__);
            }
        }
        if (is_null($parameters) || (is_array($parameters) && empty($parameters))) {
            unset($this->Parameters);
        } else {
            $this->Parameters = $parameters;
        }
        return $this;
    }
    /**
     * Add item to Parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\Parameters $item
     * @return \ArrayType\ArrayOfParameters
     */
    public function addToParameters(\StructType\Parameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Parameters) {
            throw new \InvalidArgumentException(sprintf('The Parameters property can only contain items of \StructType\Parameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Parameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Parameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Parameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Parameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Parameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Parameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Parameters
     */
    public function getAttributeName()
    {
        return 'Parameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
