<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDataX ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDataX
 * @subpackage Arrays
 */
class ArrayOfDataX extends AbstractStructArrayBase
{
    /**
     * The DataX
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DataX[]
     */
    public $DataX;
    /**
     * Constructor method for ArrayOfDataX
     * @uses ArrayOfDataX::setDataX()
     * @param \StructType\DataX[] $dataX
     */
    public function __construct(array $dataX = array())
    {
        $this
            ->setDataX($dataX);
    }
    /**
     * Get DataX value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DataX[]|null
     */
    public function getDataX()
    {
        return isset($this->DataX) ? $this->DataX : null;
    }
    /**
     * Set DataX value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DataX[] $dataX
     * @return \ArrayType\ArrayOfDataX
     */
    public function setDataX(array $dataX = array())
    {
        foreach ($dataX as $arrayOfDataXDataXItem) {
            // validation for constraint: itemType
            if (!$arrayOfDataXDataXItem instanceof \StructType\DataX) {
                throw new \InvalidArgumentException(sprintf('The DataX property can only contain items of \StructType\DataX, "%s" given', is_object($arrayOfDataXDataXItem) ? get_class($arrayOfDataXDataXItem) : gettype($arrayOfDataXDataXItem)), __LINE__);
            }
        }
        if (is_null($dataX) || (is_array($dataX) && empty($dataX))) {
            unset($this->DataX);
        } else {
            $this->DataX = $dataX;
        }
        return $this;
    }
    /**
     * Add item to DataX value
     * @throws \InvalidArgumentException
     * @param \StructType\DataX $item
     * @return \ArrayType\ArrayOfDataX
     */
    public function addToDataX(\StructType\DataX $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DataX) {
            throw new \InvalidArgumentException(sprintf('The DataX property can only contain items of \StructType\DataX, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DataX[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DataX|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DataX|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DataX|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DataX|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DataX|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DataX
     */
    public function getAttributeName()
    {
        return 'DataX';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDataX
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
