<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemplateRequestX StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TemplateRequestX
 * @subpackage Structs
 */
class TemplateRequestX extends AbstractStructBase
{
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Customer;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The RequestParameters
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDataX
     */
    public $RequestParameters;
    /**
     * The Store
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Store;
    /**
     * The Terminal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Terminal;
    /**
     * Constructor method for TemplateRequestX
     * @uses TemplateRequestX::setCustomer()
     * @uses TemplateRequestX::setLanguage()
     * @uses TemplateRequestX::setPassword()
     * @uses TemplateRequestX::setRequestParameters()
     * @uses TemplateRequestX::setStore()
     * @uses TemplateRequestX::setTerminal()
     * @param string $customer
     * @param string $language
     * @param string $password
     * @param \ArrayType\ArrayOfDataX $requestParameters
     * @param string $store
     * @param string $terminal
     */
    public function __construct($customer = null, $language = null, $password = null, \ArrayType\ArrayOfDataX $requestParameters = null, $store = null, $terminal = null)
    {
        $this
            ->setCustomer($customer)
            ->setLanguage($language)
            ->setPassword($password)
            ->setRequestParameters($requestParameters)
            ->setStore($store)
            ->setTerminal($terminal);
    }
    /**
     * Get Customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomer()
    {
        return isset($this->Customer) ? $this->Customer : null;
    }
    /**
     * Set Customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customer
     * @return \StructType\TemplateRequestX
     */
    public function setCustomer($customer = null)
    {
        // validation for constraint: string
        if (!is_null($customer) && !is_string($customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer)), __LINE__);
        }
        if (is_null($customer) || (is_array($customer) && empty($customer))) {
            unset($this->Customer);
        } else {
            $this->Customer = $customer;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \StructType\TemplateRequestX
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\TemplateRequestX
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get RequestParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDataX|null
     */
    public function getRequestParameters()
    {
        return isset($this->RequestParameters) ? $this->RequestParameters : null;
    }
    /**
     * Set RequestParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDataX $requestParameters
     * @return \StructType\TemplateRequestX
     */
    public function setRequestParameters(\ArrayType\ArrayOfDataX $requestParameters = null)
    {
        if (is_null($requestParameters) || (is_array($requestParameters) && empty($requestParameters))) {
            unset($this->RequestParameters);
        } else {
            $this->RequestParameters = $requestParameters;
        }
        return $this;
    }
    /**
     * Get Store value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStore()
    {
        return isset($this->Store) ? $this->Store : null;
    }
    /**
     * Set Store value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $store
     * @return \StructType\TemplateRequestX
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store)), __LINE__);
        }
        if (is_null($store) || (is_array($store) && empty($store))) {
            unset($this->Store);
        } else {
            $this->Store = $store;
        }
        return $this;
    }
    /**
     * Get Terminal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminal()
    {
        return isset($this->Terminal) ? $this->Terminal : null;
    }
    /**
     * Set Terminal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminal
     * @return \StructType\TemplateRequestX
     */
    public function setTerminal($terminal = null)
    {
        // validation for constraint: string
        if (!is_null($terminal) && !is_string($terminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminal)), __LINE__);
        }
        if (is_null($terminal) || (is_array($terminal) && empty($terminal))) {
            unset($this->Terminal);
        } else {
            $this->Terminal = $terminal;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TemplateRequestX
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
