<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegistrationRequestX StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RegistrationRequestX
 * @subpackage Structs
 */
class RegistrationRequestX extends TemplateRequestX
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Channel
     * @var string
     */
    public $Channel;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderID;
    /**
     * The OrderInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderInfo;
    /**
     * The OrderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderName;
    /**
     * The Recurrence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RecurrenceInfoX
     */
    public $Recurrence;
    /**
     * The RecurrenceID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecurrenceID;
    /**
     * The ReturnPath
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReturnPath;
    /**
     * The TransactionHint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionHint;
    /**
     * Constructor method for RegistrationRequestX
     * @uses RegistrationRequestX::setAmount()
     * @uses RegistrationRequestX::setChannel()
     * @uses RegistrationRequestX::setCurrency()
     * @uses RegistrationRequestX::setOrderID()
     * @uses RegistrationRequestX::setOrderInfo()
     * @uses RegistrationRequestX::setOrderName()
     * @uses RegistrationRequestX::setRecurrence()
     * @uses RegistrationRequestX::setRecurrenceID()
     * @uses RegistrationRequestX::setReturnPath()
     * @uses RegistrationRequestX::setTransactionHint()
     * @param float $amount
     * @param string $channel
     * @param string $currency
     * @param string $orderID
     * @param string $orderInfo
     * @param string $orderName
     * @param \StructType\RecurrenceInfoX $recurrence
     * @param string $recurrenceID
     * @param string $returnPath
     * @param string $transactionHint
     */
    public function __construct($amount = null, $channel = null, $currency = null, $orderID = null, $orderInfo = null, $orderName = null, \StructType\RecurrenceInfoX $recurrence = null, $recurrenceID = null, $returnPath = null, $transactionHint = null)
    {
        $this
            ->setAmount($amount)
            ->setChannel($channel)
            ->setCurrency($currency)
            ->setOrderID($orderID)
            ->setOrderInfo($orderInfo)
            ->setOrderName($orderName)
            ->setRecurrence($recurrence)
            ->setRecurrenceID($recurrenceID)
            ->setReturnPath($returnPath)
            ->setTransactionHint($transactionHint);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\RegistrationRequestX
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->Channel;
    }
    /**
     * Set Channel value
     * @uses \EnumType\Channels::valueIsValid()
     * @uses \EnumType\Channels::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $channel
     * @return \StructType\RegistrationRequestX
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Channels::valueIsValid($channel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $channel, implode(', ', \EnumType\Channels::getValidValues())), __LINE__);
        }
        $this->Channel = $channel;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @uses \EnumType\Currencies::valueIsValid()
     * @uses \EnumType\Currencies::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\RegistrationRequestX
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Currencies::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $currency, implode(', ', \EnumType\Currencies::getValidValues())), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get OrderID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderID()
    {
        return isset($this->OrderID) ? $this->OrderID : null;
    }
    /**
     * Set OrderID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderID
     * @return \StructType\RegistrationRequestX
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderID)), __LINE__);
        }
        if (is_null($orderID) || (is_array($orderID) && empty($orderID))) {
            unset($this->OrderID);
        } else {
            $this->OrderID = $orderID;
        }
        return $this;
    }
    /**
     * Get OrderInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderInfo()
    {
        return isset($this->OrderInfo) ? $this->OrderInfo : null;
    }
    /**
     * Set OrderInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderInfo
     * @return \StructType\RegistrationRequestX
     */
    public function setOrderInfo($orderInfo = null)
    {
        // validation for constraint: string
        if (!is_null($orderInfo) && !is_string($orderInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderInfo)), __LINE__);
        }
        if (is_null($orderInfo) || (is_array($orderInfo) && empty($orderInfo))) {
            unset($this->OrderInfo);
        } else {
            $this->OrderInfo = $orderInfo;
        }
        return $this;
    }
    /**
     * Get OrderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderName()
    {
        return isset($this->OrderName) ? $this->OrderName : null;
    }
    /**
     * Set OrderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderName
     * @return \StructType\RegistrationRequestX
     */
    public function setOrderName($orderName = null)
    {
        // validation for constraint: string
        if (!is_null($orderName) && !is_string($orderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderName)), __LINE__);
        }
        if (is_null($orderName) || (is_array($orderName) && empty($orderName))) {
            unset($this->OrderName);
        } else {
            $this->OrderName = $orderName;
        }
        return $this;
    }
    /**
     * Get Recurrence value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RecurrenceInfoX|null
     */
    public function getRecurrence()
    {
        return isset($this->Recurrence) ? $this->Recurrence : null;
    }
    /**
     * Set Recurrence value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RecurrenceInfoX $recurrence
     * @return \StructType\RegistrationRequestX
     */
    public function setRecurrence(\StructType\RecurrenceInfoX $recurrence = null)
    {
        if (is_null($recurrence) || (is_array($recurrence) && empty($recurrence))) {
            unset($this->Recurrence);
        } else {
            $this->Recurrence = $recurrence;
        }
        return $this;
    }
    /**
     * Get RecurrenceID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecurrenceID()
    {
        return isset($this->RecurrenceID) ? $this->RecurrenceID : null;
    }
    /**
     * Set RecurrenceID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recurrenceID
     * @return \StructType\RegistrationRequestX
     */
    public function setRecurrenceID($recurrenceID = null)
    {
        // validation for constraint: string
        if (!is_null($recurrenceID) && !is_string($recurrenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recurrenceID)), __LINE__);
        }
        if (is_null($recurrenceID) || (is_array($recurrenceID) && empty($recurrenceID))) {
            unset($this->RecurrenceID);
        } else {
            $this->RecurrenceID = $recurrenceID;
        }
        return $this;
    }
    /**
     * Get ReturnPath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReturnPath()
    {
        return isset($this->ReturnPath) ? $this->ReturnPath : null;
    }
    /**
     * Set ReturnPath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $returnPath
     * @return \StructType\RegistrationRequestX
     */
    public function setReturnPath($returnPath = null)
    {
        // validation for constraint: string
        if (!is_null($returnPath) && !is_string($returnPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnPath)), __LINE__);
        }
        if (is_null($returnPath) || (is_array($returnPath) && empty($returnPath))) {
            unset($this->ReturnPath);
        } else {
            $this->ReturnPath = $returnPath;
        }
        return $this;
    }
    /**
     * Get TransactionHint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionHint()
    {
        return isset($this->TransactionHint) ? $this->TransactionHint : null;
    }
    /**
     * Set TransactionHint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionHint
     * @return \StructType\RegistrationRequestX
     */
    public function setTransactionHint($transactionHint = null)
    {
        // validation for constraint: string
        if (!is_null($transactionHint) && !is_string($transactionHint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionHint)), __LINE__);
        }
        if (is_null($transactionHint) || (is_array($transactionHint) && empty($transactionHint))) {
            unset($this->TransactionHint);
        } else {
            $this->TransactionHint = $transactionHint;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegistrationRequestX
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
