<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryDataResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:QueryDataResponse
 * @subpackage Structs
 */
class QueryDataResponse extends TemplateResponseX
{
    /**
     * The QueryDataResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\QueryDataResponse
     */
    public $QueryDataResult;
    /**
     * The Results
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRow
     */
    public $Results;
    /**
     * The RowsCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RowsCount;
    /**
     * Constructor method for QueryDataResponse
     * @uses QueryDataResponse::setQueryDataResult()
     * @uses QueryDataResponse::setResults()
     * @uses QueryDataResponse::setRowsCount()
     * @param \StructType\QueryDataResponse $queryDataResult
     * @param \ArrayType\ArrayOfRow $results
     * @param int $rowsCount
     */
    public function __construct(\StructType\QueryDataResponse $queryDataResult = null, \ArrayType\ArrayOfRow $results = null, $rowsCount = null)
    {
        $this
            ->setQueryDataResult($queryDataResult)
            ->setResults($results)
            ->setRowsCount($rowsCount);
    }
    /**
     * Get QueryDataResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\QueryDataResponse|null
     */
    public function getQueryDataResult()
    {
        return isset($this->QueryDataResult) ? $this->QueryDataResult : null;
    }
    /**
     * Set QueryDataResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\QueryDataResponse $queryDataResult
     * @return \StructType\QueryDataResponse
     */
    public function setQueryDataResult(\StructType\QueryDataResponse $queryDataResult = null)
    {
        if (is_null($queryDataResult) || (is_array($queryDataResult) && empty($queryDataResult))) {
            unset($this->QueryDataResult);
        } else {
            $this->QueryDataResult = $queryDataResult;
        }
        return $this;
    }
    /**
     * Get Results value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRow|null
     */
    public function getResults()
    {
        return isset($this->Results) ? $this->Results : null;
    }
    /**
     * Set Results value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRow $results
     * @return \StructType\QueryDataResponse
     */
    public function setResults(\ArrayType\ArrayOfRow $results = null)
    {
        if (is_null($results) || (is_array($results) && empty($results))) {
            unset($this->Results);
        } else {
            $this->Results = $results;
        }
        return $this;
    }
    /**
     * Get RowsCount value
     * @return int|null
     */
    public function getRowsCount()
    {
        return $this->RowsCount;
    }
    /**
     * Set RowsCount value
     * @param int $rowsCount
     * @return \StructType\QueryDataResponse
     */
    public function setRowsCount($rowsCount = null)
    {
        // validation for constraint: int
        if (!is_null($rowsCount) && !is_numeric($rowsCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rowsCount)), __LINE__);
        }
        $this->RowsCount = $rowsCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QueryDataResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
