<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryDataRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:QueryDataRequest
 * @subpackage Structs
 */
class QueryDataRequest extends AbstractStructBase
{
    /**
     * The InputParameters
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInputParameter
     */
    public $InputParameters;
    /**
     * The QueryName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QueryName;
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UniqueId
     */
    public $UniqueID;
    /**
     * Constructor method for QueryDataRequest
     * @uses QueryDataRequest::setInputParameters()
     * @uses QueryDataRequest::setQueryName()
     * @uses QueryDataRequest::setUniqueID()
     * @param \ArrayType\ArrayOfInputParameter $inputParameters
     * @param string $queryName
     * @param \StructType\UniqueId $uniqueID
     */
    public function __construct(\ArrayType\ArrayOfInputParameter $inputParameters = null, $queryName = null, \StructType\UniqueId $uniqueID = null)
    {
        $this
            ->setInputParameters($inputParameters)
            ->setQueryName($queryName)
            ->setUniqueID($uniqueID);
    }
    /**
     * Get InputParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInputParameter|null
     */
    public function getInputParameters()
    {
        return isset($this->InputParameters) ? $this->InputParameters : null;
    }
    /**
     * Set InputParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInputParameter $inputParameters
     * @return \StructType\QueryDataRequest
     */
    public function setInputParameters(\ArrayType\ArrayOfInputParameter $inputParameters = null)
    {
        if (is_null($inputParameters) || (is_array($inputParameters) && empty($inputParameters))) {
            unset($this->InputParameters);
        } else {
            $this->InputParameters = $inputParameters;
        }
        return $this;
    }
    /**
     * Get QueryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryName()
    {
        return isset($this->QueryName) ? $this->QueryName : null;
    }
    /**
     * Set QueryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryName
     * @return \StructType\QueryDataRequest
     */
    public function setQueryName($queryName = null)
    {
        // validation for constraint: string
        if (!is_null($queryName) && !is_string($queryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queryName)), __LINE__);
        }
        if (is_null($queryName) || (is_array($queryName) && empty($queryName))) {
            unset($this->QueryName);
        } else {
            $this->QueryName = $queryName;
        }
        return $this;
    }
    /**
     * Get UniqueID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UniqueId|null
     */
    public function getUniqueID()
    {
        return isset($this->UniqueID) ? $this->UniqueID : null;
    }
    /**
     * Set UniqueID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\UniqueId $uniqueID
     * @return \StructType\QueryDataRequest
     */
    public function setUniqueID(\StructType\UniqueId $uniqueID = null)
    {
        if (is_null($uniqueID) || (is_array($uniqueID) && empty($uniqueID))) {
            unset($this->UniqueID);
        } else {
            $this->UniqueID = $uniqueID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QueryDataRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
