<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CaptureRequestX StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CaptureRequestX
 * @subpackage Structs
 */
class CaptureRequestX extends TemplateRequestX
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Channel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Channel;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The TransactionHint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionHint;
    /**
     * The TransactionID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for CaptureRequestX
     * @uses CaptureRequestX::setAmount()
     * @uses CaptureRequestX::setChannel()
     * @uses CaptureRequestX::setCurrency()
     * @uses CaptureRequestX::setTransactionHint()
     * @uses CaptureRequestX::setTransactionID()
     * @param float $amount
     * @param string $channel
     * @param string $currency
     * @param string $transactionHint
     * @param string $transactionID
     */
    public function __construct($amount = null, $channel = null, $currency = null, $transactionHint = null, $transactionID = null)
    {
        $this
            ->setAmount($amount)
            ->setChannel($channel)
            ->setCurrency($currency)
            ->setTransactionHint($transactionHint)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\CaptureRequestX
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->Channel;
    }
    /**
     * Set Channel value
     * @uses \EnumType\Channels::valueIsValid()
     * @uses \EnumType\Channels::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $channel
     * @return \StructType\CaptureRequestX
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Channels::valueIsValid($channel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $channel, implode(', ', \EnumType\Channels::getValidValues())), __LINE__);
        }
        $this->Channel = $channel;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @uses \EnumType\Currencies::valueIsValid()
     * @uses \EnumType\Currencies::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\CaptureRequestX
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Currencies::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $currency, implode(', ', \EnumType\Currencies::getValidValues())), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get TransactionHint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionHint()
    {
        return isset($this->TransactionHint) ? $this->TransactionHint : null;
    }
    /**
     * Set TransactionHint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionHint
     * @return \StructType\CaptureRequestX
     */
    public function setTransactionHint($transactionHint = null)
    {
        // validation for constraint: string
        if (!is_null($transactionHint) && !is_string($transactionHint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionHint)), __LINE__);
        }
        if (is_null($transactionHint) || (is_array($transactionHint) && empty($transactionHint))) {
            unset($this->TransactionHint);
        } else {
            $this->TransactionHint = $transactionHint;
        }
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\CaptureRequestX
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CaptureRequestX
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
