<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcknowledgeMessage StructType
 * @subpackage Structs
 */
class AcknowledgeMessage extends AbstractStructBase
{
    /**
     * The messageGuid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $messageGuid;
    /**
     * Constructor method for AcknowledgeMessage
     * @uses AcknowledgeMessage::setMessageGuid()
     * @param string $messageGuid
     */
    public function __construct($messageGuid = null)
    {
        $this
            ->setMessageGuid($messageGuid);
    }
    /**
     * Get messageGuid value
     * @return string
     */
    public function getMessageGuid()
    {
        return $this->messageGuid;
    }
    /**
     * Set messageGuid value
     * @param string $messageGuid
     * @return \StructType\AcknowledgeMessage
     */
    public function setMessageGuid($messageGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($messageGuid) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $messageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($messageGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($messageGuid) && !is_string($messageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageGuid)), __LINE__);
        }
        $this->messageGuid = $messageGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AcknowledgeMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
